/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.transform.slice.slice;

import java.util.Iterator;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayCursor;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scijava.function.Computers;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.transform.slice.slice.SlicesII;
import org.scijava.ops.image.util.TestImgGeneration;
import org.scijava.types.Nil;

public class SliceTest<I extends RealType<I>, O extends RealType<O>>
extends AbstractOpTest {
    private Img<ByteType> in;
    private ArrayImg<ByteType, ByteArray> out;
    public Computers.Arity1<RandomAccessibleInterval<ByteType>, RandomAccessibleInterval<ByteType>> test = (input, output) -> {
        Iterator itA = Views.iterable((RandomAccessibleInterval)input).iterator();
        Iterator itB = Views.iterable((RandomAccessibleInterval)output).iterator();
        while (itA.hasNext() && itB.hasNext()) {
            ((ByteType)itB.next()).setReal(((ByteType)itA.next()).getRealDouble());
        }
    };

    @BeforeEach
    public void setUp() {
        this.in = ArrayImgs.bytes((long[])new long[]{20L, 20L, 21L});
        this.out = ArrayImgs.bytes((long[])new long[]{20L, 20L, 21L});
        Cursor cur = this.in.cursor();
        while (cur.hasNext()) {
            cur.fwd();
            ((ByteType)cur.get()).set((byte)cur.getIntPosition(2));
        }
    }

    @Test
    public void testXYCropping() {
        Cursor cur = this.in.cursor();
        while (cur.hasNext()) {
            cur.fwd();
            ((ByteType)cur.get()).set((byte)cur.getIntPosition(2));
        }
        int[] xyAxis = new int[]{0, 1};
        Computers.Arity1 op = (Computers.Arity1)ops.typeLambda((Nil)new Nil<Computers.Arity1<RandomAccessibleInterval<ByteType>, RandomAccessibleInterval<ByteType>>>(){}, this.test);
        ops.op("transform.slice").input(this.in, (Object)op, (Object)xyAxis, (Object)true).output(this.out).compute();
        ArrayCursor cur2 = this.out.cursor();
        while (cur2.hasNext()) {
            cur2.fwd();
            Assertions.assertEquals((double)cur2.getIntPosition(2), (double)((ByteType)cur2.get()).getRealDouble(), (double)0.0);
        }
    }

    @Test
    public void testXYZCropping() {
        this.testXYZCropping(1);
        this.testXYZCropping(5);
        this.testXYZCropping(11);
        this.testXYZCropping(17);
        this.testXYZCropping(27);
    }

    private void testXYZCropping(int t) {
        ArrayImg inSequence = ArrayImgs.bytes((long[])new long[]{20L, 20L, 21L, t});
        ArrayImg outSequence = ArrayImgs.bytes((long[])new long[]{20L, 20L, 21L, t});
        Cursor cur = inSequence.cursor();
        while (cur.hasNext()) {
            cur.fwd();
            ((ByteType)cur.get()).set((byte)cur.getIntPosition(2));
        }
        int[] xyAxis = new int[]{0, 1, 2};
        Computers.Arity1 op = (Computers.Arity1)ops.typeLambda((Nil)new Nil<Computers.Arity1<RandomAccessibleInterval<ByteType>, RandomAccessibleInterval<ByteType>>>(){}, this.test);
        ops.op("transform.slice").input((Object)inSequence, (Object)op, (Object)xyAxis, (Object)true).output((Object)outSequence).compute();
        ArrayCursor cur2 = outSequence.cursor();
        while (cur2.hasNext()) {
            cur2.fwd();
            Assertions.assertEquals((double)cur2.getIntPosition(2), (double)((ByteType)cur2.get()).getRealDouble(), (double)0.0);
        }
    }

    @Test
    public void testNonZeroMinimumInterval() {
        ArrayImg img3D = ArrayImgs.bytes((long[])new long[]{50L, 50L, 3L});
        IntervalView interval2D = Views.interval((RandomAccessible)img3D, (Interval)new FinalInterval(new long[]{25L, 25L, 2L}, new long[]{35L, 35L, 2L}));
        int[] xyAxis = new int[]{0, 1};
        SlicesII hyperSlices = new SlicesII((RandomAccessibleInterval)interval2D, xyAxis, true);
        Cursor c = hyperSlices.cursor();
        int i = 0;
        while (c.hasNext()) {
            c.next();
            ++i;
        }
        Assertions.assertEquals((int)1, (int)i);
    }

    @Test
    public void testLoopThroughHyperSlices() {
        int xSize = 40;
        int ySize = 50;
        int numChannels = 3;
        int numSlices = 25;
        int numTimePoints = 5;
        ArrayImg<UnsignedByteType, ByteArray> testImage = TestImgGeneration.unsignedByteArray(true, 40L, 50L, 3L, 25L, 5L);
        int[] axisIndices = new int[]{0, 1, 3};
        SlicesII hyperSlices = new SlicesII(testImage, axisIndices, true);
        Cursor c = hyperSlices.cursor();
        int numHyperSlices = 0;
        while (c.hasNext()) {
            c.fwd();
            ++numHyperSlices;
            RandomAccessibleInterval hyperSlice = (RandomAccessibleInterval)c.get();
            Assertions.assertEquals((int)3, (int)hyperSlice.numDimensions());
            Assertions.assertEquals((long)hyperSlice.dimension(0), (long)40L);
            Assertions.assertEquals((long)hyperSlice.dimension(1), (long)50L);
            Assertions.assertEquals((long)hyperSlice.dimension(2), (long)25L);
        }
        Assertions.assertEquals((int)15, (int)numHyperSlices);
    }
}

