/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.types.adapt;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.imglib2.Cursor;
import net.imglib2.FinalDimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Test;
import org.scijava.function.Functions;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;

public class LiftFunctionsToRAITest<I extends RealType<I>>
extends AbstractOpTest {
    public final Function<I, DoubleType> testOp = in -> new DoubleType(10.0);
    public final BiFunction<I, I, DoubleType> testOp2 = (in1, in2) -> new DoubleType(20.0);
    public final Functions.Arity3<I, I, I, DoubleType> testOp3 = (in1, in2, in3) -> new DoubleType(30.0);
    public final Functions.Arity4<I, I, I, I, DoubleType> testOp4 = (in1, in2, in3, in4) -> new DoubleType(40.0);
    public final Functions.Arity5<I, I, I, I, I, DoubleType> testOp5 = (in1, in2, in3, in4, in5) -> new DoubleType(50.0);

    @Test
    public void testLiftFunction1ToRAI() {
        RandomAccessibleInterval input = (RandomAccessibleInterval)ops.op("create.img").input((Object)new FinalDimensions(new int[]{3, 3}), (Object)new DoubleType()).outType((Nil)new Nil<Img<DoubleType>>(){}).apply();
        RandomAccessibleInterval output = (RandomAccessibleInterval)ops.op("test.function.liftImg").input((Object)input).outType((Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){}).apply();
        Cursor cursor = Views.flatIterable((RandomAccessibleInterval)output).cursor();
        while (cursor.hasNext()) {
            assert (((DoubleType)cursor.next()).get() == 10.0);
        }
    }

    @Test
    public void testLiftFunction2ToRAI() {
        RandomAccessibleInterval input = (RandomAccessibleInterval)ops.op("create.img").input((Object)new FinalDimensions(new int[]{3, 3}), (Object)new DoubleType()).outType((Nil)new Nil<Img<DoubleType>>(){}).apply();
        RandomAccessibleInterval output = (RandomAccessibleInterval)ops.op("test.function.liftImg").input((Object)input, (Object)input).outType((Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){}).apply();
        Cursor cursor = Views.flatIterable((RandomAccessibleInterval)output).cursor();
        while (cursor.hasNext()) {
            assert (((DoubleType)cursor.next()).get() == 20.0);
        }
    }

    @Test
    public void testLiftFunction3ToRAI() {
        RandomAccessibleInterval input = (RandomAccessibleInterval)ops.op("create.img").input((Object)new FinalDimensions(new int[]{3, 3}), (Object)new DoubleType()).outType((Nil)new Nil<Img<DoubleType>>(){}).apply();
        RandomAccessibleInterval output = (RandomAccessibleInterval)ops.op("test.function.liftImg").input((Object)input, (Object)input, (Object)input).outType((Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){}).apply();
        Cursor cursor = Views.flatIterable((RandomAccessibleInterval)output).cursor();
        while (cursor.hasNext()) {
            assert (((DoubleType)cursor.next()).get() == 30.0);
        }
    }

    @Test
    public void testLiftFunction4ToRAI() {
        RandomAccessibleInterval input = (RandomAccessibleInterval)ops.op("create.img").input((Object)new FinalDimensions(new int[]{3, 3}), (Object)new DoubleType()).outType((Nil)new Nil<Img<DoubleType>>(){}).apply();
        RandomAccessibleInterval output = (RandomAccessibleInterval)ops.op("test.function.liftImg").input((Object)input, (Object)input, (Object)input, (Object)input).outType((Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){}).apply();
        Cursor cursor = Views.flatIterable((RandomAccessibleInterval)output).cursor();
        while (cursor.hasNext()) {
            assert (((DoubleType)cursor.next()).get() == 40.0);
        }
    }

    @Test
    public void testLiftFunction5ToRAI() {
        RandomAccessibleInterval input = (RandomAccessibleInterval)ops.op("create.img").input((Object)new FinalDimensions(new int[]{3, 3}), (Object)new DoubleType()).outType((Nil)new Nil<Img<DoubleType>>(){}).apply();
        RandomAccessibleInterval output = (RandomAccessibleInterval)ops.op("test.function.liftImg").input((Object)input, (Object)input, (Object)input, (Object)input, (Object)input).outType((Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){}).apply();
        Cursor cursor = Views.flatIterable((RandomAccessibleInterval)output).cursor();
        while (cursor.hasNext()) {
            assert (((DoubleType)cursor.next()).get() == 50.0);
        }
    }
}

