/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.util;

import java.math.BigInteger;
import java.util.Random;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.basictypeaccess.LongAccess;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.img.cell.CellCursor;
import net.imglib2.img.cell.CellImg;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.img.list.ListImg;
import net.imglib2.img.list.ListImgFactory;
import net.imglib2.img.list.ListRandomAccess;
import net.imglib2.type.NativeType;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.Unsigned128BitType;
import net.imglib2.type.numeric.integer.Unsigned12BitType;
import net.imglib2.type.numeric.integer.Unsigned2BitType;
import net.imglib2.type.numeric.integer.Unsigned4BitType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.integer.UnsignedVariableBitLengthType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import org.scijava.common3.MersenneTwisterFast;
import org.scijava.ops.image.util.UnboundedIntegerType;

public final class TestImgGeneration {
    private static int SEED = 17;

    private TestImgGeneration() {
    }

    public static ArrayImg<BitType, LongArray> bitArray(boolean fill, long ... dims) {
        ArrayImg bits = ArrayImgs.bits((long[])dims);
        if (fill) {
            MersenneTwisterFast betterRNG = new MersenneTwisterFast(15855310L);
            for (BitType b : bits) {
                b.set(betterRNG.nextBoolean());
            }
        }
        return bits;
    }

    public static ArrayImg<Unsigned2BitType, LongArray> unsigned2BitArray(boolean fill, long ... dims) {
        ArrayImg bits = ArrayImgs.unsigned2Bits((long[])dims);
        if (fill) {
            MersenneTwisterFast betterRNG = new MersenneTwisterFast(15855310L);
            for (Unsigned2BitType b : bits) {
                b.set(betterRNG.nextLong());
            }
        }
        return bits;
    }

    public static ArrayImg<Unsigned4BitType, LongArray> unsigned4BitArray(boolean fill, long ... dims) {
        ArrayImg bits = ArrayImgs.unsigned4Bits((long[])dims);
        if (fill) {
            MersenneTwisterFast betterRNG = new MersenneTwisterFast(15855310L);
            for (Unsigned4BitType b : bits) {
                b.set(betterRNG.nextLong());
            }
        }
        return bits;
    }

    public static ArrayImg<Unsigned12BitType, LongArray> unsigned12BitArray(boolean fill, long ... dims) {
        ArrayImg bits = ArrayImgs.unsigned12Bits((long[])dims);
        if (fill) {
            MersenneTwisterFast betterRNG = new MersenneTwisterFast(15855310L);
            for (Unsigned12BitType b : bits) {
                b.set(betterRNG.nextLong());
            }
        }
        return bits;
    }

    public static ArrayImg<Unsigned128BitType, LongArray> unsigned128BitArray(boolean fill, long ... dims) {
        ArrayImg bits = ArrayImgs.unsigned128Bits((long[])dims);
        if (fill) {
            MersenneTwisterFast betterRNG = new MersenneTwisterFast(15855310L);
            for (Unsigned128BitType b : bits) {
                BigInteger big = BigInteger.valueOf(betterRNG.nextLong());
                b.set(big);
            }
        }
        return bits;
    }

    public static ArrayImg<ByteType, ByteArray> byteArray(boolean fill, long ... dims) {
        byte[] array = new byte[(int)Intervals.numElements((Dimensions)new FinalInterval(dims))];
        if (fill) {
            Random r = new Random(SEED);
            r.nextBytes(array);
        }
        return ArrayImgs.bytes((byte[])array, (long[])dims);
    }

    public static ArrayImg<UnsignedByteType, ByteArray> unsignedByteArray(boolean fill, long ... dims) {
        byte[] array = new byte[(int)Intervals.numElements((Dimensions)new FinalInterval(dims))];
        if (fill) {
            Random r = new Random(SEED);
            r.nextBytes(array);
        }
        return ArrayImgs.unsignedBytes((byte[])array, (long[])dims);
    }

    public static ArrayImg<IntType, IntArray> intArray(boolean fill, long ... dims) {
        int[] array = new int[(int)Intervals.numElements((Dimensions)new FinalInterval(dims))];
        if (fill) {
            Random r = new Random(SEED);
            for (int i = 0; i < array.length; ++i) {
                array[i] = r.nextInt();
            }
        }
        return ArrayImgs.ints((int[])array, (long[])dims);
    }

    public static ArrayImg<UnsignedIntType, IntArray> unsignedIntArray(boolean fill, long ... dims) {
        int[] array = new int[(int)Intervals.numElements((Dimensions)new FinalInterval(dims))];
        if (fill) {
            Random r = new Random(SEED);
            for (int i = 0; i < array.length; ++i) {
                array[i] = r.nextInt();
            }
        }
        return ArrayImgs.unsignedInts((int[])array, (long[])dims);
    }

    public CellImg<ByteType, ?> byteCell(boolean fill, long ... dims) {
        CellImg img = new CellImgFactory((NativeType)new ByteType()).create(dims);
        if (fill) {
            Random r = new Random(SEED);
            CellCursor c = img.cursor();
            while (c.hasNext()) {
                ((ByteType)c.next()).set((byte)r.nextInt());
            }
        }
        return img;
    }

    public CellImg<ByteType, ?> byteCell(boolean fill, int[] cellDims, long ... dims) {
        CellImg img = new CellImgFactory((NativeType)new ByteType(), cellDims).create(dims);
        if (fill) {
            Random r = new Random(SEED);
            CellCursor c = img.cursor();
            while (c.hasNext()) {
                ((ByteType)c.next()).set((byte)r.nextInt());
            }
        }
        return img;
    }

    public static ArrayImg<DoubleType, DoubleArray> doubleArray(boolean fill, long ... dims) {
        double[] array = new double[(int)Intervals.numElements((Dimensions)new FinalInterval(dims))];
        if (fill) {
            Random r = new Random(SEED);
            for (int i = 0; i < array.length; ++i) {
                array[i] = r.nextDouble();
            }
        }
        return ArrayImgs.doubles((double[])array, (long[])dims);
    }

    public static ArrayImg<LongType, LongArray> longArray(boolean fill, long ... dims) {
        long[] array = new long[(int)Intervals.numElements((Dimensions)new FinalInterval(dims))];
        if (fill) {
            Random r = new Random(SEED);
            for (int i = 0; i < array.length; ++i) {
                array[i] = r.nextLong();
            }
        }
        return ArrayImgs.longs((long[])array, (long[])dims);
    }

    public static ArrayImg<UnsignedLongType, LongArray> unsignedLongArray(boolean fill, long ... dims) {
        long[] array = new long[(int)Intervals.numElements((Dimensions)new FinalInterval(dims))];
        if (fill) {
            Random r = new Random(SEED);
            for (int i = 0; i < array.length; ++i) {
                array[i] = r.nextLong();
            }
        }
        return ArrayImgs.unsignedLongs((long[])array, (long[])dims);
    }

    public static ArrayImg<ShortType, ShortArray> shortArray(boolean fill, long ... dims) {
        short[] array = new short[(int)Intervals.numElements((Dimensions)new FinalInterval(dims))];
        if (fill) {
            Random r = new Random(SEED);
            for (int i = 0; i < array.length; ++i) {
                array[i] = (short)r.nextInt();
            }
        }
        return ArrayImgs.shorts((short[])array, (long[])dims);
    }

    public static ArrayImg<UnsignedShortType, ShortArray> unsignedShortArray(boolean fill, long ... dims) {
        short[] array = new short[(int)Intervals.numElements((Dimensions)new FinalInterval(dims))];
        if (fill) {
            Random r = new Random(SEED);
            for (int i = 0; i < array.length; ++i) {
                array[i] = (short)r.nextInt();
            }
        }
        return ArrayImgs.unsignedShorts((short[])array, (long[])dims);
    }

    public static ArrayImg<UnsignedVariableBitLengthType, LongArray> unsignedVariableBitLengthTypeArray(boolean fill, int nbits, long ... dims) {
        long[] array = new long[(int)Intervals.numElements((Dimensions)new FinalInterval(dims))];
        if (fill) {
            Random r = new Random(SEED);
            for (int i = 0; i < array.length; ++i) {
                array[i] = (long)((double)r.nextInt() % Math.pow(2.0, nbits));
            }
        }
        LongArray l = new LongArray(array);
        return ArrayImgs.unsignedVariableBitLengths((LongAccess)l, (int)nbits, (long[])dims);
    }

    public static ListImg<UnboundedIntegerType> generateUnboundedIntegerTypeListTestImg(boolean fill, long ... dims) {
        ListImg l = new ListImgFactory((Object)new UnboundedIntegerType()).create(dims);
        BigInteger[] array = new BigInteger[(int)Intervals.numElements((long[])dims)];
        ListRandomAccess ra = l.randomAccess();
        if (fill) {
            MersenneTwisterFast betterRNG = new MersenneTwisterFast(15855310L);
            int i = 0;
            while ((long)i < Intervals.numElements((long[])dims)) {
                BigInteger val = BigInteger.valueOf(betterRNG.nextLong());
                ((UnboundedIntegerType)ra.get()).set(val);
                ra.fwd(0);
                ++i;
            }
        }
        return l;
    }

    public static Img<UnsignedByteType> randomlyFilledUnsignedByteWithSeed(long[] dims, long tempSeed) {
        ArrayImg img = ArrayImgs.unsignedBytes((long[])dims);
        Random rand = new Random(tempSeed);
        Cursor cursor = img.cursor();
        while (cursor.hasNext()) {
            ((UnsignedByteType)cursor.next()).set(rand.nextInt((int)((UnsignedByteType)img.firstElement()).getMaxValue()));
        }
        return img;
    }

    public static ArrayImg<FloatType, FloatArray> floatArray(boolean fill, long ... dims) {
        float[] array = new float[(int)Intervals.numElements((Dimensions)new FinalInterval(dims))];
        if (fill) {
            Random r = new Random(SEED);
            for (int i = 0; i < array.length; ++i) {
                array[i] = r.nextFloat();
            }
        }
        return ArrayImgs.floats((float[])array, (long[])dims);
    }
}

