/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.coloc.saca;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import org.scijava.ops.image.coloc.IntComparator;

final class WtKendallTau {
    private static final Comparator<double[]> SORT_X = (row1, row2) -> Double.compare(row1[0], row2[0]);
    private static final Comparator<double[]> SORT_Y = (row1, row2) -> Double.compare(row1[1], row2[1]);

    WtKendallTau() {
    }

    public static double calculate(double[] X, double[] Y, double[] W, double[][] combinedData, int[] rankedindex, double[] rankedw, int[] index1, int[] index2, double[] w1, double[] w2, double[] cumw, Random rng) {
        double[][] rankedData = WtKendallTau.rank(X, Y, W, combinedData, rng);
        for (int i = 0; i < X.length; ++i) {
            rankedindex[i] = (int)rankedData[i][0];
            rankedw[i] = rankedData[i][2];
        }
        double swap = WtKendallTau.sort(rankedindex, rankedw, Integer::compare, index1, index2, w1, w2, cumw);
        double tw = WtKendallTau.totw(W) / 2.0;
        double tauTemp = (tw - 2.0 * swap) / tw;
        if (Double.isNaN(tauTemp)) {
            tauTemp = 0.0;
        }
        double tau = tauTemp;
        return tau;
    }

    private static double totw(double[] w) {
        double sumw = 0.0;
        double sumsquarew = 0.0;
        for (int i = 0; i < w.length; ++i) {
            sumw += w[i];
            sumsquarew += w[i] * w[i];
        }
        double result = sumw * sumw - sumsquarew;
        return result;
    }

    private static double[][] rank(double[] IX, double[] IY, double[] IW, double[][] combinedData, Random rng) {
        for (int i = 0; i < IX.length; ++i) {
            combinedData[i][0] = IX[i];
            combinedData[i][1] = IY[i];
            combinedData[i][2] = IW[i];
        }
        Arrays.sort(combinedData, SORT_X);
        WtKendallTau.rank1D(combinedData, 0, rng);
        Arrays.sort(combinedData, SORT_Y);
        WtKendallTau.rank1D(combinedData, 1, rng);
        return combinedData;
    }

    private static void rank1D(double[][] combinedData, int dim, Random rng) {
        int start = 0;
        int end = 1;
        int rank = 1;
        while (start < combinedData.length) {
            int i;
            if (end < combinedData.length && combinedData[start][dim] == combinedData[end][dim]) {
                while (++end < combinedData.length && combinedData[start][dim] == combinedData[end][dim]) {
                }
                for (i = start; i < end - 1; ++i) {
                    int newIndex = start + rng.nextInt(end - start);
                    double[] tmp = combinedData[i];
                    combinedData[i] = combinedData[newIndex];
                    combinedData[newIndex] = tmp;
                }
                rank += end - start;
            }
            for (i = start; i < end; ++i) {
                combinedData[i][dim] = rank++;
            }
            start = end++;
        }
    }

    private static double sort(int[] data, double[] weight, IntComparator comparator, int[] index1, int[] index2, double[] w1, double[] w2, double[] cumw) {
        int i;
        double swap = 0.0;
        int n = data.length;
        int step = 1;
        for (i = 0; i < n; ++i) {
            index1[i] = data[i];
            w1[i] = weight[i];
        }
        while (step < n) {
            int begin = 0;
            int k = 0;
            cumw[0] = w1[0];
            for (i = 1; i < n; ++i) {
                cumw[i] = cumw[i - 1] + w1[i];
            }
            while (true) {
                int begin2;
                int end;
                if ((end = (begin2 = begin + step) + step) > n) {
                    if (begin2 > n) break;
                    end = n;
                }
                i = begin;
                int j = begin2;
                while (i < begin2 && j < end) {
                    if (comparator.compare(index1[i], index1[j]) > 0) {
                        double tempswap = i == 0 ? w1[j] * cumw[begin2 - 1] : w1[j] * (cumw[begin2 - 1] - cumw[i - 1]);
                        swap += tempswap;
                        index2[k] = index1[j];
                        w2[k++] = w1[j++];
                        continue;
                    }
                    index2[k] = index1[i];
                    w2[k++] = w1[i++];
                }
                if (i < begin2) {
                    while (i < begin2) {
                        index2[k] = index1[i];
                        w2[k++] = w1[i++];
                    }
                } else {
                    while (j < end) {
                        index2[k] = index1[j];
                        w2[k++] = w1[j++];
                    }
                }
                begin = end;
            }
            if (k < n) {
                while (k < n) {
                    index2[k] = index1[k];
                    w2[k] = w1[k];
                    ++k;
                }
            }
            for (i = 0; i < n; ++i) {
                index1[i] = index2[i];
                w1[i] = w2[i];
            }
            step *= 2;
        }
        return swap;
    }
}

