/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.deconvolve;

import java.util.function.BiFunction;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import org.scijava.function.Computers;
import org.scijava.function.Inplaces;
import org.scijava.ops.image.deconvolve.AccelerationState;
import org.scijava.ops.spi.OpDependency;

public class VectorAccelerator<T extends RealType<T>>
implements Inplaces.Arity1<AccelerationState<T>> {
    @OpDependency(name="copy.rai")
    private Computers.Arity1<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>> copyOp;
    @OpDependency(name="create.img")
    private BiFunction<Dimensions, T, Img<T>> create;

    public void mutate(AccelerationState<T> state) {
        this.accelerate(state);
    }

    private void initialize(AccelerationState<T> state) {
        if (state.ykPrediction() == null) {
            long[] temp = new long[state.ykIterated().numDimensions()];
            RealType type = (RealType)Util.getTypeFromInterval(state.ykIterated());
            state.ykIterated().dimensions(temp);
            FinalDimensions dims = new FinalDimensions(temp);
            state.ykPrediction(this.create.apply((Dimensions)dims, (Dimensions)type));
            state.xkm1Previous(this.create.apply((Dimensions)dims, (Dimensions)type));
            state.ykPrediction(this.create.apply((Dimensions)dims, (Dimensions)type));
            state.gk(this.create.apply((Dimensions)dims, (Dimensions)type));
            state.hkVector(this.create.apply((Dimensions)dims, (Dimensions)type));
        }
    }

    private void accelerate(AccelerationState<T> state) {
        if (state.ykPrediction() != null) {
            double accelerationFactor = this.computeAccelerationFactor(state);
            if (accelerationFactor < 0.0) {
                state.gkm1(null);
                accelerationFactor = 0.0;
            }
            if (accelerationFactor > 1.0) {
                accelerationFactor = 1.0;
            }
            state.accelerationFactor(accelerationFactor);
        }
        RandomAccessibleInterval<T> xk_estimate = state.ykIterated();
        if (state.accelerationFactor() > 0.0) {
            this.Subtract(xk_estimate, (RandomAccessibleInterval<T>)state.xkm1Previous(), (RandomAccessibleInterval<T>)state.hkVector());
            state.ykPrediction(this.AddAndScale(xk_estimate, state.hkVector(), (float)state.accelerationFactor()));
        } else {
            this.initialize(state);
            this.copyOp.compute(xk_estimate, state.ykPrediction());
        }
        this.copyOp.compute(xk_estimate, state.xkm1Previous());
        this.copyOp.compute(state.ykPrediction(), state.ykIterated());
    }

    private double computeAccelerationFactor(AccelerationState<T> state) {
        this.Subtract(state.ykIterated(), (RandomAccessibleInterval<T>)state.ykPrediction(), (RandomAccessibleInterval<T>)state.gk());
        double result = 0.0;
        if (state.gkm1() != null) {
            double numerator = this.DotProduct(state.gk(), state.gkm1());
            double denominator = this.DotProduct(state.gkm1(), state.gkm1());
            result = numerator / denominator;
        }
        state.gkm1(state.gk().copy());
        return result;
    }

    private double DotProduct(Img<T> image1, Img<T> image2) {
        Cursor cursorImage1 = image1.cursor();
        Cursor cursorImage2 = image2.cursor();
        double dotProduct = 0.0;
        while (cursorImage1.hasNext()) {
            cursorImage1.fwd();
            cursorImage2.fwd();
            float val1 = ((RealType)cursorImage1.get()).getRealFloat();
            float val2 = ((RealType)cursorImage2.get()).getRealFloat();
            dotProduct += (double)(val1 * val2);
        }
        return dotProduct;
    }

    private void Subtract(RandomAccessibleInterval<T> a, RandomAccessibleInterval<T> input, RandomAccessibleInterval<T> output) {
        Cursor cursorA = Views.iterable(a).cursor();
        Cursor cursorInput = Views.iterable(input).cursor();
        Cursor cursorOutput = Views.iterable(output).cursor();
        while (cursorA.hasNext()) {
            cursorA.fwd();
            cursorInput.fwd();
            cursorOutput.fwd();
            ((RealType)cursorOutput.get()).set((Type)((RealType)cursorA.get()));
            ((RealType)cursorOutput.get()).sub((Object)((RealType)cursorInput.get()));
        }
    }

    private Img<T> AddAndScale(RandomAccessibleInterval<T> img1, Img<T> img2, float a) {
        Img<T> out = this.create.apply((Dimensions)img1, (RandomAccessibleInterval<T>)((RealType)Util.getTypeFromInterval(img1)));
        Cursor cursor1 = Views.iterable(img1).cursor();
        Cursor cursor2 = img2.cursor();
        Cursor cursorOut = out.cursor();
        while (cursor1.hasNext()) {
            cursor1.fwd();
            cursor2.fwd();
            cursorOut.fwd();
            float val1 = ((RealType)cursor1.get()).getRealFloat();
            float val2 = ((RealType)cursor2.get()).getRealFloat();
            float val3 = Math.max(val1 + a * val2, 1.0E-4f);
            ((RealType)cursorOut.get()).setReal(val3);
        }
        return out;
    }
}

