/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.features.hog;

import java.util.ArrayList;
import java.util.function.BiFunction;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.gradient.PartialDerivative;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;
import net.imglib2.view.composite.GenericComposite;
import org.scijava.concurrent.Parallelization;
import org.scijava.function.Computers;
import org.scijava.function.Inplaces;
import org.scijava.ops.image.thread.chunker.Chunk;
import org.scijava.ops.image.thread.chunker.CursorBasedChunk;
import org.scijava.ops.spi.OpDependency;

public class HistogramOfOrientedGradients2D<T extends RealType<T>>
implements Computers.Arity3<RandomAccessibleInterval<T>, Integer, Integer, RandomAccessibleInterval<T>> {
    @OpDependency(name="create.img")
    private BiFunction<Dimensions, FloatType, RandomAccessibleInterval<FloatType>> createImgOp;
    @OpDependency(name="thread.chunker")
    private Inplaces.Arity2_1<Chunk, Long> chunkerOp;
    private Converter<T, FloatType> converterToFloat;
    private Converter<GenericComposite<FloatType>, FloatType> converterGetMax;

    public void compute(RandomAccessibleInterval<T> in, Integer numOrientations, Integer spanOfNeighborhood, RandomAccessibleInterval<T> out) {
        FinalInterval imgOpInterval = new FinalInterval(new long[]{in.dimension(0), in.dimension(1)});
        this.converterToFloat = (arg0, arg1) -> arg1.setReal(arg0.getRealFloat());
        this.converterGetMax = (input, output) -> {
            int idx = 0;
            float max = 0.0f;
            int i = 0;
            while ((long)i < in.dimension(2)) {
                if (Math.abs(((FloatType)input.get((long)i)).getRealFloat()) > max) {
                    max = Math.abs(((FloatType)input.get((long)i)).getRealFloat());
                    idx = i;
                }
                ++i;
            }
            output.setReal(((FloatType)input.get((long)idx)).getRealFloat());
        };
        if (in.numDimensions() > 3 || in.numDimensions() < 2) {
            throw new IllegalArgumentException("Input image is of an unsupported number of dimensions");
        }
        RandomAccessible convertedIn = Converters.convert((RandomAccessible)Views.extendMirrorDouble(in), this.converterToFloat, (Type)new FloatType());
        RandomAccessibleInterval derivative0 = this.createImgOp.apply((Dimensions)imgOpInterval, new FloatType());
        RandomAccessibleInterval derivative1 = this.createImgOp.apply((Dimensions)imgOpInterval, new FloatType());
        if (in.numDimensions() == 2) {
            PartialDerivative.gradientCentralDifference((RandomAccessible)convertedIn, derivative0, (int)0);
            PartialDerivative.gradientCentralDifference((RandomAccessible)convertedIn, derivative1, (int)1);
        } else {
            ArrayList<RandomAccessibleInterval<FloatType>> listDerivs0 = new ArrayList<RandomAccessibleInterval<FloatType>>();
            ArrayList<RandomAccessibleInterval<FloatType>> listDerivs1 = new ArrayList<RandomAccessibleInterval<FloatType>>();
            int i = 0;
            while ((long)i < in.dimension(2)) {
                RandomAccessibleInterval<FloatType> deriv0 = this.createImgOp.apply((Dimensions)imgOpInterval, new FloatType());
                RandomAccessibleInterval<FloatType> deriv1 = this.createImgOp.apply((Dimensions)imgOpInterval, new FloatType());
                PartialDerivative.gradientCentralDifference((RandomAccessible)Views.interval((RandomAccessible)convertedIn, (long[])new long[]{0L, 0L, i}, (long[])new long[]{in.max(0), in.max(1), i}), deriv0, (int)0);
                PartialDerivative.gradientCentralDifference((RandomAccessible)Views.interval((RandomAccessible)convertedIn, (long[])new long[]{0L, 0L, i}, (long[])new long[]{in.max(0), in.max(1), i}), deriv1, (int)1);
                listDerivs0.add(deriv0);
                listDerivs1.add(deriv1);
                ++i;
            }
            derivative0 = Converters.convert((RandomAccessibleInterval)Views.collapse((RandomAccessibleInterval)Views.stack(listDerivs0)), this.converterGetMax, (Type)new FloatType());
            derivative1 = Converters.convert((RandomAccessibleInterval)Views.collapse((RandomAccessibleInterval)Views.stack(listDerivs1)), this.converterGetMax, (Type)new FloatType());
        }
        final RandomAccessibleInterval finalderivative0 = derivative0;
        final RandomAccessibleInterval finalderivative1 = derivative1;
        final RandomAccessibleInterval<FloatType> angles = this.createImgOp.apply((Dimensions)imgOpInterval, new FloatType());
        final RandomAccessibleInterval<FloatType> magnitudes = this.createImgOp.apply((Dimensions)imgOpInterval, new FloatType());
        CursorBasedChunk chunkable = new CursorBasedChunk(){

            @Override
            public void execute(long startIndex, long stepSize, long numSteps) {
                Cursor cursorAngles = Views.flatIterable((RandomAccessibleInterval)angles).localizingCursor();
                Cursor cursorMagnitudes = Views.flatIterable((RandomAccessibleInterval)magnitudes).localizingCursor();
                Cursor cursorDerivative0 = Views.flatIterable((RandomAccessibleInterval)finalderivative0).localizingCursor();
                Cursor cursorDerivative1 = Views.flatIterable((RandomAccessibleInterval)finalderivative1).localizingCursor();
                1.setToStart(cursorAngles, startIndex);
                1.setToStart(cursorMagnitudes, startIndex);
                1.setToStart(cursorDerivative0, startIndex);
                1.setToStart(cursorDerivative1, startIndex);
                for (long i = 0L; i < numSteps; ++i) {
                    float x = ((FloatType)cursorDerivative0.get()).getRealFloat();
                    float y = ((FloatType)cursorDerivative1.get()).getRealFloat();
                    ((FloatType)cursorAngles.get()).setReal(HistogramOfOrientedGradients2D.this.getAngle(x, y));
                    ((FloatType)cursorMagnitudes.get()).setReal(HistogramOfOrientedGradients2D.this.getMagnitude(x, y));
                    cursorAngles.jumpFwd(stepSize);
                    cursorMagnitudes.jumpFwd(stepSize);
                    cursorDerivative0.jumpFwd(stepSize);
                    cursorDerivative1.jumpFwd(stepSize);
                }
            }
        };
        this.chunkerOp.mutate((Object)chunkable, (Object)Views.flatIterable(magnitudes).size());
        ArrayList<ComputeDescriptor> listCallables = new ArrayList<ComputeDescriptor>();
        RectangleShape shape = new RectangleShape(spanOfNeighborhood.intValue(), false);
        RectangleShape.NeighborhoodsAccessible neighborHood = shape.neighborhoodsRandomAccessible(angles);
        int i = 0;
        while ((long)i < in.dimension(0)) {
            listCallables.add(new ComputeDescriptor((RandomAccessibleInterval<FloatType>)Views.interval((RandomAccessible)convertedIn, in), i, (RandomAccess<FloatType>)angles.randomAccess(), (RandomAccess<FloatType>)magnitudes.randomAccess(), (RandomAccess<FloatType>)out.randomAccess(), (RandomAccess<Neighborhood<FloatType>>)neighborHood.randomAccess(), numOrientations));
            ++i;
        }
        Parallelization.getTaskExecutor().runAll(listCallables);
        listCallables.clear();
    }

    private double getAngle(double x, double y) {
        float angle = (float)Math.toDegrees(Math.atan2(x, y));
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    private double getMagnitude(double x, double y) {
        return Math.sqrt(x * x + y * y);
    }

    private class ComputeDescriptor
    implements Runnable {
        private final RandomAccessibleInterval<FloatType> in;
        private final long i;
        private final RandomAccess<FloatType> raAngles;
        private final RandomAccess<FloatType> raMagnitudes;
        private final RandomAccess<FloatType> raOut;
        private final RandomAccess<Neighborhood<FloatType>> raNeighbor;
        private final Integer numOrientations;

        public ComputeDescriptor(RandomAccessibleInterval<FloatType> in, long i, RandomAccess<FloatType> raAngles, RandomAccess<FloatType> raMagnitudes, RandomAccess<FloatType> raOut, RandomAccess<Neighborhood<FloatType>> raNeighbor, Integer numOrientations) {
            this.in = in;
            this.i = i;
            this.raAngles = raAngles;
            this.raMagnitudes = raMagnitudes;
            this.raOut = raOut;
            this.raNeighbor = raNeighbor;
            this.numOrientations = numOrientations;
        }

        @Override
        public void run() {
            FinalInterval interval = new FinalInterval(new long[]{this.in.dimension(0), this.in.dimension(1)});
            int j = 0;
            while ((long)j < this.in.dimension(1)) {
                this.raNeighbor.setPosition(new long[]{this.i, j});
                Cursor cursorNeighborHood = ((Neighborhood)this.raNeighbor.get()).cursor();
                while (cursorNeighborHood.hasNext()) {
                    cursorNeighborHood.next();
                    if (!Intervals.contains((Interval)interval, (Localizable)cursorNeighborHood)) continue;
                    this.raAngles.setPosition((Localizable)cursorNeighborHood);
                    this.raMagnitudes.setPosition((Localizable)cursorNeighborHood);
                    this.raOut.setPosition(new long[]{this.i, j, (int)((double)(((FloatType)this.raAngles.get()).getRealFloat() / (float)(360 / this.numOrientations)) - 0.5)});
                    ((FloatType)this.raOut.get()).add((FloatType)this.raMagnitudes.get());
                }
                ++j;
            }
        }
    }
}

