/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.geom.geom3d;

import java.util.function.Function;
import net.imglib2.mesh.Mesh;
import net.imglib2.type.numeric.real.DoubleType;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.scijava.function.Computers;
import org.scijava.ops.spi.OpDependency;

public class DefaultMainElongation
implements Computers.Arity1<Mesh, DoubleType> {
    @OpDependency(name="geom.secondMoment")
    private Function<Mesh, RealMatrix> inertiaTensor;

    public void compute(Mesh input, DoubleType mainElongation) {
        RealMatrix it = this.inertiaTensor.apply(input);
        EigenDecomposition ed = new EigenDecomposition(it);
        double l1 = ed.getRealEigenvalue(0) - ed.getRealEigenvalue(2) + ed.getRealEigenvalue(1);
        double l2 = ed.getRealEigenvalue(0) - ed.getRealEigenvalue(1) + ed.getRealEigenvalue(2);
        double l3 = ed.getRealEigenvalue(2) - ed.getRealEigenvalue(0) + ed.getRealEigenvalue(1);
        double g = 0.5968310365946076;
        double a = Math.pow(0.5968310365946076 * l1 * l1 / Math.sqrt(l2 * l3), 0.2);
        double b = Math.pow(0.5968310365946076 * l2 * l2 / Math.sqrt(l1 * l3), 0.2);
        mainElongation.set(1.0 - b / a);
    }
}

