/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.distancetransform;

import java.util.ArrayList;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.RealType;
import org.scijava.concurrent.Parallelization;
import org.scijava.ops.image.image.distancetransform.Phase1Runnable3DCal;
import org.scijava.ops.image.image.distancetransform.Phase2Runnable3DCal;
import org.scijava.ops.image.image.distancetransform.Phase3Runnable3DCal;

public final class DistanceTransform3DCalibration {
    private DistanceTransform3DCalibration() {
    }

    public static <B extends BooleanType<B>, T extends RealType<T>> void compute(RandomAccessibleInterval<B> in, double[] calibration, RandomAccessibleInterval<T> out) {
        double[][][] tempValues = new double[(int)in.dimension(0)][(int)out.dimension(1)][(int)out.dimension(2)];
        ArrayList<Runnable> list = new ArrayList<Runnable>();
        int z = 0;
        while ((long)z < in.dimension(2)) {
            int y = 0;
            while ((long)y < in.dimension(1)) {
                list.add(new Phase1Runnable3DCal<B>(tempValues, in, y, z, calibration));
                ++y;
            }
            ++z;
        }
        Parallelization.getTaskExecutor().runAll(list);
        list.clear();
        double[][][] tempValues_new = new double[(int)in.dimension(0)][(int)out.dimension(1)][(int)out.dimension(2)];
        int z2 = 0;
        while ((long)z2 < in.dimension(2)) {
            int x = 0;
            while ((long)x < in.dimension(0)) {
                list.add(new Phase2Runnable3DCal<T>(tempValues, tempValues_new, out, x, z2, calibration));
                ++x;
            }
            ++z2;
        }
        Parallelization.getTaskExecutor().runAll(list);
        int x = 0;
        while ((long)x < in.dimension(0)) {
            int y = 0;
            while ((long)y < in.dimension(1)) {
                list.add(new Phase3Runnable3DCal<T>(tempValues_new, out, x, y, calibration));
                ++y;
            }
            ++x;
        }
        Parallelization.getTaskExecutor().runAll(list);
    }
}

