/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.normalize;

import java.util.function.Function;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Pair;
import net.imglib2.util.Util;
import org.scijava.function.Computers;
import org.scijava.ops.image.image.normalize.NormalizeRealTypeComputer;
import org.scijava.ops.spi.OpDependency;

public class NormalizeIIComputer<I extends RealType<I>, O extends RealType<O>>
implements Computers.Arity5<RandomAccessibleInterval<I>, I, I, O, O, RandomAccessibleInterval<O>> {
    private NormalizeRealTypeComputer<I, O> normalizer;
    @OpDependency(name="stats.minMax")
    private Function<RandomAccessibleInterval<I>, Pair<I, I>> minMaxFunc;

    private double[] getBounds(RandomAccessibleInterval<I> input, I sourceMin, I sourceMax, O targetMin, O targetMax) {
        double[] result = new double[4];
        if (this.minMaxFunc != null) {
            Pair<I, I> minMax = this.minMaxFunc.apply(input);
            result[0] = (sourceMin == null ? (RealType)minMax.getA() : sourceMin).getRealDouble();
            result[1] = (sourceMax == null ? (RealType)minMax.getB() : sourceMax).getRealDouble();
        } else {
            result[0] = sourceMin.getRealDouble();
            result[1] = sourceMax.getRealDouble();
        }
        RealType first = (RealType)Util.getTypeFromInterval(input);
        result[2] = targetMin == null ? first.getMinValue() : targetMin.getRealDouble();
        result[3] = targetMax == null ? first.getMaxValue() : targetMax.getRealDouble();
        return result;
    }

    public void compute(RandomAccessibleInterval<I> input, I sourceMin, I sourceMax, O targetMin, O targetMax, RandomAccessibleInterval<O> output) {
        this.normalizer = new NormalizeRealTypeComputer();
        double[] bounds = this.getBounds(input, sourceMin, sourceMax, targetMin, targetMax);
        this.normalizer.setup(bounds[0], bounds[1], bounds[2], bounds[3]);
        LoopBuilder.setImages(input, output).multiThreaded().forEachPixel((in, out) -> this.normalizer.compute((RealType)in, (RealType)out));
    }
}

