/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.labeling;

import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.roi.IterableRegion;
import net.imglib2.roi.Regions;
import net.imglib2.roi.labeling.ImgLabeling;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.view.Views;
import org.scijava.function.Computers;
import org.scijava.function.Functions;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpDependency;

public class MergeLabeling<L, I extends IntegerType<I>, B extends BooleanType<B>>
implements Functions.Arity3<ImgLabeling<L, I>, ImgLabeling<L, I>, RandomAccessibleInterval<B>, ImgLabeling<L, I>> {
    @OpDependency(name="create.imgLabeling")
    private BiFunction<Dimensions, I, ImgLabeling<L, I>> imgLabelingCreator;
    @OpDependency(name="engine.adapt")
    private Function<Computers.Arity2<LabelingType<L>, LabelingType<L>, LabelingType<L>>, Computers.Arity2<Iterable<LabelingType<L>>, Iterable<LabelingType<L>>, Iterable<LabelingType<L>>>> adaptor;

    public ImgLabeling<L, I> apply(ImgLabeling<L, I> input1, ImgLabeling<L, I> input2, @Nullable RandomAccessibleInterval<B> mask) {
        ImgLabeling<L, I> output = this.imgLabelingCreator.apply((Dimensions)input1, (I)((IntegerType)Views.iterable((RandomAccessibleInterval)((RandomAccessibleInterval)input1.getSource())).firstElement()));
        if (mask != null) {
            IterableRegion iterable = Regions.iterable(mask);
            IterableInterval sample = Regions.sample((IterableInterval)iterable, output);
            RandomAccess randomAccess = input1.randomAccess();
            RandomAccess randomAccess2 = input2.randomAccess();
            Cursor cursor = sample.cursor();
            while (cursor.hasNext()) {
                LabelingType outLabeling = (LabelingType)cursor.next();
                randomAccess.setPosition((Localizable)cursor);
                outLabeling.addAll((Collection)randomAccess.get());
                randomAccess2.setPosition((Localizable)cursor);
                outLabeling.addAll((Collection)randomAccess2.get());
            }
        } else {
            Computers.Arity2<Iterable<LabelingType<L>>, Iterable<LabelingType<L>>, Iterable<LabelingType<L>>> adapted = this.adaptor.apply(new Computers.Arity2<LabelingType<L>, LabelingType<L>, LabelingType<L>>(){

                public void compute(LabelingType<L> input1, LabelingType<L> input2, LabelingType<L> output) {
                    output.addAll(input1);
                    output.addAll(input2);
                }
            });
            adapted.compute(input1, input2, output);
        }
        return output;
    }
}

