/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.stats;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import org.scijava.function.Computers;
import org.scijava.ops.spi.OpDependency;

public class DefaultKurtosis<I extends RealType<I>, O extends RealType<O>>
implements Computers.Arity1<RandomAccessibleInterval<I>, O> {
    @OpDependency(name="stats.stdDev")
    private Computers.Arity1<RandomAccessibleInterval<I>, O> stdDevComputer;
    @OpDependency(name="stats.moment4AboutMean")
    private Computers.Arity1<RandomAccessibleInterval<I>, O> moment4AboutMeanComputer;

    public void compute(RandomAccessibleInterval<I> input, O kurtosis) {
        kurtosis.setReal(Double.NaN);
        RealType std = (RealType)kurtosis.createVariable();
        this.stdDevComputer.compute(input, (Object)std);
        RealType moment4 = (RealType)kurtosis.createVariable();
        this.moment4AboutMeanComputer.compute(input, (Object)moment4);
        if (std.getRealDouble() != 0.0) {
            kurtosis.setReal(moment4.getRealDouble() / Math.pow(std.getRealDouble(), 4.0));
        }
    }
}

