/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.stats;

import java.util.ArrayList;
import java.util.Collections;
import net.imglib2.type.numeric.RealType;
import org.scijava.function.Computers;

public class DefaultQuantile<I extends RealType<I>, N extends Number, O extends RealType<O>>
implements Computers.Arity2<Iterable<I>, N, O> {
    public void compute(Iterable<I> input, N quantile, O output) {
        if (((Number)quantile).doubleValue() < 0.0 || ((Number)quantile).doubleValue() > 1.0) {
            throw new IllegalArgumentException("Quantile must be between 0 and 1 (inclusive) but is " + quantile);
        }
        ArrayList<Double> statistics = new ArrayList<Double>();
        for (RealType i : input) {
            statistics.add(i.getRealDouble());
        }
        output.setReal(DefaultQuantile.select(statistics, (int)((double)statistics.size() * ((Number)quantile).doubleValue())));
    }

    static double select(ArrayList<Double> array, int k) {
        int left = 0;
        int right = array.size() - 1;
        while (true) {
            if (right <= left + 1) {
                if (right == left + 1 && array.get(right) < array.get(left)) {
                    Collections.swap(array, left, right);
                }
                return array.get(k);
            }
            int middle = left + right >>> 1;
            Collections.swap(array, middle, left + 1);
            if (array.get(left) > array.get(right)) {
                Collections.swap(array, left, right);
            }
            if (array.get(left + 1) > array.get(right)) {
                Collections.swap(array, left + 1, right);
            }
            if (array.get(left) > array.get(left + 1)) {
                Collections.swap(array, left, left + 1);
            }
            int i = left + 1;
            int j = right;
            double pivot = array.get(left + 1);
            while (true) {
                if (array.get(++i) < pivot) {
                    continue;
                }
                while (array.get(--j) > pivot) {
                }
                if (j < i) break;
                Collections.swap(array, i, j);
            }
            array.set(left + 1, array.get(j));
            array.set(j, pivot);
            if (j >= k) {
                right = j - 1;
            }
            if (j > k) continue;
            left = i;
        }
    }
}

