/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.stats;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import org.scijava.function.Computers;
import org.scijava.ops.spi.OpDependency;

public class DefaultSkewness<I extends RealType<I>, O extends RealType<O>>
implements Computers.Arity1<RandomAccessibleInterval<I>, O> {
    @OpDependency(name="stats.moment3AboutMean")
    private Computers.Arity1<RandomAccessibleInterval<I>, O> moment3AboutMeanComputer;
    @OpDependency(name="stats.stdDev")
    private Computers.Arity1<RandomAccessibleInterval<I>, O> stdDevComputer;

    public void compute(RandomAccessibleInterval<I> input, O skewness) {
        RealType moment3 = (RealType)skewness.createVariable();
        this.moment3AboutMeanComputer.compute(input, (Object)moment3);
        RealType stdDev = (RealType)skewness.createVariable();
        this.stdDevComputer.compute(input, (Object)stdDev);
        skewness.setReal(Double.NaN);
        double std = stdDev.getRealDouble();
        if (std != 0.0) {
            skewness.setReal(moment3.getRealDouble() / (std * std * std));
        }
    }
}

