/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;
import edu.wisc.ssec.mcidas.McIDASUtil;

public class ABISnav
extends AREAnav {
    int itype;
    int lpsi2;
    double h;
    double re;
    double a;
    double rp;
    double cdr;
    double crd;
    double deltax;
    double deltay;
    double rflon;
    int[] ioff = new int[3];
    double sublon;
    double nstepfullres;
    double nstep;

    public ABISnav(int[] iparms) throws IllegalArgumentException {
        this(1, iparms);
    }

    public ABISnav(int ifunc, int[] iparms) throws IllegalArgumentException {
        if (ifunc != 1) {
            ifunc = 1;
        }
        if (ifunc != 1) {
            if (iparms[0] == 234) {
                this.itype = 1;
            }
            if (iparms[0] == 123) {
                this.itype = 2;
            }
            return;
        }
        this.itype = 1;
        if (iparms[0] != 1094863187) {
            throw new IllegalArgumentException("Invalid navigation type" + iparms[0]);
        }
        if (ifunc == 1) {
            for (int i = 0; i < 3; ++i) {
                this.ioff[i] = iparms[3 + i];
            }
            this.re = 6378.155;
            this.h = 42164.0 - this.re;
            this.a = 0.003367003367003367;
            this.rp = this.re / (1.0 + this.a);
            this.cdr = Math.PI / 180;
            this.crd = 57.29577951308232;
            this.lpsi2 = 1;
            double angle = 17.76;
            this.nstep = 5535.0;
            this.nstepfullres = 22141.0;
            if (iparms[7] != 0 && iparms[8] != 0 && iparms[10] != 0) {
                this.nstep = iparms[7];
                this.nstepfullres = iparms[8];
                angle = (double)iparms[10] / 10000.0;
            }
            this.deltax = angle / this.nstep;
            this.deltay = angle / this.nstep;
            this.rflon = 0.0;
            this.sublon = McIDASUtil.mcPackedIntegerToDouble(iparms[6]);
        }
    }

    @Override
    public double[][] toLatLon(double[][] linele) {
        int number = linele[0].length;
        double[][] latlon = new double[2][number];
        double[][] imglinele = this.areaCoordToImageCoord(linele);
        for (int point = 0; point < number; ++point) {
            double yk;
            double tany;
            double val2;
            double xlin = imglinele[1][point];
            double xele = imglinele[0][point];
            double xele2 = xele / 4.0;
            double xlin2 = xlin / 4.0;
            double x = this.nstep / 2.0 - xele2;
            double y = (this.nstepfullres - xlin) / 4.0 - (double)this.ioff[2] - (double)this.ioff[1] + (double)this.ioff[0];
            double xr = x;
            double yr = y;
            x = xr * (double)this.lpsi2 * this.deltax * this.cdr;
            y = yr * (double)this.lpsi2 * this.deltay * this.cdr;
            double rs = this.re + this.h;
            double tanx = Math.tan(x);
            double val1 = 1.0 + tanx * tanx;
            if (val1 * (val2 = 1.0 + (tany = Math.tan(y)) * tany * ((1.0 + this.a) * (1.0 + this.a))) > (yk = rs / this.re) * yk / (yk * yk - 1.0)) {
                latlon[0][point] = Double.NaN;
                latlon[1][point] = Double.NaN;
                continue;
            }
            double vmu = (rs - this.re * Math.sqrt(yk * yk - (yk * yk - 1.0) * val1 * val2)) / (val1 * val2);
            double cosrf = Math.cos(this.rflon * this.cdr);
            double sinrf = Math.sin(this.rflon * this.cdr);
            double xt = rs * cosrf + vmu * (tanx * sinrf - cosrf);
            double yt = rs * sinrf - vmu * (tanx * cosrf + sinrf);
            double zt = vmu * tany / Math.cos(x);
            double teta = Math.asin(zt / this.rp);
            double xfi = Math.atan(Math.tan(teta) * this.re / this.rp) * this.crd;
            double xla = -Math.atan(yt / xt) * this.crd;
            double ylat = xfi;
            double ylon = xla += this.sublon;
            latlon[0][point] = ylat;
            latlon[1][point] = -ylon;
        }
        return latlon;
    }

    @Override
    public double[][] toLinEle(double[][] latlon) {
        int number = latlon[0].length;
        double[][] linele = new double[2][number];
        for (int point = 0; point < number; ++point) {
            double r2;
            double x1 = latlon[0][point];
            double y1 = latlon[1][point];
            double xfi = x1 * this.cdr;
            double xla = (y1 += this.sublon) * this.cdr;
            double rom = this.re * this.rp / Math.sqrt(this.rp * this.rp * Math.cos(xfi) * Math.cos(xfi) + this.re * this.re * Math.sin(xfi) * Math.sin(xfi));
            double y = Math.sqrt(this.h * this.h + rom * rom - 2.0 * this.h * rom * Math.cos(xfi) * Math.cos(xla));
            double r1 = y * y + rom * rom;
            if (r1 > (r2 = this.h * this.h)) {
                linele[1][point] = Double.NaN;
                linele[0][point] = Double.NaN;
                continue;
            }
            double rs = this.re + this.h;
            double reph = this.re;
            double rpph = this.rp;
            double coslo = Math.cos(this.rflon * this.cdr);
            double sinlo = Math.sin(this.rflon * this.cdr);
            double teta = Math.atan(rpph / reph * Math.tan(xfi));
            double xt = reph * Math.cos(teta) * Math.cos(xla);
            double yt = reph * Math.cos(teta) * Math.sin(xla);
            double zt = rpph * Math.sin(teta);
            double px = Math.atan((coslo * (yt - rs * sinlo) - (xt - rs * coslo) * sinlo) / (sinlo * (yt - rs * sinlo) + (xt - rs * coslo) * coslo));
            double py = Math.atan(zt * ((Math.tan(px) * sinlo - coslo) / (xt - rs * coslo)) * Math.cos(px));
            double xr = (px *= this.crd) / (this.deltax * (double)this.lpsi2);
            double yr = (py *= this.crd) / (this.deltay * (double)this.lpsi2);
            xr = this.nstep / 2.0 - xr;
            yr = yr + (double)this.ioff[2] + (double)this.ioff[1] - (double)this.ioff[0];
            linele[1][point] = yr = this.nstepfullres - yr * 4.0;
            linele[0][point] = xr *= 4.0;
        }
        return this.imageCoordToAreaCoord(linele, linele);
    }

    @Override
    public float[][] toLatLon(float[][] linele) {
        int number = linele[0].length;
        float[][] latlon = new float[2][number];
        float[][] imglinele = this.areaCoordToImageCoord(linele);
        for (int point = 0; point < number; ++point) {
            double yk;
            double tany;
            double val2;
            double xlin = imglinele[1][point];
            double xele = imglinele[0][point];
            double xele2 = xele / 4.0;
            double xlin2 = xlin / 4.0;
            double x = this.nstep / 2.0 - xele2;
            double y = (this.nstepfullres - xlin) / 4.0 - (double)this.ioff[2] - (double)this.ioff[1] + (double)this.ioff[0];
            double xr = x;
            double yr = y;
            x = xr * (double)this.lpsi2 * this.deltax * this.cdr;
            y = yr * (double)this.lpsi2 * this.deltay * this.cdr;
            double rs = this.re + this.h;
            double tanx = Math.tan(x);
            double val1 = 1.0 + tanx * tanx;
            if (val1 * (val2 = 1.0 + (tany = Math.tan(y)) * tany * ((1.0 + this.a) * (1.0 + this.a))) > (yk = rs / this.re) * yk / (yk * yk - 1.0)) {
                latlon[0][point] = Float.NaN;
                latlon[1][point] = Float.NaN;
                continue;
            }
            double vmu = (rs - this.re * Math.sqrt(yk * yk - (yk * yk - 1.0) * val1 * val2)) / (val1 * val2);
            double cosrf = Math.cos(this.rflon * this.cdr);
            double sinrf = Math.sin(this.rflon * this.cdr);
            double xt = rs * cosrf + vmu * (tanx * sinrf - cosrf);
            double yt = rs * sinrf - vmu * (tanx * cosrf + sinrf);
            double zt = vmu * tany / Math.cos(x);
            double teta = Math.asin(zt / this.rp);
            double xfi = Math.atan(Math.tan(teta) * this.re / this.rp) * this.crd;
            double xla = -Math.atan(yt / xt) * this.crd;
            double ylat = xfi;
            double ylon = xla += this.sublon;
            latlon[0][point] = (float)ylat;
            latlon[1][point] = (float)(-ylon);
        }
        return latlon;
    }

    @Override
    public float[][] toLinEle(float[][] latlon) {
        int number = latlon[0].length;
        float[][] linele = new float[2][number];
        for (int point = 0; point < number; ++point) {
            double r2;
            double x1 = latlon[0][point];
            double y1 = latlon[1][point];
            double xfi = x1 * this.cdr;
            double xla = (y1 += this.sublon) * this.cdr;
            double rom = this.re * this.rp / Math.sqrt(this.rp * this.rp * Math.cos(xfi) * Math.cos(xfi) + this.re * this.re * Math.sin(xfi) * Math.sin(xfi));
            double y = Math.sqrt(this.h * this.h + rom * rom - 2.0 * this.h * rom * Math.cos(xfi) * Math.cos(xla));
            double r1 = y * y + rom * rom;
            if (r1 > (r2 = this.h * this.h)) {
                linele[1][point] = Float.NaN;
                linele[0][point] = Float.NaN;
                continue;
            }
            double rs = this.re + this.h;
            double reph = this.re;
            double rpph = this.rp;
            double coslo = Math.cos(this.rflon * this.cdr);
            double sinlo = Math.sin(this.rflon * this.cdr);
            double teta = Math.atan(rpph / reph * Math.tan(xfi));
            double xt = reph * Math.cos(teta) * Math.cos(xla);
            double yt = reph * Math.cos(teta) * Math.sin(xla);
            double zt = rpph * Math.sin(teta);
            double px = Math.atan((coslo * (yt - rs * sinlo) - (xt - rs * coslo) * sinlo) / (sinlo * (yt - rs * sinlo) + (xt - rs * coslo) * coslo));
            double py = Math.atan(zt * ((Math.tan(px) * sinlo - coslo) / (xt - rs * coslo)) * Math.cos(px));
            double xr = (px *= this.crd) / (this.deltax * (double)this.lpsi2);
            double yr = (py *= this.crd) / (this.deltay * (double)this.lpsi2);
            xr = this.nstep / 2.0 - xr;
            yr = yr + (double)this.ioff[2] + (double)this.ioff[1] - (double)this.ioff[0];
            yr = this.nstepfullres - yr * 4.0;
            linele[1][point] = (float)yr;
            linele[0][point] = (float)(xr *= 4.0);
        }
        return this.imageCoordToAreaCoord(linele, linele);
    }
}

