/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayEvent;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.MouseBehavior;
import visad.ProjectionControl;
import visad.RendererSourceListener;
import visad.VisADException;
import visad.VisADRay;
import visad.browser.Convert;
import visad.java2d.MouseBehaviorJ2D;

public class MouseHelper
implements RendererSourceListener {
    MouseBehavior behavior;
    DisplayRenderer display_renderer;
    DisplayImpl display;
    private ProjectionControl proj;
    protected DataRenderer direct_renderer = null;
    protected double[] tstart;
    protected int start_x;
    protected int start_y;
    protected double xmul;
    protected double ymul;
    protected double xymul;
    private boolean mouseEntered;
    protected int mouseModifiers;
    private boolean mode2D;
    public static final int NONE = -1;
    public static final int ROTATE = 0;
    public static final int ZOOM = 1;
    public static final int TRANSLATE = 2;
    public static final int CURSOR_TRANSLATE = 3;
    public static final int CURSOR_ZOOM = 4;
    public static final int CURSOR_ROTATE = 5;
    public static final int DIRECT = 6;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    protected boolean[] actual_button = new boolean[]{false, false, false};
    protected int virtual_button = -1;
    protected boolean[] function = new boolean[]{false, false, false, false, false, false, false};
    protected boolean[] old_function = new boolean[]{false, false, false, false, false, false, false};
    private boolean enable_combos = true;
    int[][][] function_map = new int[][][]{new int[][]{{0, 1}, {2, -1}}, new int[][]{{3, 4}, {5, -1}}, new int[][]{{6, 6}, {6, 6}}};

    public MouseHelper(DisplayRenderer r, MouseBehavior b) {
        this.behavior = b;
        this.display_renderer = r;
        this.display = this.display_renderer.getDisplay();
        this.proj = this.display.getProjectionControl();
        this.mode2D = this.display_renderer.getMode2D();
        this.display.addRendererSourceListener(this);
    }

    public MouseBehavior getMouseBehavior() {
        return this.behavior;
    }

    public DisplayImpl getDisplay() {
        return this.display;
    }

    public DisplayRenderer getDisplayRenderer() {
        return this.display_renderer;
    }

    public ProjectionControl getProjectionControl() {
        return this.proj;
    }

    public boolean getMode2D() {
        return this.mode2D;
    }

    public void processEvent(AWTEvent event) {
        this.processEvent(event, 0);
    }

    public void processEvent(AWTEvent event, int remoteId) {
        if (this.getMouseBehavior() == null) {
            return;
        }
        if (event instanceof MouseEvent && ((MouseEvent)event).getID() == 501) {
            this.start_x = 0;
            this.start_y = 0;
            this.setTranslationFactor(this.start_x, this.start_y);
        }
        if (!(event instanceof MouseEvent)) {
            System.out.println("MouseHelper.processStimulus: non-MouseEvent");
            return;
        }
        MouseEvent mouse_event = (MouseEvent)event;
        int event_id = event.getID();
        if (event_id == 504) {
            this.mouseEntered = true;
            try {
                DisplayEvent e = new DisplayEvent((Display)this.getDisplay(), 19, mouse_event, remoteId);
                this.getDisplay().notifyListeners(e);
            }
            catch (VisADException e) {
            }
            catch (RemoteException e) {
                // empty catch block
            }
            return;
        }
        if (event_id == 505) {
            this.mouseEntered = false;
            try {
                DisplayEvent e = new DisplayEvent((Display)this.getDisplay(), 20, mouse_event, remoteId);
                this.getDisplay().notifyListeners(e);
            }
            catch (VisADException e) {
            }
            catch (RemoteException e) {
                // empty catch block
            }
            return;
        }
        if (event_id == 503) {
            try {
                DisplayEvent e = new DisplayEvent((Display)this.getDisplay(), 21, mouse_event, remoteId);
                this.getDisplay().notifyListeners(e);
            }
            catch (VisADException e) {
            }
            catch (RemoteException e) {
                // empty catch block
            }
            return;
        }
        if (event_id == 501 || event_id == 502) {
            int f;
            int i;
            int m = ((InputEvent)event).getModifiers();
            int m1 = m & 0x10;
            int m2 = m & 8;
            int m3 = m & 4;
            int mctrl = m & 2;
            int mshift = m & 1;
            if (event_id == 501) {
                this.getDisplay().updateBusyStatus();
                if (m1 != 0) {
                    this.actual_button[0] = true;
                }
                if (m2 != 0) {
                    this.actual_button[1] = true;
                }
                if (m3 != 0) {
                    this.actual_button[2] = true;
                }
                this.mouseModifiers = m;
            } else {
                this.getDisplay().updateBusyStatus();
                if (m1 != 0) {
                    this.actual_button[0] = false;
                }
                if (m2 != 0) {
                    this.actual_button[1] = false;
                }
                if (m3 != 0) {
                    this.actual_button[2] = false;
                }
                this.mouseModifiers = 0;
            }
            int n = 0;
            int sum = 0;
            for (i = 0; i < 3; ++i) {
                if (!this.actual_button[i]) continue;
                ++n;
                sum += i;
            }
            this.virtual_button = n == 1 ? sum : (n == 2 && this.getEnableCombos() ? 3 - sum : -1);
            for (i = 0; i < this.function.length; ++i) {
                this.old_function[i] = this.function[i];
                this.function[i] = false;
            }
            int vctrl = mctrl == 0 ? 0 : 1;
            int vshift = mshift == 0 ? 0 : 1;
            int n2 = f = this.virtual_button < 0 ? -1 : this.function_map[this.virtual_button][vctrl][vshift];
            if (f >= 0) {
                this.function[f] = true;
            }
            boolean cursor_off = this.enableFunctions((MouseEvent)event);
            if (event_id == 501) {
                DisplayEvent e2;
                try {
                    e2 = new DisplayEvent((Display)this.getDisplay(), 1, mouse_event, remoteId);
                    this.getDisplay().notifyListeners(e2);
                }
                catch (VisADException e2) {
                }
                catch (RemoteException e2) {
                    // empty catch block
                }
                if (m1 != 0) {
                    try {
                        e2 = new DisplayEvent((Display)this.getDisplay(), 5, mouse_event, remoteId);
                        this.getDisplay().notifyListeners(e2);
                    }
                    catch (VisADException e3) {
                    }
                    catch (RemoteException e3) {
                        // empty catch block
                    }
                }
                if (m2 != 0) {
                    try {
                        e2 = new DisplayEvent((Display)this.getDisplay(), 4, mouse_event, remoteId);
                        this.getDisplay().notifyListeners(e2);
                    }
                    catch (VisADException e4) {
                    }
                    catch (RemoteException e4) {
                        // empty catch block
                    }
                }
                if (m3 != 0) {
                    try {
                        e2 = new DisplayEvent((Display)this.getDisplay(), 6, mouse_event, remoteId);
                        this.getDisplay().notifyListeners(e2);
                    }
                    catch (VisADException e5) {
                    }
                    catch (RemoteException e5) {}
                }
            } else {
                DisplayEvent e6;
                try {
                    e6 = new DisplayEvent((Display)this.getDisplay(), 7, mouse_event, remoteId);
                    this.getDisplay().notifyListeners(e6);
                }
                catch (VisADException e6) {
                }
                catch (RemoteException e6) {
                    // empty catch block
                }
                if (m1 != 0) {
                    try {
                        e6 = new DisplayEvent((Display)this.getDisplay(), 9, mouse_event, remoteId);
                        this.getDisplay().notifyListeners(e6);
                    }
                    catch (VisADException e7) {
                    }
                    catch (RemoteException e7) {
                        // empty catch block
                    }
                }
                if (m2 != 0) {
                    try {
                        e6 = new DisplayEvent((Display)this.getDisplay(), 8, mouse_event, remoteId);
                        this.getDisplay().notifyListeners(e6);
                    }
                    catch (VisADException e8) {
                    }
                    catch (RemoteException e8) {
                        // empty catch block
                    }
                }
                if (m3 != 0) {
                    try {
                        e6 = new DisplayEvent((Display)this.getDisplay(), 10, mouse_event, remoteId);
                        this.getDisplay().notifyListeners(e6);
                    }
                    catch (VisADException visADException) {
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
            if (cursor_off) {
                this.getDisplayRenderer().setCursorOn(false);
            }
        } else if (event_id == 506) {
            this.handleMouseDragged(mouse_event, remoteId);
            try {
                DisplayEvent e = new DisplayEvent((Display)this.getDisplay(), 18, mouse_event, remoteId);
                this.getDisplay().notifyListeners(e);
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    protected void handleMouseDragged(MouseEvent event, int remoteId) {
        boolean matrix;
        MouseBehavior mouseBehavior = this.getMouseBehavior();
        boolean cursor = this.function[3] || this.function[4] || this.function[5];
        boolean bl = matrix = this.function[0] || this.function[1] || this.function[2];
        if (cursor || matrix || this.function[6]) {
            VisADRay direct_ray;
            VisADRay cursor_ray;
            this.getDisplay().updateBusyStatus();
            Dimension d = event.getComponent().getSize();
            int current_x = event.getX();
            int current_y = event.getY();
            if (matrix) {
                double[] t1 = null;
                double[] t2 = null;
                if (this.function[1]) {
                    double scale = Math.exp((double)(this.start_y - current_y) / (double)d.height);
                    t1 = this.getMouseBehavior().make_matrix(0.0, 0.0, 0.0, scale, 0.0, 0.0, 0.0);
                }
                if (this.function[2]) {
                    double transx = this.xmul * (double)(this.start_x - current_x);
                    double transy = this.ymul * (double)(this.start_y - current_y);
                    t1 = this.getMouseBehavior().make_translate(-transx, -transy);
                }
                double[] myMatrix = this.tstart;
                if (this.function[0]) {
                    if (this.getMode2D()) {
                        double transx = this.xmul * (double)(this.start_x - current_x);
                        double transy = this.ymul * (double)(this.start_y - current_y);
                        t1 = this.getMouseBehavior().make_translate(-transx, -transy);
                    } else {
                        double angley = (double)(-(current_x - this.start_x)) * 100.0 / (double)d.width;
                        double anglex = (double)(-(current_y - this.start_y)) * 100.0 / (double)d.height;
                        double[] transA = new double[]{0.0, 0.0, 0.0};
                        double[] rotA = new double[]{0.0, 0.0, 0.0};
                        double[] scaleA = new double[]{0.0, 0.0, 0.0};
                        mouseBehavior.instance_unmake_matrix(rotA, scaleA, transA, myMatrix);
                        if (this.display_renderer.getScaleRotation()) {
                            angley /= scaleA[0];
                            anglex /= scaleA[0];
                        }
                        if (this.display_renderer.getRotateAboutCenter()) {
                            myMatrix = mouseBehavior.multiply_matrix(mouseBehavior.make_translate(-transA[0], -transA[1], -transA[2]), myMatrix);
                            t2 = mouseBehavior.make_translate(transA[0], transA[1], transA[2]);
                        }
                        t1 = mouseBehavior.make_matrix(anglex, angley, 0.0, 1.0, 0.0, 0.0, 0.0);
                    }
                }
                if (t1 != null) {
                    t1 = mouseBehavior.multiply_matrix(t1, myMatrix);
                    if (t2 != null) {
                        t1 = mouseBehavior.multiply_matrix(t2, t1);
                    }
                    try {
                        this.getProjectionControl().setMatrix(t1);
                    }
                    catch (VisADException visADException) {
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                return;
            }
            if (this.function[4] && !this.getMode2D()) {
                float diff = (float)(this.start_y - current_y) * 4.0f / (float)d.height;
                this.getDisplayRenderer().drag_depth(diff);
            }
            if (this.function[5] && !this.getMode2D()) {
                double angley = (double)(-(current_x - this.start_x)) * 100.0 / (double)d.width;
                double anglex = (double)(-(current_y - this.start_y)) * 100.0 / (double)d.height;
                double[] t1 = this.getMouseBehavior().make_matrix(anglex, angley, 0.0, 1.0, 0.0, 0.0, 0.0);
                t1 = this.getMouseBehavior().multiply_matrix(t1, this.tstart);
                try {
                    this.getProjectionControl().setMatrix(t1);
                }
                catch (VisADException visADException) {
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            if (this.function[3] && (cursor_ray = this.getMouseBehavior().findRay(current_x, current_y)) != null) {
                this.getDisplayRenderer().drag_cursor(cursor_ray, false);
            }
            if (this.function[6] && this.direct_renderer != null && (direct_ray = this.getMouseBehavior().findRay(current_x, current_y)) != null) {
                this.direct_renderer.setLastMouseModifiers(this.mouseModifiers);
                this.direct_renderer.drag_direct(direct_ray, false, this.mouseModifiers);
            }
        }
    }

    protected boolean enableFunctions(MouseEvent event) {
        VisADRay cursor_ray;
        boolean old_matrix;
        boolean cursor_off = false;
        if (event == null) {
            for (int i = 0; i < this.function.length; ++i) {
                this.old_function[i] = this.function[i];
                this.function[i] = false;
            }
        }
        boolean cursor = this.function[3] || this.function[4] || this.function[5];
        boolean old_cursor = this.old_function[3] || this.old_function[4] || this.old_function[5];
        boolean matrix = this.function[0] || this.function[1] || this.function[2];
        boolean bl = old_matrix = this.old_function[0] || this.old_function[1] || this.old_function[2];
        if (old_cursor && !cursor) {
            cursor_off = true;
        }
        if (this.old_function[6] && !this.function[6]) {
            this.getDisplayRenderer().setDirectOn(false);
            if (this.direct_renderer != null) {
                this.direct_renderer.release_direct();
                this.direct_renderer = null;
            }
        }
        if (matrix && !old_matrix) {
            this.start_x = event.getX();
            this.start_y = event.getY();
            this.tstart = this.getProjectionControl().getMatrix();
            this.setTranslationFactor(this.start_x, this.start_y);
        }
        if (cursor && !old_cursor) {
            this.getDisplayRenderer().setCursorOn(true);
            this.start_x = event.getX();
            this.start_y = event.getY();
            this.tstart = this.getProjectionControl().getMatrix();
        }
        if (this.function[3] && !this.old_function[3] && (cursor_ray = this.getMouseBehavior().findRay(this.start_x, this.start_y)) != null) {
            this.getDisplayRenderer().drag_cursor(cursor_ray, true);
        }
        if (this.function[4] && !this.old_function[4] && !this.getMode2D()) {
            cursor_ray = this.getMouseBehavior().cursorRay(this.getDisplayRenderer().getCursor());
            this.getDisplayRenderer().depth_cursor(cursor_ray);
        }
        if (this.function[6] && !this.old_function[6] && this.getDisplayRenderer().anyDirects()) {
            int current_x = event.getX();
            int current_y = event.getY();
            VisADRay direct_ray = this.getMouseBehavior().findRay(current_x, current_y);
            if (direct_ray != null) {
                this.direct_renderer = this.getDisplayRenderer().findDirect(direct_ray, this.mouseModifiers);
                if (this.direct_renderer != null) {
                    this.getDisplayRenderer().setDirectOn(true);
                    this.direct_renderer.setLastMouseModifiers(this.mouseModifiers);
                    this.direct_renderer.drag_direct(direct_ray, true, this.mouseModifiers);
                }
            }
        }
        return cursor_off;
    }

    public void setEnableCombos(boolean e) {
        this.enable_combos = e;
        this.enableFunctions(null);
    }

    public boolean getEnableCombos() {
        return this.enable_combos;
    }

    public void setFunctionMap(int[][][] map) throws VisADException {
        int k;
        int j;
        int i;
        if (map == null || map.length != 3) {
            throw new DisplayException("bad map array");
        }
        for (i = 0; i < 3; ++i) {
            if (map[i] == null || map[i].length != 2) {
                throw new DisplayException("bad map array");
            }
            for (j = 0; j < 2; ++j) {
                if (map[i][j] == null || map[i][j].length != 2) {
                    throw new DisplayException("bad map array");
                }
                for (k = 0; k < 2; ++k) {
                    if (map[i][j][k] < this.function.length) continue;
                    throw new DisplayException("bad map array value: " + map[i][j][k]);
                }
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 2; ++j) {
                for (k = 0; k < 2; ++k) {
                    this.function_map[i][j][k] = map[i][j][k];
                }
            }
        }
        this.enableFunctions(null);
    }

    public void setTranslationFactor(int start_x, int start_y) {
        VisADRay start_ray = this.getMouseBehavior().findRay(start_x, start_y);
        VisADRay start_ray_x = this.getMouseBehavior().findRay(start_x + 1, start_y);
        VisADRay start_ray_y = this.getMouseBehavior().findRay(start_x, start_y + 1);
        double[] rot = new double[3];
        double[] scale = new double[3];
        double[] trans = new double[3];
        this.getMouseBehavior().instance_unmake_matrix(rot, scale, trans, this.tstart);
        double sts = scale[0];
        double[] trot = this.getMouseBehavior().make_matrix(rot[0], rot[1], rot[2], scale[0], scale[1], scale[2], 0.0, 0.0, 0.0);
        double[] xmat = this.getMouseBehavior().make_translate(start_ray_x.position[0] - start_ray.position[0], start_ray_x.position[1] - start_ray.position[1], start_ray_x.position[2] - start_ray.position[2]);
        double[] ymat = this.getMouseBehavior().make_translate(start_ray_y.position[0] - start_ray.position[0], start_ray_y.position[1] - start_ray.position[1], start_ray_y.position[2] - start_ray.position[2]);
        double[] xmatmul = this.getMouseBehavior().multiply_matrix(trot, xmat);
        double[] ymatmul = this.getMouseBehavior().multiply_matrix(trot, ymat);
        this.getMouseBehavior().instance_unmake_matrix(rot, scale, trans, xmatmul);
        this.xmul = trans[0];
        this.getMouseBehavior().instance_unmake_matrix(rot, scale, trans, ymatmul);
        this.ymul = trans[1];
        if (this.getMouseBehavior() instanceof MouseBehaviorJ2D) {
            double factor = this.xymul / Math.sqrt(this.xmul * this.xmul + this.ymul * this.ymul);
            this.xmul *= factor;
            this.ymul *= factor;
            this.xmul = Math.abs(this.xmul);
            this.ymul = -Math.abs(this.ymul);
        }
    }

    public void print_matrix(String title, double[] m) {
        if (this.getMouseBehavior() == null) {
            return;
        }
        double[] rot = new double[3];
        double[] scale = new double[3];
        double[] trans = new double[3];
        this.getMouseBehavior().instance_unmake_matrix(rot, scale, trans, m);
        StringBuffer buf = new StringBuffer(title);
        buf.append(" = (");
        buf.append(Convert.shortString(rot[0]));
        buf.append(", ");
        buf.append(Convert.shortString(rot[1]));
        buf.append(", ");
        buf.append(Convert.shortString(rot[2]));
        buf.append("), ");
        if (scale[0] == scale[1] && scale[0] == scale[2]) {
            buf.append(Convert.shortString(scale[0]));
            buf.append(", (");
        } else {
            buf.append("(");
            buf.append(Convert.shortString(scale[0]));
            buf.append(", ");
            buf.append(Convert.shortString(scale[1]));
            buf.append(", ");
            buf.append(Convert.shortString(scale[2]));
            buf.append("), (");
        }
        buf.append(Convert.shortString(trans[0]));
        buf.append(", ");
        buf.append(Convert.shortString(trans[1]));
        buf.append(", ");
        buf.append(Convert.shortString(trans[2]));
        buf.append(")");
        System.out.println(buf.toString());
    }

    @Override
    public void rendererDeleted(DataRenderer renderer) {
        if (this.direct_renderer != null && (this.direct_renderer == renderer || this.direct_renderer.equals(renderer))) {
            this.direct_renderer = null;
        }
    }
}

