/*
 * Decompiled with CFR 0.152.
 */
package visad.browser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;

public class Divider
extends Component {
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    private int orientation;

    public Divider() {
        this(1);
    }

    public Divider(int orientation) {
        this.orientation = orientation;
    }

    @Override
    public void paint(Graphics g) {
        if (this.orientation == 1) {
            int w = this.getSize().width;
            g.setColor(Color.white);
            g.drawRect(0, 0, w - 2, 6);
            g.drawRect(2, 2, w - 4, 2);
            g.setColor(Color.black);
            g.drawRect(1, 1, w - 3, 3);
        } else if (this.orientation == 2) {
            int h = this.getSize().height;
            g.setColor(Color.white);
            g.drawRect(0, 0, 6, h - 2);
            g.drawRect(2, 2, 2, h - 4);
            g.setColor(Color.black);
            g.drawRect(1, 1, 3, h - 3);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.orientation == 1) {
            return new Dimension(0, 6);
        }
        if (this.orientation == 2) {
            return new Dimension(6, 0);
        }
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.orientation == 1) {
            return new Dimension(0, 6);
        }
        if (this.orientation == 2) {
            return new Dimension(6, 0);
        }
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.orientation == 1) {
            return new Dimension(Integer.MAX_VALUE, 6);
        }
        if (this.orientation == 2) {
            return new Dimension(6, Integer.MAX_VALUE);
        }
        return new Dimension(0, 0);
    }
}

