/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.in;

import java.io.IOException;
import ucar.netcdf.Variable;
import visad.Real;
import visad.RealType;
import visad.Scalar;
import visad.SimpleSet;
import visad.Unit;
import visad.VisADException;
import visad.data.netcdf.in.Context;
import visad.data.netcdf.in.InvalidContextException;
import visad.data.netcdf.in.Vetter;
import visad.data.netcdf.in.VirtualScalar;

public class VirtualReal
extends VirtualScalar {
    private SimpleSet rangeSet;
    private final Unit unit;
    private final Vetter vetter;
    private final int[] lengths;

    public VirtualReal(RealType type, Variable var, SimpleSet rangeSet, Unit unit, Vetter vetter) {
        super(type, var);
        this.rangeSet = rangeSet;
        this.unit = unit;
        this.vetter = vetter;
        this.lengths = var.getLengths();
    }

    @Override
    public SimpleSet getRangeSet() {
        return this.rangeSet;
    }

    @Override
    public Unit getUnit() {
        return this.unit;
    }

    @Override
    public Vetter getVetter() {
        return this.vetter;
    }

    @Override
    protected Scalar getScalar(Context context) throws VisADException, InvalidContextException, IOException {
        double[] values = this.getDoubles(context);
        if (values.length != 1) {
            throw new InvalidContextException(context);
        }
        return new Real((RealType)this.getScalarType(), values[0], this.getUnit());
    }

    @Override
    public double[] getDoubles(Context context) throws IOException, VisADException {
        int rank = this.lengths.length;
        int[] ioOrigin = new int[rank];
        int[] ioShape = new int[rank];
        int[] ioContext = context.getContext();
        System.arraycopy(ioContext, 0, ioOrigin, 0, ioContext.length);
        for (int i = 0; i < ioContext.length; ++i) {
            ioShape[i] = 1;
        }
        int total = 1;
        for (int i = ioContext.length; i < rank; ++i) {
            ioOrigin[i] = 0;
            ioShape[i] = this.lengths[i];
            total *= this.lengths[i];
        }
        double[] values = new double[total];
        VirtualReal.toArray(this.getVariable(), values, ioOrigin, ioShape);
        this.vetter.vet(values);
        return values;
    }

    @Override
    public boolean isReal() {
        return true;
    }

    @Override
    public Object clone() {
        return new VirtualReal((RealType)this.getScalarType(), this.getVariable(), this.rangeSet, this.unit, this.vetter);
    }
}

