/*
 * Decompiled with CFR 0.152.
 */
package visad.java2d;

import java.rmi.RemoteException;
import visad.Control;
import visad.ValueControl;
import visad.VisADException;
import visad.browser.Convert;
import visad.java2d.AVControlJ2D;
import visad.java2d.DisplayImplJ2D;
import visad.java2d.DisplayRendererJ2D;
import visad.java2d.VisADCanvasJ2D;

public class ValueControlJ2D
extends AVControlJ2D
implements ValueControl {
    private double Value = 0.0;
    private VisADCanvasJ2D canvas;

    public ValueControlJ2D(DisplayImplJ2D d) {
        super(d);
        if (d != null) {
            this.canvas = ((DisplayRendererJ2D)d.getDisplayRenderer()).getCanvas();
        }
    }

    @Override
    public void setValue(double value) throws VisADException, RemoteException {
        this.Value = value;
        this.selectSwitches(this.Value, null);
        this.canvas.scratchImages();
        this.changeControl(true);
    }

    @Override
    public void init() throws VisADException {
        this.selectSwitches(this.Value, null);
    }

    @Override
    public double getValue() {
        return this.Value;
    }

    @Override
    public String getSaveString() {
        return "" + this.Value;
    }

    @Override
    public void setSaveString(String save) throws VisADException, RemoteException {
        if (save == null) {
            throw new VisADException("Invalid save string");
        }
        this.setValue(Convert.getDouble(save.trim()));
    }

    @Override
    public void syncControl(Control rmt) throws VisADException {
        double rv;
        if (rmt == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(rmt instanceof ValueControl)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + rmt.getClass().getName());
        }
        ValueControl vc = (ValueControl)((Object)rmt);
        boolean changed = false;
        double v = this.getValue();
        if (Math.abs(v - (rv = vc.getValue())) > 0.001) {
            try {
                this.setValue(rv);
            }
            catch (RemoteException re) {
                throw new VisADException("Could not set value: " + re.getMessage());
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        double rv;
        if (!super.equals(o)) {
            return false;
        }
        ValueControlJ2D vc = (ValueControlJ2D)o;
        double v = this.getValue();
        return !(Math.abs(v - (rv = vc.getValue())) > 0.001);
    }

    @Override
    public String toString() {
        return "ValueControlJ2D: Value = " + this.Value;
    }
}

