/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate.support;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.transaction.TransactionManager;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.orm.hibernate.support.AbstractLobType;

public class BlobSerializableType
extends AbstractLobType {
    static /* synthetic */ Class class$java$io$Serializable;

    public BlobSerializableType() {
    }

    protected BlobSerializableType(LobHandler lobHandler, TransactionManager jtaTransactionManager) {
        super(lobHandler, jtaTransactionManager);
    }

    public int[] sqlTypes() {
        return new int[]{2004};
    }

    public Class returnedClass() {
        return class$java$io$Serializable == null ? (class$java$io$Serializable = BlobSerializableType.class$("java.io.Serializable")) : class$java$io$Serializable;
    }

    public boolean isMutable() {
        return true;
    }

    protected Object nullSafeGetInternal(ResultSet rs, int index, LobHandler lobHandler) throws SQLException, IOException {
        InputStream is = lobHandler.getBlobAsBinaryStream(rs, index);
        ObjectInputStream ois = new ObjectInputStream(is);
        try {
            Object object = ois.readObject();
            return object;
        }
        catch (ClassNotFoundException ex) {
            throw new IOException("Could not deserialize BLOB contents: " + ex.getMessage());
        }
        finally {
            ois.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nullSafeSetInternal(PreparedStatement ps, int index, Object value, LobCreator lobCreator) throws SQLException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            oos.writeObject(value);
            oos.flush();
            lobCreator.setBlobAsBytes(ps, index, baos.toByteArray());
        }
        finally {
            oos.close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

