/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.HashMap;
import java.util.Map;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.hibernate.SQLQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlEngineException;
import org.sqlproc.engine.impl.SqlMappingItem;
import org.sqlproc.engine.impl.SqlMappingLexer;
import org.sqlproc.engine.impl.SqlMappingParser;
import org.sqlproc.engine.impl.SqlProcessResult;

public class SqlMappingRule {
    protected static Logger logger = LoggerFactory.getLogger(SqlMappingRule.class);
    private Map<String, SqlMappingItem> mappings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SqlMappingRule getInstance(String mappingStatement) throws SqlEngineException {
        SqlMappingRule sqlMappingRule;
        if (logger.isDebugEnabled()) {
            logger.debug(">> getInstance, mappingStatement=" + mappingStatement);
        }
        SqlMappingRule mapping = null;
        try {
            StringBuilder s = new StringBuilder(mappingStatement);
            SqlMappingLexer lexer = new SqlMappingLexer((CharStream)new ANTLRStringStream(s.toString()));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            SqlMappingParser parser = new SqlMappingParser((TokenStream)tokens);
            try {
                mapping = parser.parse();
            }
            catch (RecognitionException ex) {
                ex.printStackTrace();
            }
            if (!lexer.getErrors().isEmpty() || !parser.getErrors().isEmpty()) {
                throw new SqlEngineException("Mapping error for '" + mappingStatement + "'", lexer.getErrors(), parser.getErrors());
            }
            sqlMappingRule = mapping;
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("<< getInstance, mapping=" + mapping);
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("<< getInstance, mapping=" + mapping);
        }
        return sqlMappingRule;
    }

    public SqlMappingRule() {
        this.mappings = new HashMap<String, SqlMappingItem>();
    }

    SqlMappingRule(Map<String, SqlMappingItem> mappings) {
        this.mappings = mappings;
    }

    void addMapping(SqlMappingItem item) {
        this.mappings.put(item.getDbName(), item);
    }

    public void setQueryResultMapping(Class<?> resultClass, SQLQuery query) {
        for (SqlMappingItem item : this.mappings.values()) {
            item.setQueryResultMapping(resultClass, query);
        }
    }

    public void setQueryResultData(Object resultInstance, Object[] resultValues) {
        int i = 0;
        for (SqlMappingItem item : this.mappings.values()) {
            item.setQueryResultData(resultInstance, resultValues[i++]);
        }
    }

    public static SqlMappingRule merge(SqlMappingRule mapping, SqlProcessResult processResult) {
        if (mapping == null) {
            mapping = new SqlMappingRule();
        }
        return mapping.merge(processResult.getOutputValues());
    }

    SqlMappingRule merge(Map<String, SqlMappingItem> outputMappings) {
        if (outputMappings == null || outputMappings.size() == 0) {
            return this;
        }
        SqlMappingRule resultMapping = new SqlMappingRule();
        for (SqlMappingItem mappingItem : outputMappings.values()) {
            if (this.mappings.containsKey(mappingItem.getDbName())) {
                resultMapping.addMapping(this.mappings.get(mappingItem.getDbName()).merge(mappingItem));
                continue;
            }
            resultMapping.addMapping(mappingItem);
        }
        return resultMapping;
    }
}

