/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.impl.SqlInputValue;
import org.sqlproc.engine.impl.SqlMetaIdentItem;
import org.sqlproc.engine.impl.SqlMetaLogOperand;
import org.sqlproc.engine.impl.SqlMetaSimple;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlProcessResult;
import org.sqlproc.engine.impl.SqlType;
import org.sqlproc.engine.impl.SqlUtils;

class SqlMetaIdent
implements SqlMetaSimple,
SqlMetaLogOperand {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SqlInputValue.Case caseConversion;
    private boolean not;
    private List<SqlMetaIdentItem> elements = new ArrayList<SqlMetaIdentItem>();
    private SqlType sqlType;

    SqlMetaIdent(SqlInputValue.Case caseConversion) {
        this(caseConversion, false);
    }

    SqlMetaIdent(SqlInputValue.Case caseConversion, boolean not) {
        this(caseConversion, false, new SqlType());
    }

    SqlMetaIdent(SqlInputValue.Case caseConversion, boolean not, SqlType type) {
        this.caseConversion = caseConversion;
        this.not = not;
        this.sqlType = type;
    }

    void addIdent(String name) {
        SqlMetaIdentItem lastItem;
        int size = this.elements.size();
        SqlMetaIdentItem sqlMetaIdentItem = lastItem = size > 0 ? this.elements.get(size - 1) : null;
        if (lastItem != null) {
            lastItem.setType(SqlMetaIdentItem.Type.REF);
        }
        this.elements.add(new SqlMetaIdentItem(name, SqlMetaIdentItem.Type.VAL));
    }

    void addIdent(SqlMetaIdentItem element) {
        this.elements.add(element);
    }

    void setMetaType(String sMetaType) {
        this.sqlType = sMetaType.startsWith("h_") ? new SqlType(sMetaType.substring(2)) : new SqlType(sMetaType, this.sqlType);
    }

    void setHibernateType(String sHibernateType) {
        this.sqlType = new SqlType(sHibernateType);
    }

    public void setValue(String value) {
        this.sqlType.setValue(value);
    }

    SqlType getSqlType() {
        return this.sqlType;
    }

    void setNot(boolean not) {
        this.not = not;
    }

    boolean isNot() {
        return this.not;
    }

    @Override
    public SqlProcessResult process(SqlProcessContext ctx) {
        SqlProcessResult result = new SqlProcessResult();
        boolean first = true;
        Object obj = ctx.dynamicInputValues;
        StringBuilder s = new StringBuilder(this.elements.size() * 32);
        s.append(':');
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SqlMetaIdent process " + obj.getClass() + " " + obj + " " + this.sqlType);
        }
        for (SqlMetaIdentItem item : this.elements) {
            if (first) {
                first = false;
            } else {
                s.append('_');
            }
            s.append(item.getName());
            if (obj == null) continue;
            obj = SqlUtils.invokeMethod(obj, item.get(), item.is());
        }
        result.add(SqlUtils.isEmpty(obj, this.sqlType));
        result.addInputValue(s.substring(1), new SqlInputValue(obj, this.caseConversion, this.sqlType));
        result.setSql(s);
        return result;
    }

    @Override
    public boolean processExpression(SqlProcessContext ctx) {
        Object obj = ctx.dynamicInputValues;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SqlMetaIdent process expression " + obj.getClass() + " " + obj + " " + this.sqlType);
        }
        for (SqlMetaIdentItem item : this.elements) {
            if (obj == null) continue;
            obj = SqlUtils.invokeMethod(obj, item.get(), item.is());
        }
        boolean result = SqlUtils.isTrue(obj, this.sqlType);
        return this.not ? !result : result;
    }
}

