/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl.type;

import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import org.hibernate.Query;
import org.hibernate.type.PrimitiveType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.BeanUtils;

public class SqlHibernateType {
    protected static final Logger logger = LoggerFactory.getLogger(SqlHibernateType.class);

    public static void setResult(Object resultInstance, String attributeName, Object resultValue, Type hibernateType, boolean ingoreError) throws SqlRuntimeException {
        Method m;
        if (logger.isTraceEnabled()) {
            logger.trace(">>> setResult HIBERNATE: resultInstance=" + resultInstance + ", attributeName=" + attributeName + ", resultValue=" + resultValue + ", hibernateType=" + hibernateType);
        }
        if ((m = BeanUtils.getSetter(resultInstance, attributeName, hibernateType.getReturnedClass())) == null && hibernateType instanceof PrimitiveType) {
            m = BeanUtils.getSetter(resultInstance, attributeName, ((PrimitiveType)hibernateType).getPrimitiveClass());
        }
        if (m == null && hibernateType.getReturnedClass() == Date.class) {
            m = BeanUtils.getSetter(resultInstance, attributeName, Timestamp.class);
        }
        if (m != null) {
            BeanUtils.simpleInvokeMethod(m, resultInstance, resultValue);
        } else if (ingoreError) {
            logger.error("There's no getter for " + attributeName + " in " + resultInstance + ", META type is HIBERNATE");
        } else {
            throw new SqlRuntimeException("There's no setter for " + attributeName + " in " + resultInstance + ", META type is HIBERNATE");
        }
    }

    public static void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType, Type hibernateType, boolean ingoreError) throws SqlRuntimeException {
        if (logger.isTraceEnabled()) {
            logger.trace(">>> setParameter HIBERNATE: paramName=" + paramName + ", inputValue=" + inputValue + ", inputType=" + inputType + ", hibernateType=" + hibernateType);
        }
        if (inputValue instanceof Collection) {
            query.setParameterList(paramName, ((Collection)inputValue).toArray(), hibernateType);
        } else {
            query.setParameter(paramName, inputValue, hibernateType);
        }
    }
}

