/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Time;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.MethodUtils;
import org.sqlproc.engine.SqlFeature;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlType;

public class SqlUtils {
    static final String SUPPVAL_NOTNULL = "notnull";
    static final String SUPPVAL_ANY = "any";
    static final String SUPPVAL_NULL = "null";
    static final String SUPPVAL_SEQUENCE = "seq";
    static final String SUPPVAL_IDENTITY_SELECT = "idsel";
    static final String SUPPVAL_ID = "id";
    static final String SUPPVAL_GTYPE = "gtype";
    static final String SUPPVAL_TYPE = "type";
    static final String SUPPVAL_DISCRIMINATOR = "discr";

    public static Object getEnumToValue(Object obj) {
        if (obj == null) {
            return null;
        }
        for (String methodName : SqlProcessContext.getFeatures("METHODS_ENUM_IN")) {
            try {
                return MethodUtils.invokeMethod((Object)obj, (String)methodName, null);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static Class getEnumToClass(Class clazz) {
        if (clazz == null) {
            return null;
        }
        for (String methodName : SqlProcessContext.getFeatures("METHODS_ENUM_IN")) {
            Method m = MethodUtils.getMatchingAccessibleMethod((Class)clazz, (String)methodName, (Class[])new Class[0]);
            if (m == null) continue;
            return m.getReturnType();
        }
        return null;
    }

    public static Object getValueToEnum(Class<?> objClass, Object val) {
        if (val == null) {
            return null;
        }
        for (String methodName : SqlProcessContext.getFeatures("METHODS_ENUM_OUT")) {
            try {
                return MethodUtils.invokeStaticMethod(objClass, (String)methodName, (Object)val);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static boolean isEmpty(Object obj, SqlType sqlType, boolean inSqlSetOrInsert) throws IllegalArgumentException {
        String value;
        String string = value = sqlType != null && sqlType.getValue() != null ? sqlType.getValue().toLowerCase() : null;
        if (SUPPVAL_NOTNULL.equalsIgnoreCase(value) && obj == null) {
            throw new IllegalArgumentException(SUPPVAL_NOTNULL);
        }
        if (inSqlSetOrInsert && obj == null) {
            return true;
        }
        if (SUPPVAL_ANY.equalsIgnoreCase(value)) {
            return true;
        }
        if (SUPPVAL_NULL.equalsIgnoreCase(value)) {
            return obj == null;
        }
        if (obj == null) {
            return false;
        }
        return !(obj instanceof Collection ? ((Collection)obj).isEmpty() : obj.toString().length() <= 0);
    }

    public static boolean isTrue(Object obj, SqlType sqlType) {
        if (sqlType == null || sqlType.getValue() == null) {
            if (obj != null) {
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                if (obj instanceof String) {
                    String str = ((String)obj).trim();
                    return str.length() > 0 && !str.equalsIgnoreCase("false");
                }
                if (obj instanceof Number) {
                    return ((Number)obj).longValue() > 0L;
                }
                if (obj.getClass().isEnum()) {
                    return true;
                }
                return true;
            }
            return false;
        }
        if (obj == null) {
            return sqlType.getValue().toLowerCase().equalsIgnoreCase(SUPPVAL_NULL);
        }
        if (obj.getClass().isEnum()) {
            if (obj.toString().equals(sqlType.getValue())) {
                return true;
            }
            if (sqlType.getMetaType() == SqlProcessContext.getTypeFactory().getEnumStringType()) {
                return sqlType.getValue().equals(SqlUtils.getEnumToValue(obj));
            }
            if (sqlType.getMetaType() == SqlProcessContext.getTypeFactory().getEnumIntegerType()) {
                return sqlType.getValue().equals(SqlUtils.getEnumToValue(obj).toString());
            }
            return false;
        }
        return obj.toString().equals(sqlType.getValue());
    }

    public static Byte[] toBytes(byte[] barr) {
        if (barr == null) {
            return null;
        }
        Byte[] res = new Byte[barr.length];
        for (int i = 0; i < barr.length; ++i) {
            res[i] = new Byte(barr[i]);
        }
        return res;
    }

    public static byte[] toBytes(Byte[] barr) {
        if (barr == null) {
            return null;
        }
        byte[] res = new byte[barr.length];
        for (int i = 0; i < barr.length; ++i) {
            res[i] = barr[i] != null ? barr[i] : (byte)0;
        }
        return res;
    }

    public static boolean isEmpty(StringBuilder sb) {
        if (sb == null) {
            return true;
        }
        String s = sb.toString().trim();
        return s.length() == 0;
    }

    public static boolean[] initChangedIdentities(int length, boolean changed) {
        boolean[] changedIdentities = new boolean[length];
        if (changed) {
            for (int i = 0; i < length; ++i) {
                changedIdentities[i] = true;
            }
            return changedIdentities;
        }
        return changedIdentities;
    }

    public static boolean[] changedIdentities(Object[] resultValue, Object[] previousResultValue) {
        boolean[] changedIdentities = SqlUtils.initChangedIdentities(resultValue.length, previousResultValue == null);
        if (previousResultValue == null) {
            return changedIdentities;
        }
        for (int i = 0; i < resultValue.length; ++i) {
            Object newIdentity = resultValue[i];
            Object previousIdentity = previousResultValue[i];
            boolean result = false;
            result = previousIdentity != null && newIdentity == null ? true : (previousIdentity == null && newIdentity != null ? true : (previousIdentity == null && newIdentity == null ? false : !previousIdentity.equals(newIdentity)));
            changedIdentities[i] = result;
        }
        return changedIdentities;
    }

    public static boolean changedIdentity(boolean[] changedIdentities, Integer identityIndex) {
        if (changedIdentities == null || identityIndex == null) {
            return true;
        }
        return changedIdentities[identityIndex];
    }

    public static boolean changedIdentity(boolean[] changedIdentities, List<Integer> identityIndexes) {
        if (changedIdentities == null || identityIndexes == null) {
            return true;
        }
        for (Integer identityIndex : identityIndexes) {
            if (!changedIdentities[identityIndex]) continue;
            return true;
        }
        return false;
    }

    public static Date getDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        return new Date(cal.getTime().getTime());
    }

    public static Time getTime(int hour, int minute, int second) {
        Calendar cal = Calendar.getInstance();
        cal.clear(1);
        cal.clear(2);
        cal.clear(5);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        return new Time(cal.getTime().getTime());
    }

    public static java.util.Date getDateTime(int year, int month, int day, int hour, int minute, int second) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        return cal.getTime();
    }

    public static LimitType limitQuery(String queryString, StringBuilder queryResult, Integer firstResult, Integer maxResults) {
        LimitType limitType = new LimitType();
        if (maxResults == null || maxResults <= 0) {
            return null;
        }
        if (firstResult != null && firstResult > 0) {
            limitType.alsoFirst = true;
            String limitPattern = SqlProcessContext.getFeature("LIMIT_FROM_TO");
            limitType = SqlUtils.limitQuery(limitPattern, limitType, queryString, queryResult, firstResult, maxResults);
            return limitType;
        }
        String limitPattern = SqlProcessContext.getFeature("LIMIT_TO");
        limitType = SqlUtils.limitQuery(limitPattern, limitType, queryString, queryResult, firstResult, maxResults);
        return limitType;
    }

    public static LimitType limitQuery(String limitPattern, LimitType limitType, String queryString, StringBuilder queryResult, Integer firstResult, Integer maxResults) {
        if (limitPattern == null) {
            return null;
        }
        int ix = limitPattern.indexOf("$S");
        if (ix >= 0) {
            limitType.afterSql = limitPattern.indexOf(ix, 36) > 0;
            queryResult.append(limitPattern.substring(0, ix));
            queryResult.append(queryString);
            queryResult.append(limitPattern.substring(ix + 2));
        } else {
            ix = limitPattern.indexOf("$s");
            if (ix >= 0) {
                limitType.afterSql = limitPattern.indexOf(ix, 36) > 0;
                int ix2 = queryString.toLowerCase().indexOf("select");
                if (ix2 < 0) {
                    return null;
                }
                queryResult.append(limitPattern.substring(0, ix));
                queryResult.append(queryString.substring(ix2 + 6));
                queryResult.append(limitPattern.substring(ix + 2));
            } else {
                return null;
            }
        }
        if (limitType.alsoFirst) {
            ix = queryResult.indexOf("$F");
            if (ix >= 0) {
                if (queryResult.indexOf("$m", ix) < 0 && queryResult.indexOf("$M", ix) < 0) {
                    limitType.maxBeforeFirst = true;
                }
                queryResult.replace(ix, ix + 2, "?");
            } else {
                ix = queryResult.indexOf("$F");
                if (ix >= 0) {
                    limitType.zeroBasedFirst = true;
                    if (queryResult.indexOf("$m", ix) < 0 && queryResult.indexOf("$M", ix) < 0) {
                        limitType.maxBeforeFirst = true;
                    }
                    queryResult.replace(ix, ix + 2, "?");
                } else {
                    return null;
                }
            }
        }
        if ((ix = queryResult.indexOf("$M")) >= 0) {
            queryResult.replace(ix, ix + 2, "?");
        } else {
            ix = queryResult.indexOf("$m");
            if (ix >= 0) {
                limitType.rowidBasedMax = true;
                queryResult.replace(ix, ix + 2, "?");
            } else {
                return null;
            }
        }
        return limitType;
    }

    public static String sequence(String sequenceName) {
        String sequence = SqlProcessContext.getFeature(sequenceName);
        if (sequence != null) {
            return sequence;
        }
        String sequencePattern = SqlProcessContext.getFeature("SEQ");
        if (sequencePattern == null) {
            return null;
        }
        int ix = sequencePattern.indexOf("$n");
        if (ix < 0) {
            return sequencePattern;
        }
        if (SUPPVAL_SEQUENCE.equals(sequenceName)) {
            return sequencePattern.substring(0, ix) + "SQLPROC_SEQUENCE" + sequencePattern.substring(ix + 2);
        }
        return sequencePattern.substring(0, ix) + sequenceName + sequencePattern.substring(ix + 2);
    }

    public static String identitySelect(String identitySelectName) {
        String identitySelect;
        String string = identitySelect = SUPPVAL_IDENTITY_SELECT.equals(identitySelectName) ? null : SqlProcessContext.getFeature(identitySelectName);
        if (identitySelect != null) {
            return identitySelect;
        }
        return SqlProcessContext.getFeature("IDSEL");
    }

    public static Map<String, Object> getDefaultFeatures(String filterPrefix) {
        HashMap<String, Object> features = new HashMap<String, Object>();
        if (filterPrefix != null && !filterPrefix.endsWith("_")) {
            filterPrefix = filterPrefix + "_";
        }
        String fullPrefix = filterPrefix != null ? filterPrefix + "DEFAULT_" : null;
        int fullPrefixLength = fullPrefix != null ? fullPrefix.length() : 0;
        String shortPrefix = "DEFAULT_";
        int shortPrefixLength = shortPrefix.length();
        for (Field f : SqlFeature.class.getDeclaredFields()) {
            String featureName;
            if (fullPrefix != null && f.getName().startsWith(fullPrefix) && features.get(featureName = f.getName().substring(fullPrefixLength)) == null) {
                try {
                    features.put(featureName, f.get(null));
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
            if (!f.getName().startsWith(shortPrefix) || features.get(featureName = f.getName().substring(shortPrefixLength)) != null) continue;
            try {
                features.put(featureName, f.get(null));
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return features;
    }

    public static class LimitType {
        public boolean alsoFirst;
        public boolean afterSql;
        public boolean maxBeforeFirst;
        public boolean zeroBasedFirst;
        public boolean rowidBasedMax;
    }
}

