/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.BeanUtils;
import org.sqlproc.engine.impl.SqlInputValue;
import org.sqlproc.engine.impl.SqlMetaLogOperand;
import org.sqlproc.engine.impl.SqlMetaSimple;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlProcessResult;
import org.sqlproc.engine.impl.SqlType;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.type.SqlMetaType;

class SqlMetaConst
implements SqlMetaSimple,
SqlMetaLogOperand {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SqlInputValue.Code caseConversion;
    private boolean not;
    private List<String> elements = new ArrayList<String>();
    private SqlType sqlType;

    SqlMetaConst(SqlInputValue.Code caseConversion) {
        this(caseConversion, false);
    }

    SqlMetaConst(SqlInputValue.Code caseConversion, boolean not) {
        this(caseConversion, false, new SqlType());
    }

    SqlMetaConst(SqlInputValue.Code caseConversion, boolean not, SqlType type) {
        this.caseConversion = caseConversion;
        this.not = not;
        this.sqlType = type;
    }

    void addConst(String name) {
        String[] names = name.split("=");
        this.elements.add(names[0]);
    }

    void setMetaType(SqlMetaType metaType) {
        this.sqlType = new SqlType(metaType);
    }

    public void setValues(String value, String value2) {
        int ix = -1;
        if (value2 == null && (ix = value.indexOf(61)) >= 0) {
            value2 = value.substring(ix + 1);
            value = value.substring(0, ix);
        }
        if (value2 == null) {
            this.sqlType.setValue(value);
        }
    }

    SqlType getSqlType() {
        return this.sqlType;
    }

    void setNot(boolean not) {
        this.not = not;
    }

    boolean isNot() {
        return this.not;
    }

    @Override
    public SqlProcessResult process(SqlProcessContext ctx) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> process : staticInputValues=" + ctx.staticInputValues + ", class=" + (ctx.staticInputValues != null ? ctx.staticInputValues.getClass() : null) + ", sqlType=" + this.sqlType);
        }
        SqlProcessResult result = new SqlProcessResult();
        Object obj = null;
        String attributeName = null;
        if (ctx.staticInputValues != null) {
            obj = ctx.staticInputValues;
            Class<?> attributeType = obj != null ? obj.getClass() : null;
            Iterator<String> i$ = this.elements.iterator();
            while (i$.hasNext()) {
                String item;
                attributeName = item = i$.next();
                if (attributeType != null) {
                    Class<?> origAttributeType = attributeType;
                    if ((attributeType = BeanUtils.getFieldType(attributeType, attributeName)) == null) {
                        if (SqlProcessContext.isFeature("IGNORE_INPROPER_IN")) {
                            this.logger.error("There's no attribute '" + attributeName + "' for " + origAttributeType);
                        } else {
                            throw new SqlRuntimeException("There's no attribute '" + attributeName + "' for " + origAttributeType);
                        }
                    }
                }
                if (obj == null) continue;
                obj = BeanUtils.getProperty(obj, item);
            }
        }
        try {
            result.add(SqlUtils.isEmpty(obj, this.sqlType, ctx.inSqlSetOrInsert));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Input value " + attributeName + ", failed reason" + e.getMessage());
        }
        if (obj != null) {
            if (obj instanceof Collection) {
                boolean notEmpty = !((Collection)obj).isEmpty();
                StringBuilder s = new StringBuilder(notEmpty ? "(" : "");
                Iterator i = ((Collection)obj).iterator();
                while (i.hasNext()) {
                    Object objItem = i.next();
                    if (objItem != null) {
                        s.append(this.getData(objItem));
                    } else {
                        s.append("null");
                    }
                    if (!i.hasNext()) continue;
                    s.append(',');
                }
                if (notEmpty) {
                    s.append(')');
                }
                result.setSql(s);
            } else {
                result.setSql(new StringBuilder(this.getData(obj)));
            }
        } else {
            result.setSql(new StringBuilder(""));
        }
        return result;
    }

    private String getData(Object obj) {
        if (obj instanceof String) {
            if (this.caseConversion == SqlInputValue.Code.UPPER) {
                return "'" + obj.toString().toUpperCase() + "'";
            }
            if (this.caseConversion == SqlInputValue.Code.LOWER) {
                return "'" + obj.toString().toLowerCase() + "'";
            }
            return "'" + obj.toString() + "'";
        }
        if (obj.getClass().isEnum() && this.sqlType != null) {
            if (this.sqlType.getMetaType() == SqlProcessContext.getTypeFactory().getEnumStringType()) {
                Object o = SqlUtils.getEnumToValue(obj);
                if (o != null && o instanceof String) {
                    return "'" + (String)o + "'";
                }
                return "'" + obj.toString() + "'";
            }
            if (this.sqlType.getMetaType() == SqlProcessContext.getTypeFactory().getEnumIntegerType()) {
                Object o = SqlUtils.getEnumToValue(obj);
                if (o != null) {
                    return o.toString();
                }
                return obj.toString();
            }
            if (this.sqlType.getMetaType() == SqlProcessContext.getTypeFactory().getDefaultType()) {
                Object o = SqlUtils.getEnumToValue(obj);
                if (o != null && o instanceof Integer) {
                    return o.toString();
                }
                if (o != null && o instanceof String) {
                    return "'" + o + "'";
                }
                return obj.toString();
            }
            return obj.toString();
        }
        return obj.toString();
    }

    @Override
    public boolean processExpression(SqlProcessContext ctx) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> processExpression : staticInputValues=" + ctx.staticInputValues + ", class=" + (ctx.staticInputValues != null ? ctx.staticInputValues.getClass() : null) + ", sqlType=" + this.sqlType);
        }
        Object obj = null;
        if (ctx.staticInputValues != null) {
            obj = ctx.staticInputValues;
            for (String item : this.elements) {
                if (obj == null) continue;
                obj = BeanUtils.getProperty(obj, item);
            }
        }
        boolean result = SqlUtils.isTrue(obj, this.sqlType);
        return this.not ? !result : result;
    }
}

