/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.jdbc.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.sqlproc.engine.SqlProcessorException;
import org.sqlproc.engine.jdbc.type.JdbcSqlType;
import org.sqlproc.engine.type.SqlByteArrayType;

public class JdbcByteArrayWrapperType
extends SqlByteArrayType
implements JdbcSqlType {
    @Override
    public Object getProviderSqlType() {
        return this;
    }

    @Override
    public Object getProviderSqlNullType() {
        return -3;
    }

    @Override
    public Object get(ResultSet rs, String columnLabel) throws SQLException {
        byte[] bytes = Character.isDigit(columnLabel.charAt(0)) ? rs.getBytes(Integer.parseInt(columnLabel)) : rs.getBytes(columnLabel);
        if (bytes == null) {
            return null;
        }
        int length = bytes.length;
        Byte[] result = new Byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = new Byte(bytes[i]);
        }
        return result;
    }

    @Override
    public void set(PreparedStatement st, int index, Object value) throws SQLException {
        Byte[] bytes = (Byte[])value;
        if (bytes == null) {
            st.setBytes(index, null);
        } else {
            int length = bytes.length;
            byte[] result = new byte[length];
            for (int i = 0; i < length; ++i) {
                if (bytes[i] == null) {
                    throw new SqlProcessorException("Bytes array has at least one element null: " + value);
                }
                result[i] = bytes[i];
            }
            st.setBytes(index, result);
        }
    }

    @Override
    public Object get(CallableStatement cs, int index) throws SQLException {
        byte[] bytes = cs.getBytes(index);
        if (bytes == null || cs.wasNull()) {
            return null;
        }
        int length = bytes.length;
        Byte[] result = new Byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = new Byte(bytes[i]);
        }
        return result;
    }
}

