/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.HashMap;
import java.util.Map;
import org.sqlproc.engine.SqlFeature;

public class SqlDefaultFeatures {
    public static final Map<SqlFeature, Object> FEATURES = new HashMap<SqlFeature, Object>();
    public static final Map<String, Map<SqlFeature, Object>> FILTERED_FEATURES = new HashMap<String, Map<SqlFeature, Object>>();

    public static Map<String, Object> getFilteredFeatures(String filter) {
        Map<SqlFeature, Object> filteredFeatures;
        HashMap<String, Object> features = new HashMap<String, Object>();
        for (Map.Entry<SqlFeature, Object> entry : FEATURES.entrySet()) {
            features.put(entry.getKey().name(), entry.getValue());
        }
        if (filter != null && (filteredFeatures = FILTERED_FEATURES.get(filter)) != null) {
            for (Map.Entry<SqlFeature, Object> entry : filteredFeatures.entrySet()) {
                features.put(entry.getKey().name(), entry.getValue());
            }
        }
        return features;
    }

    static {
        FILTERED_FEATURES.put(SqlFeature.ORACLE.name(), new HashMap());
        FILTERED_FEATURES.put(SqlFeature.HSQLDB.name(), new HashMap());
        FILTERED_FEATURES.put(SqlFeature.MYSQL.name(), new HashMap());
        FILTERED_FEATURES.put(SqlFeature.POSTGRESQL.name(), new HashMap());
        FILTERED_FEATURES.put(SqlFeature.INFORMIX.name(), new HashMap());
        FILTERED_FEATURES.put(SqlFeature.MSSQL.name(), new HashMap());
        FILTERED_FEATURES.put(SqlFeature.DB2.name(), new HashMap());
        FEATURES.put(SqlFeature.WILDCARD_CHARACTER, "%");
        FEATURES.put(SqlFeature.SURROUND_QUERY_LIKE_PARTIAL, Boolean.TRUE);
        FEATURES.put(SqlFeature.SURROUND_QUERY_MIN_LEN, 2);
        FEATURES.put(SqlFeature.LIKE_STRING, "like");
        FEATURES.put(SqlFeature.METHODS_ENUM_IN, new String[]{"getCode", "getValue", "getName", "name"});
        FEATURES.put(SqlFeature.METHODS_ENUM_OUT, new String[]{"fromCode", "fromValue", "valueOf"});
        FILTERED_FEATURES.get(SqlFeature.HSQLDB.name()).put(SqlFeature.LIMIT_FROM_TO, "$S offset $F limit $M");
        FILTERED_FEATURES.get(SqlFeature.HSQLDB.name()).put(SqlFeature.LIMIT_FROM_TO_ORDERED, "$S offset $F limit $M using index");
        FILTERED_FEATURES.get(SqlFeature.HSQLDB.name()).put(SqlFeature.LIMIT_TO, "$S limit $M");
        FILTERED_FEATURES.get(SqlFeature.HSQLDB.name()).put(SqlFeature.LIMIT_TO_ORDERED, "$S limit $M using index");
        FILTERED_FEATURES.get(SqlFeature.ORACLE.name()).put(SqlFeature.LIMIT_FROM_TO, "select * from ( select row_.*, rownum rownum_ from ($S) row_ where rownum <= $m) where rownum_ > $F");
        FILTERED_FEATURES.get(SqlFeature.ORACLE.name()).put(SqlFeature.LIMIT_TO, "select * from ($S) where rownum <= $m");
        FILTERED_FEATURES.get(SqlFeature.MYSQL.name()).put(SqlFeature.LIMIT_FROM_TO, "$S limit $F, $M");
        FILTERED_FEATURES.get(SqlFeature.MYSQL.name()).put(SqlFeature.LIMIT_TO, "$S limit $M");
        FILTERED_FEATURES.get(SqlFeature.POSTGRESQL.name()).put(SqlFeature.LIMIT_FROM_TO, "$S limit $M offset $F");
        FILTERED_FEATURES.get(SqlFeature.POSTGRESQL.name()).put(SqlFeature.LIMIT_TO, "$S limit $M");
        FILTERED_FEATURES.get(SqlFeature.INFORMIX.name()).put(SqlFeature.LIMIT_FROM_TO, "select skip $F first $M $s");
        FILTERED_FEATURES.get(SqlFeature.INFORMIX.name()).put(SqlFeature.LIMIT_TO, "select first $M $s");
        FILTERED_FEATURES.get(SqlFeature.MSSQL.name()).put(SqlFeature.LIMIT_FROM_TO, "$S OFFSET ($F) ROWS FETCH NEXT ($M) ROWS ONLY");
        FILTERED_FEATURES.get(SqlFeature.MSSQL.name()).put(SqlFeature.LIMIT_TO, "select top ($M) $s");
        FILTERED_FEATURES.get(SqlFeature.DB2.name()).put(SqlFeature.LIMIT_FROM_TO, "select * from (select row_.*, rownumber() over() rownum_ from ($S) row_) where rownum_ <= $m and rownum_ > $F");
        FILTERED_FEATURES.get(SqlFeature.DB2.name()).put(SqlFeature.LIMIT_TO, "select * from (select row_.*, rownumber() over() rownum_ from ($S) row_) where rownum_ <= $m");
        FILTERED_FEATURES.get(SqlFeature.HSQLDB.name()).put(SqlFeature.SEQ, "call next value for $n");
        FILTERED_FEATURES.get(SqlFeature.ORACLE.name()).put(SqlFeature.SEQ, "select $n.nextval from dual");
        FILTERED_FEATURES.get(SqlFeature.POSTGRESQL.name()).put(SqlFeature.SEQ, "select nextval('$n')");
        FILTERED_FEATURES.get(SqlFeature.INFORMIX.name()).put(SqlFeature.SEQ, "SELECT FIRST 1 $n.NEXTVAL FROM systables");
        FILTERED_FEATURES.get(SqlFeature.DB2.name()).put(SqlFeature.SEQ, "values nextval for $n");
        FEATURES.put(SqlFeature.SEQ_NAME, "SQLPROC_SEQUENCE");
        FILTERED_FEATURES.get(SqlFeature.HSQLDB.name()).put(SqlFeature.IDSEL, "call identity()");
        FILTERED_FEATURES.get(SqlFeature.MYSQL.name()).put(SqlFeature.IDSEL, "select last_insert_id()");
        FILTERED_FEATURES.get(SqlFeature.POSTGRESQL.name()).put(SqlFeature.IDSEL, "select currval(pg_get_serial_sequence('$t','$c'))");
        FILTERED_FEATURES.get(SqlFeature.INFORMIX.name()).put(SqlFeature.IDSEL, "SELECT FIRST 1 dbinfo('bigserial') FROM systables");
        FILTERED_FEATURES.get(SqlFeature.INFORMIX.name()).put(SqlFeature.IDSEL_Long, "select dbinfo('bigserial') from informix.systables where tabid=1");
        FILTERED_FEATURES.get(SqlFeature.INFORMIX.name()).put(SqlFeature.IDSEL_Integer, "select dbinfo('sqlca.sqlerrd1') from informix.systables where tabid=1");
        FILTERED_FEATURES.get(SqlFeature.MSSQL.name()).put(SqlFeature.IDSEL, SqlFeature.JDBC.name());
        FILTERED_FEATURES.get(SqlFeature.DB2.name()).put(SqlFeature.IDSEL, "SELECT identity_val_local() FROM SYSIBM.DUAL");
        FEATURES.put(SqlFeature.VERSION_COLUMN, "version");
        FEATURES.put(SqlFeature.OPERATOR_ATTRIBUTE, "Op");
        FEATURES.put(SqlFeature.OPERATOR_ATTRIBUTE_IN_MAP, "operators");
        FEATURES.put(SqlFeature.LOG_SQL_COMMAND_FOR_EXCEPTION, Boolean.FALSE);
    }
}

