/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.webtau.javarunner.cfg;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.testingisdocumenting.webtau.cfg.WebTauConfig;
import org.testingisdocumenting.webtau.cfg.WebTauConfigHandler;
import org.testingisdocumenting.webtau.utils.ResourceUtils;

public class JavaResourceConfigHandler
implements WebTauConfigHandler {
    private static final String CFG_RESOURCE_PATH = "webtau.properties";

    public void onBeforeCreate(WebTauConfig cfg) {
    }

    public void onAfterCreate(WebTauConfig cfg) {
        if (!ResourceUtils.hasResource((String)CFG_RESOURCE_PATH)) {
            return;
        }
        try {
            Properties properties = new Properties();
            properties.load(ResourceUtils.resourceStream((String)CFG_RESOURCE_PATH));
            String environmentPrefix = "environments.";
            String environmentNamePrefix = environmentPrefix + cfg.getEnv() + ".";
            LinkedHashMap asMap = new LinkedHashMap();
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                String keyAsString = k.toString();
                if (!keyAsString.startsWith(environmentPrefix)) {
                    asMap.put(keyAsString, v);
                }
            }));
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                String keyAsString = k.toString();
                if (keyAsString.startsWith(environmentNamePrefix)) {
                    asMap.put(keyAsString.substring(environmentNamePrefix.length()), v);
                }
            }));
            cfg.acceptConfigValues(CFG_RESOURCE_PATH, asMap);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

