/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.webtau.javarunner.cfg;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.testingisdocumenting.webtau.cfg.WebTauConfig;
import org.testingisdocumenting.webtau.cfg.WebTauConfigHandler;
import org.testingisdocumenting.webtau.utils.ResourceUtils;

public class JavaResourceConfigHandler
implements WebTauConfigHandler {
    public void onBeforeCreate(WebTauConfig cfg) {
    }

    public void onAfterCreate(WebTauConfig cfg) {
        String configResourcePath = this.configResourcePath();
        if (!ResourceUtils.hasResource((String)configResourcePath)) {
            return;
        }
        try {
            Properties properties = new Properties();
            properties.load(ResourceUtils.resourceStream((String)configResourcePath));
            String environmentPrefix = "environments.";
            String environmentNamePrefix = environmentPrefix + cfg.getEnv() + ".";
            LinkedHashMap asMap = new LinkedHashMap();
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                String keyAsString = k.toString();
                if (!keyAsString.startsWith(environmentPrefix)) {
                    asMap.put(keyAsString, v);
                }
            }));
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                String keyAsString = k.toString();
                if (keyAsString.startsWith(environmentNamePrefix)) {
                    asMap.put(keyAsString.substring(environmentNamePrefix.length()), v);
                }
            }));
            cfg.acceptConfigValues(configResourcePath, asMap);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String configResourcePath() {
        return System.getProperty("webtau.properties", "webtau.properties");
    }
}

