/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.schema;

import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.parser.AnnotationParserFactory;
import com.sun.xml.xsom.parser.XSOMParser;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xmlobjects.schema.SchemaHandlerException;
import org.xmlobjects.util.xml.SecureXMLProcessors;

public class SchemaHandler {
    protected final Map<String, XSSchemaSet> schemas = new HashMap<String, XSSchemaSet>();
    protected final Map<String, String> visitedSchemaLocations = new LinkedHashMap<String, String>();
    private final Map<String, String> userSchemaLocations = new HashMap<String, String>();
    private SAXParserFactory saxParserFactory;
    private ErrorHandler errorHandler;
    private AnnotationParserFactory annotationParserFactory;

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public AnnotationParserFactory getAnnotationParserFactory() {
        return this.annotationParserFactory;
    }

    public void setAnnotationParserFactory(AnnotationParserFactory annotationParserFactory) {
        this.annotationParserFactory = annotationParserFactory;
    }

    public void registerSchemaLocation(String namespaceURI, Path file) {
        this.userSchemaLocations.putIfAbsent(namespaceURI, file.toUri().normalize().toString());
    }

    public void registerSchemaLocation(String namespaceURI, File file) {
        this.userSchemaLocations.putIfAbsent(namespaceURI, file.toURI().normalize().toString());
    }

    public void parseSchema(InputStream stream) throws SchemaHandlerException {
        this.parse(new InputSource(stream));
    }

    public void parseSchema(Reader reader) throws SchemaHandlerException {
        this.parse(new InputSource(reader));
    }

    public void parseSchema(Path file) throws SchemaHandlerException {
        this.parseSchema(file.toUri().normalize().toString());
    }

    public void parseSchema(File file) throws SchemaHandlerException {
        this.parseSchema(file.toURI().normalize().toString());
    }

    public void parseSchema(URL url) throws SchemaHandlerException {
        this.parseSchema(url.toExternalForm());
    }

    public void parseSchema(String systemId) throws SchemaHandlerException {
        this.parse(new InputSource(systemId));
    }

    public void parseSchema(String namespaceURI, String schemaLocation) throws SchemaHandlerException {
        if (this.schemas.containsKey(namespaceURI)) {
            return;
        }
        this.parseSchema(this.userSchemaLocations.getOrDefault(namespaceURI, schemaLocation));
    }

    public void resolveAndParseSchema(String namespaceURI) throws SchemaHandlerException {
        if (this.schemas.containsKey(namespaceURI)) {
            return;
        }
        String schemaLocation = this.userSchemaLocations.get(namespaceURI);
        if (schemaLocation == null) {
            throw new SchemaHandlerException("Failed to resolve the schema location for the target namespace '" + namespaceURI + "'.");
        }
        InputSource source = new InputSource(schemaLocation);
        source.setPublicId(namespaceURI);
        this.parse(source);
    }

    private void parse(InputSource source) throws SchemaHandlerException {
        XSSchemaSet schemaSet;
        for (String schemaLocation : this.visitedSchemaLocations.values()) {
            if (!schemaLocation.equals(source.getSystemId())) continue;
            return;
        }
        XSOMParser parser = new XSOMParser(this.getSAXParserFactory());
        parser.setErrorHandler(this.errorHandler);
        parser.setAnnotationParser(this.annotationParserFactory);
        parser.setEntityResolver((publicId, systemId) -> {
            InputSource resolved = null;
            if (publicId != null) {
                String schemaLocation = this.visitedSchemaLocations.get(publicId);
                if (schemaLocation == null) {
                    schemaLocation = this.userSchemaLocations.get(publicId);
                }
                if (schemaLocation != null) {
                    resolved = new InputSource(schemaLocation);
                    resolved.setPublicId(publicId);
                }
            }
            return resolved;
        });
        try {
            parser.parse(source);
            schemaSet = parser.getResult();
        }
        catch (SAXException e) {
            throw new SchemaHandlerException("Failed to parse schema document.", e);
        }
        if (schemaSet != null) {
            for (XSSchema schema : schemaSet.getSchemas()) {
                if ("http://www.w3.org/2001/XMLSchema".equals(schema.getTargetNamespace()) || "http://www.w3.org/2001/XMLSchema-instance".equals(schema.getTargetNamespace()) || "http://www.w3.org/2000/xmlns/".equals(schema.getTargetNamespace()) || "http://www.w3.org/XML/1998/namespace".equals(schema.getTargetNamespace())) continue;
                this.schemas.put(schema.getTargetNamespace(), schemaSet);
                Locator locator = schema.getLocator();
                if (locator == null) continue;
                String schemaLocation = this.visitedSchemaLocations.get(schema.getTargetNamespace());
                if (schemaLocation == null) {
                    this.visitedSchemaLocations.put(schema.getTargetNamespace(), locator.getSystemId());
                    continue;
                }
                try {
                    URL url = new URL(locator.getSystemId());
                    if (!url.getProtocol().equals("file") && !url.getProtocol().equals("jar")) continue;
                    this.visitedSchemaLocations.put(schema.getTargetNamespace(), locator.getSystemId());
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
    }

    public XSSchemaSet getSchemaSet(String namespaceURI) {
        return this.schemas.get(namespaceURI);
    }

    public Source[] getSchemas() {
        return (Source[])this.visitedSchemaLocations.values().stream().map(StreamSource::new).toArray(Source[]::new);
    }

    public Set<String> getTargetNamespaces() {
        return this.schemas.keySet();
    }

    public SchemaHandler copy(SchemaHandler other) {
        this.schemas.putAll(other.schemas);
        this.visitedSchemaLocations.putAll(other.visitedSchemaLocations);
        this.userSchemaLocations.putAll(other.userSchemaLocations);
        this.saxParserFactory = other.saxParserFactory;
        this.errorHandler = other.errorHandler;
        this.annotationParserFactory = other.annotationParserFactory;
        return this;
    }

    private SAXParserFactory getSAXParserFactory() throws SchemaHandlerException {
        if (this.saxParserFactory == null) {
            try {
                this.saxParserFactory = SecureXMLProcessors.newSAXParserFactory();
            }
            catch (Exception e) {
                throw new SchemaHandlerException("Failed to initialize secure XML schema reader.", e);
            }
        }
        return this.saxParserFactory;
    }
}

