/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.stream;

import java.util.function.Consumer;
import org.w3c.dom.Element;

public class BuildResult<T> {
    private static final BuildResult<?> EMPTY = new BuildResult<Object>(null, null);
    private final T object;
    private final Element element;

    private BuildResult(T object, Element element) {
        this.object = object;
        this.element = element;
    }

    public static <T> BuildResult<T> of(T object) {
        return new BuildResult<T>(object, null);
    }

    public static <T> BuildResult<T> of(Element element) {
        return new BuildResult<Object>(null, element);
    }

    public static <T> BuildResult<T> empty() {
        return EMPTY;
    }

    public boolean isSetObject() {
        return this.object != null;
    }

    public void ifObject(Consumer<T> action) {
        if (this.isSetObject()) {
            action.accept(this.object);
        }
    }

    public T getObject() {
        return this.object;
    }

    public boolean isSetDOMElement() {
        return this.element != null;
    }

    public void ifDOMElement(Consumer<Element> action) {
        if (this.isSetDOMElement()) {
            action.accept(this.element);
        }
    }

    public Element getDOMElement() {
        return this.element;
    }
}

