/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.stream;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xmlobjects.XMLObjects;
import org.xmlobjects.serializer.ObjectSerializeException;
import org.xmlobjects.serializer.ObjectSerializer;
import org.xmlobjects.stream.EventType;
import org.xmlobjects.stream.XMLOutput;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.util.Properties;
import org.xmlobjects.util.xml.SAXBuffer;
import org.xmlobjects.util.xml.SAXFilter;
import org.xmlobjects.xml.Attributes;
import org.xmlobjects.xml.ElementContent;
import org.xmlobjects.xml.Namespaces;
import org.xmlobjects.xml.TextContent;

public class XMLWriter
implements AutoCloseable {
    private final XMLObjects xmlObjects;
    private final XMLOutput<?> output;
    private final Map<Class<?>, ObjectSerializer<?>> serializerCache = new IdentityHashMap();
    private final Deque<QName> elements = new ArrayDeque<QName>();
    private Properties properties;
    private Transformer transformer;
    private SAXParser parser;
    private boolean prologWritten;
    private EventType lastEvent;

    XMLWriter(XMLObjects xmlObjects, XMLOutput<?> output) {
        this.xmlObjects = xmlObjects;
        this.output = output;
        output.getPrefixMapping().createInternalPrefixes(xmlObjects);
    }

    public XMLObjects getXMLObjects() {
        return this.xmlObjects;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    void setProperties(Properties properties) {
        this.properties = new Properties(properties);
    }

    public void flush() throws XMLWriteException {
        try {
            this.output.flush();
        }
        catch (Exception e) {
            throw new XMLWriteException("Caused by:", e);
        }
    }

    @Override
    public void close() throws XMLWriteException {
        try {
            if (this.lastEvent != EventType.END_DOCUMENT) {
                this.finishDocument(this.prologWritten);
            }
            this.output.close();
        }
        catch (Exception e) {
            throw new XMLWriteException("Caused by:", e);
        }
        finally {
            this.serializerCache.clear();
        }
    }

    public String getPrefix(String namespaceURI) {
        return this.output.getPrefix(namespaceURI);
    }

    public XMLWriter withPrefix(String prefix, String namespaceURI) {
        this.output.withPrefix(prefix, namespaceURI);
        return this;
    }

    public String getNamespaceURI(String prefix) {
        return this.output.getNamespaceURI(prefix);
    }

    public XMLWriter withDefaultNamespace(String namespaceURI) {
        this.output.withDefaultNamespace(namespaceURI);
        return this;
    }

    public String getIndent() {
        return this.output.getIndent();
    }

    public XMLWriter withIndent(String indent) {
        this.output.withIndent(indent);
        return this;
    }

    public boolean isWriteXMLDeclaration() {
        return this.output.isWriteXMLDeclaration();
    }

    public XMLWriter writeXMLDeclaration(boolean writeXMLDeclaration) {
        this.output.writeXMLDeclaration(writeXMLDeclaration);
        return this;
    }

    public String[] getHeaderComment() {
        return this.output.getHeaderComment();
    }

    public XMLWriter withHeaderComment(String ... headerComment) {
        this.output.withHeaderComment(headerComment);
        return this;
    }

    public String getSchemaLocation(String namespaceURI) {
        return this.output.getSchemaLocation(namespaceURI);
    }

    public XMLWriter withSchemaLocation(String namespaceURI, String schemaLocation) {
        this.output.withSchemaLocation(namespaceURI, schemaLocation);
        return this;
    }

    public void writeStartDocument() throws XMLWriteException {
        try {
            this.output.startDocument();
            this.prologWritten = true;
            this.lastEvent = EventType.START_DOCUMENT;
        }
        catch (SAXException e) {
            throw new XMLWriteException("Caused by:", e);
        }
    }

    public void writeEndDocument() throws XMLWriteException {
        this.finishDocument(true);
    }

    private void finishDocument(boolean writeEndDocument) throws XMLWriteException {
        while (!this.elements.isEmpty()) {
            this.writeEndElement();
        }
        if (writeEndDocument) {
            try {
                this.output.endDocument();
                this.lastEvent = EventType.END_DOCUMENT;
            }
            catch (SAXException e) {
                throw new XMLWriteException("Caused by:", e);
            }
        }
    }

    public void writeObject(Object object, Namespaces namespaces) throws ObjectSerializeException, XMLWriteException {
        this.writeElement(null, object, namespaces);
    }

    public <T> void writeObjectUsingSerializer(T object, Class<? extends ObjectSerializer<T>> type, Namespaces namespaces) throws ObjectSerializeException, XMLWriteException {
        this.writeElementUsingSerializer(null, object, type, namespaces);
    }

    public <T> void writeObjectUsingSerializer(T object, ObjectSerializer<T> serializer, Namespaces namespaces) throws ObjectSerializeException, XMLWriteException {
        this.writeElementUsingSerializer(null, object, serializer, namespaces);
    }

    public <T> void writeElement(org.xmlobjects.xml.Element element, T object, Namespaces namespaces) throws ObjectSerializeException, XMLWriteException {
        ObjectSerializer<?> serializer;
        if (object != null && (serializer = this.xmlObjects.getSerializer(object.getClass(), namespaces)) != null) {
            this.writeElementUsingSerializer(element, object, serializer, namespaces);
        }
    }

    public <T> void writeElementUsingSerializer(org.xmlobjects.xml.Element element, T object, Class<? extends ObjectSerializer<T>> type, Namespaces namespaces) throws ObjectSerializeException, XMLWriteException {
        this.writeElementUsingSerializer(element, object, this.getOrCreateSerializer(type), namespaces);
    }

    public <T> void writeElementUsingSerializer(org.xmlobjects.xml.Element element, T object, ObjectSerializer<T> serializer, Namespaces namespaces) throws ObjectSerializeException, XMLWriteException {
        if (object != null) {
            if (element == null) {
                element = serializer.createElement(object, namespaces);
            }
            if (element != null) {
                serializer.initializeElement(element, object, namespaces, this);
                this.writeStartElement(element);
            }
            serializer.writeChildElements(object, namespaces, this);
            if (element != null) {
                this.writeEndElement();
            }
        }
    }

    public void writeElement(org.xmlobjects.xml.Element element) throws XMLWriteException {
        this.writeStartElement(element);
        this.writeEndElement();
    }

    public void writeStartElement(org.xmlobjects.xml.Element element) throws XMLWriteException {
        if (element == null) {
            throw new XMLWriteException("Illegal to call writeStartElement with a null element.");
        }
        this.writeStartElement(element.getName(), element.getAttributes());
        if (element.hasContent()) {
            for (ElementContent content : element.getContent()) {
                if (content.isSetElement()) {
                    this.writeElement(content.getElement());
                    continue;
                }
                if (!content.isSetTextContent() || !content.getTextContent().isPresent()) continue;
                this.writeCharacters(content.getTextContent().get());
            }
        }
    }

    private void writeStartElement(QName name, Attributes attributes) throws XMLWriteException {
        try {
            AttributesImpl attrs = new AttributesImpl();
            if (attributes != null && !attributes.isEmpty()) {
                for (Map.Entry<String, Map<String, TextContent>> entry : attributes.get().entrySet()) {
                    for (Map.Entry<String, TextContent> attribute : entry.getValue().entrySet()) {
                        if (!attribute.getValue().isPresent()) continue;
                        String namespaceURI = entry.getKey();
                        String localName = attribute.getKey();
                        String qName = this.getQName(namespaceURI, localName);
                        attrs.addAttribute(namespaceURI, localName, qName, "CDATA", attribute.getValue().get());
                    }
                }
            }
            String namespaceURI = name.getNamespaceURI();
            String localName = name.getLocalPart();
            this.output.startElement(namespaceURI, localName, localName, attrs);
            this.elements.push(name);
            this.lastEvent = EventType.START_ELEMENT;
        }
        catch (SAXException e) {
            throw new XMLWriteException("Caused by:", e);
        }
    }

    private String getQName(String namespaceURI, String localName) throws SAXException {
        if (namespaceURI != null && !namespaceURI.isEmpty()) {
            String prefix = this.output.getPrefix(namespaceURI);
            if (prefix == null || prefix.equals("")) {
                prefix = this.output.createPrefix(namespaceURI);
                this.output.startPrefixMapping(prefix, namespaceURI);
            }
            return prefix + ":" + localName;
        }
        return localName;
    }

    public void writeEndElement() throws XMLWriteException {
        try {
            QName name = this.elements.pop();
            this.output.endElement(name.getNamespaceURI(), name.getLocalPart(), "");
            this.lastEvent = EventType.END_ELEMENT;
        }
        catch (SAXException e) {
            throw new XMLWriteException("Caused by:", e);
        }
    }

    public void writeEndElements(int count) throws XMLWriteException {
        while (count-- > 0) {
            this.writeEndElement();
        }
    }

    public void writeCharacters(String text, int start, int length) throws XMLWriteException {
        try {
            char[] characters = text.toCharArray();
            this.output.characters(characters, start, length);
        }
        catch (SAXException e) {
            throw new XMLWriteException("Caused by:", e);
        }
    }

    public void writeCharacters(String text) throws XMLWriteException {
        this.writeCharacters(text, 0, text.length());
    }

    public void writeDOMElement(Element element) throws XMLWriteException {
        if (element == null) {
            return;
        }
        try {
            if (this.transformer == null) {
                this.transformer = TransformerFactory.newInstance().newTransformer();
            }
            DOMSource source = new DOMSource(element);
            SAXResult result = new SAXResult(new DOMHandler(this.output));
            this.transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            throw new XMLWriteException("Failed to initialize DOM transformer.", e);
        }
        catch (TransformerException e) {
            throw new XMLWriteException("Failed to write DOM element as XML content.", e);
        }
        finally {
            if (this.transformer != null) {
                this.transformer.reset();
            }
        }
    }

    public void writeMixedContent(String mixedContent) throws XMLWriteException {
        try {
            if (this.parser == null) {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                this.parser = factory.newSAXParser();
            }
            MixedContentBuffer buffer = new MixedContentBuffer();
            this.parser.getXMLReader().setContentHandler(buffer);
            this.parser.getXMLReader().parse(new InputSource(new StringReader("<dummy>" + mixedContent + "</dummy>")));
            buffer.send(this.output, true);
        }
        catch (ParserConfigurationException e) {
            throw new XMLWriteException("Failed to initialize mixed content parser.", e);
        }
        catch (IOException | SAXException e) {
            throw new XMLWriteException("Failed to write mixed content.", e);
        }
        finally {
            if (this.parser != null) {
                this.parser.reset();
            }
        }
    }

    public <T> ObjectSerializer<T> getOrCreateSerializer(Class<? extends ObjectSerializer<T>> type) throws ObjectSerializeException {
        ObjectSerializer<?> cachedSerializer = this.serializerCache.get(type);
        if (cachedSerializer != null && type.isAssignableFrom(cachedSerializer.getClass())) {
            return type.cast(cachedSerializer);
        }
        try {
            ObjectSerializer<T> serializer = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.serializerCache.put(type, serializer);
            return serializer;
        }
        catch (Exception e) {
            throw new ObjectSerializeException("The serializer " + type.getName() + " lacks a default constructor.");
        }
    }

    public ContentHandler getContentHandler() {
        return this.getContentHandler(false);
    }

    public ContentHandler getContentHandler(final boolean writeFragment) {
        return new SAXFilter(this.output){

            @Override
            public void startDocument() throws SAXException {
                if (!writeFragment) {
                    super.startDocument();
                    XMLWriter.this.prologWritten = true;
                    XMLWriter.this.lastEvent = EventType.START_DOCUMENT;
                }
            }

            @Override
            public void endDocument() throws SAXException {
                if (!writeFragment) {
                    super.endDocument();
                    XMLWriter.this.lastEvent = EventType.END_DOCUMENT;
                }
            }

            @Override
            public void startElement(String uri, String localName, String qName, org.xml.sax.Attributes atts) throws SAXException {
                super.startElement(uri, localName, qName, atts);
                XMLWriter.this.elements.push(new QName(uri, localName));
                XMLWriter.this.lastEvent = EventType.START_ELEMENT;
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                super.endElement(uri, localName, qName);
                XMLWriter.this.elements.pop();
                XMLWriter.this.lastEvent = EventType.END_ELEMENT;
            }
        };
    }

    private static class MixedContentBuffer
    extends SAXBuffer {
        int depth = 0;

        private MixedContentBuffer() {
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, org.xml.sax.Attributes attributes) throws SAXException {
            if (this.depth++ > 0) {
                super.startElement(uri, localName, qName, attributes);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (--this.depth > 0) {
                super.endElement(uri, localName, qName);
            }
        }
    }

    private static class DOMHandler
    extends SAXFilter {
        DOMHandler(ContentHandler parent) {
            super(parent);
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void endDocument() {
        }
    }
}

