/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.stream;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.ContentHandler;
import org.xmlobjects.XMLObjects;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.stream.XMLWriter;
import org.xmlobjects.util.Properties;
import org.xmlobjects.util.xml.SAXOutputHandler;
import org.xmlobjects.util.xml.SAXWriter;

public class XMLWriterFactory {
    private final XMLObjects xmlObjects;
    private final Properties properties = new Properties();
    private SAXTransformerFactory transformerFactory;

    private XMLWriterFactory(XMLObjects xmlObjects) {
        this.xmlObjects = Objects.requireNonNull(xmlObjects, "XML objects must not be null.");
    }

    public static XMLWriterFactory newInstance(XMLObjects xmlObjects) {
        return new XMLWriterFactory(xmlObjects);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public XMLWriterFactory withProperty(String name, Object value) {
        this.properties.set(name, value);
        return this;
    }

    public XMLWriter createWriter(File file) throws XMLWriteException {
        return this.createWriter(file, StandardCharsets.UTF_8.name());
    }

    public XMLWriter createWriter(File file, String encoding) throws XMLWriteException {
        try {
            return this.createWriter(new SAXWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.getEncoding(encoding))));
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            throw new XMLWriteException("Caused by:", e);
        }
    }

    public XMLWriter createWriter(Path path) throws XMLWriteException {
        return this.createWriter(path, StandardCharsets.UTF_8.name());
    }

    public XMLWriter createWriter(Path path, String encoding) throws XMLWriteException {
        try {
            return this.createWriter(new SAXWriter(new OutputStreamWriter(Files.newOutputStream(path, new OpenOption[0]), this.getEncoding(encoding))));
        }
        catch (IOException e) {
            throw new XMLWriteException("Caused by:", e);
        }
    }

    public XMLWriter createWriter(StreamResult result) throws XMLWriteException {
        return this.createWriter(result, StandardCharsets.UTF_8.name());
    }

    public XMLWriter createWriter(StreamResult result, String encoding) throws XMLWriteException {
        try {
            return this.createWriter(new SAXWriter(result, this.getEncoding(encoding)));
        }
        catch (IOException e) {
            throw new XMLWriteException("Caused by:", e);
        }
    }

    public XMLWriter createWriter(DOMResult result) throws XMLWriteException {
        try {
            if (this.transformerFactory == null) {
                this.transformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
            }
            TransformerHandler handler = this.transformerFactory.newTransformerHandler();
            handler.setResult(result);
            return this.createWriter(handler);
        }
        catch (TransformerConfigurationException e) {
            throw new XMLWriteException("Caused by:", e);
        }
    }

    public XMLWriter createWriter(OutputStream stream) throws XMLWriteException {
        return this.createWriter(stream, StandardCharsets.UTF_8.name());
    }

    public XMLWriter createWriter(OutputStream stream, String encoding) throws XMLWriteException {
        try {
            return this.createWriter(new SAXWriter(stream, this.getEncoding(encoding)));
        }
        catch (IOException e) {
            throw new XMLWriteException("Caused by:", e);
        }
    }

    public XMLWriter createWriter(Writer writer) {
        return this.createWriter(new SAXWriter(writer));
    }

    public XMLWriter createWriter(SAXWriter saxWriter) {
        XMLWriter xmlWriter = new XMLWriter(this.xmlObjects, saxWriter);
        xmlWriter.setProperties(this.properties);
        return xmlWriter;
    }

    public XMLWriter createWriter(ContentHandler contentHandler) {
        XMLWriter xmlWriter = new XMLWriter(this.xmlObjects, new SAXOutputHandler(contentHandler));
        xmlWriter.setProperties(this.properties);
        return xmlWriter;
    }

    private String getEncoding(String encoding) {
        return encoding != null ? encoding : StandardCharsets.UTF_8.name();
    }
}

