/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.util.composite;

import java.util.Objects;
import javax.xml.namespace.QName;
import org.xmlobjects.builder.ObjectBuildException;
import org.xmlobjects.builder.ObjectBuilder;
import org.xmlobjects.serializer.ObjectSerializeException;
import org.xmlobjects.serializer.ObjectSerializer;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.stream.XMLWriter;
import org.xmlobjects.xml.Attributes;
import org.xmlobjects.xml.Element;
import org.xmlobjects.xml.Namespaces;

public abstract class CompositeObjectAdapter<T>
implements ObjectBuilder<T>,
ObjectSerializer<T> {
    private final Class<? extends ObjectBuilder<T>> builder;
    private final Class<? extends ObjectSerializer<T>> serializer;

    public <S extends ObjectBuilder<? super T> & ObjectSerializer<? super T>> CompositeObjectAdapter(Class<S> adapter) {
        this.builder = Objects.requireNonNull(adapter, "Object adapter must not be null.");
        this.serializer = adapter;
    }

    @Override
    public void initializeObject(T object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        reader.getOrCreateBuilder(this.builder).initializeObject(object, name, attributes, reader);
    }

    @Override
    public void buildChildObject(T object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        reader.getOrCreateBuilder(this.builder).buildChildObject(object, name, attributes, reader);
    }

    @Override
    public void initializeElement(Element element, T object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        writer.getOrCreateSerializer(this.serializer).initializeElement(element, object, namespaces, writer);
    }

    @Override
    public void writeChildElements(T object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        writer.getOrCreateSerializer(this.serializer).writeChildElements(object, namespaces, writer);
    }
}

