/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.util.composite;

import java.util.Objects;
import org.xmlobjects.serializer.ObjectSerializeException;
import org.xmlobjects.serializer.ObjectSerializer;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.stream.XMLWriter;
import org.xmlobjects.xml.Element;
import org.xmlobjects.xml.Namespaces;

public abstract class CompositeObjectSerializer<T>
implements ObjectSerializer<T> {
    private final Class<? extends ObjectSerializer<T>> serializer;

    public <S extends ObjectSerializer<? super T>> CompositeObjectSerializer(Class<S> adapter) {
        this.serializer = Objects.requireNonNull(adapter, "Object serializer must not be null.");
    }

    @Override
    public void initializeElement(Element element, T object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        writer.getOrCreateSerializer(this.serializer).initializeElement(element, object, namespaces, writer);
    }

    @Override
    public void writeChildElements(T object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        writer.getOrCreateSerializer(this.serializer).writeChildElements(object, namespaces, writer);
    }
}

