/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.util.copy;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.xmlobjects.model.Child;
import org.xmlobjects.model.ChildList;
import org.xmlobjects.util.copy.AbstractCloner;
import org.xmlobjects.util.copy.ArrayCloner;
import org.xmlobjects.util.copy.ChildListCloner;
import org.xmlobjects.util.copy.CollectionCloner;
import org.xmlobjects.util.copy.CopyException;
import org.xmlobjects.util.copy.MapCloner;
import org.xmlobjects.util.copy.ObjectCloner;

public class CopyBuilder {
    private final Map<Class<?>, AbstractCloner<?>> cloners = new IdentityHashMap();
    private final Map<Object, Object> clones = new IdentityHashMap<Object, Object>();
    private final Set<Class<?>> immutables = Collections.newSetFromMap(new IdentityHashMap());
    private final Set<Class<?>> nulls = Collections.newSetFromMap(new IdentityHashMap());
    private final AbstractCloner<Object> IDENTITY_CLONER = new IdentityCloner();
    private final AbstractCloner<Object> NULL_CLONER = new NullCloner();
    private final AbstractCloner<Collection<?>> COLLECTION_CLONER = new CollectionCloner(this);
    private final AbstractCloner<Map<?, ?>> MAP_CLONER = new MapCloner(this);
    private final AbstractCloner<Object[]> ARRAY_CLONER = new ArrayCloner(this);
    private final Object NULL = new Object();
    private boolean isCloning;
    private boolean failOnError;

    public CopyBuilder() {
        this.registerKnownCloners();
    }

    public <S> S shallowCopy(S src) {
        return this.copy(src, null, null, true);
    }

    public <S, D extends S> D shallowCopy(S src, D dest) {
        return this.shallowCopy(src, dest, null);
    }

    public <S extends T, D extends T, T> D shallowCopy(S src, D dest, Class<T> template) {
        return (D)this.copy(src, Objects.requireNonNull(dest, "The target object must not be null."), template, true);
    }

    public <S> S deepCopy(S src) {
        return this.copy(src, null, null, false);
    }

    public <S, D extends S> D deepCopy(S src, D dest) {
        return this.deepCopy(src, dest, null);
    }

    public <S extends T, D extends T, T> D deepCopy(S src, D dest, Class<T> template) {
        return (D)this.copy(src, Objects.requireNonNull(dest, "The target object must not be null."), template, false);
    }

    public <T> CopyBuilder registerCloner(Class<T> type, AbstractCloner<T> cloner) {
        cloner.setCopyBuilder(this);
        this.cloners.put(type, cloner);
        return this;
    }

    public CopyBuilder registerSelfCopy(Class<?> ... types) {
        Collections.addAll(this.immutables, types);
        return this;
    }

    public CopyBuilder registerNullCopy(Class<?> ... types) {
        Collections.addAll(this.nulls, types);
        return this;
    }

    public <T> CopyBuilder withClone(T src, Supplier<T> supplier) {
        if (src != null) {
            T clone = supplier.get();
            if (clone != null && !src.getClass().isAssignableFrom(clone.getClass()) && this.failOnError) {
                throw new CopyException("Type mismatch between object '" + src + "' and clone '" + clone + "'.");
            }
            this.clones.put(src, clone != null ? clone : this.NULL);
        }
        return this;
    }

    public CopyBuilder withSelfCopy(Object src) {
        if (src != null) {
            this.clones.put(src, src);
        }
        return this;
    }

    public CopyBuilder failOnError(boolean failOnError) {
        this.failOnError = failOnError;
        return this;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private <T> T copy(T src, T dest, Class<T> template, boolean shallowCopy) {
        if (src == null || src == dest /* !! */ ) {
            return dest /* !! */ ;
        }
        if (template /* !! */  == null) {
            template /* !! */  = src.getClass();
        }
        v0 = isInitial = this.isCloning == false;
        if (isInitial) {
            this.isCloning = true;
            if (src instanceof Child && (parent = ((Child)src).getParent()) != null) {
                this.clones.put(parent, parent);
            }
        }
        if ((clone = this.clones.get(src)) == null) {
            try {
                cloner = this.findCloner(template /* !! */ );
                if (cloner != this.IDENTITY_CLONER && cloner != this.NULL_CLONER) {
                    if (dest /* !! */  == null) {
                        dest /* !! */  = cloner.newInstance(src, shallowCopy);
                    }
                    this.clones.put(src, dest /* !! */  != null ? dest /* !! */  : this.NULL);
                }
                clone = cloner.copy(src, dest /* !! */ , shallowCopy);
            }
            catch (Throwable e) {
                if (!this.failOnError) ** GOTO lbl26
                throw e instanceof CopyException != false ? (CopyException)e : new CopyException("Failed to copy " + src + ".", e);
            }
        } else if (clone == this.NULL) {
            clone = null;
        }
lbl26:
        // 5 sources

        if (isInitial) {
            this.isCloning = false;
            this.clones.clear();
            if (clone instanceof Child) {
                ((Child)clone).setParent(null);
            }
        }
        return (T)clone;
    }

    private AbstractCloner<?> findCloner(Class<?> type) {
        AbstractCloner<?> cloner = this.cloners.get(type);
        if (cloner == null) {
            if (this.immutables.contains(type)) {
                return this.IDENTITY_CLONER;
            }
            if (this.nulls.contains(type)) {
                return this.NULL_CLONER;
            }
            if (Enum.class.isAssignableFrom(type)) {
                return this.IDENTITY_CLONER;
            }
            if (Collection.class.isAssignableFrom(type)) {
                return this.COLLECTION_CLONER;
            }
            if (Map.class.isAssignableFrom(type)) {
                return this.MAP_CLONER;
            }
            if (type.isArray()) {
                return this.ARRAY_CLONER;
            }
            cloner = new ObjectCloner(type, this);
            this.cloners.put(type, cloner);
        }
        return cloner;
    }

    private void registerKnownCloners() {
        this.cloners.put(String.class, this.IDENTITY_CLONER);
        this.cloners.put(Integer.class, this.IDENTITY_CLONER);
        this.cloners.put(Long.class, this.IDENTITY_CLONER);
        this.cloners.put(Boolean.class, this.IDENTITY_CLONER);
        this.cloners.put(Class.class, this.IDENTITY_CLONER);
        this.cloners.put(Float.class, this.IDENTITY_CLONER);
        this.cloners.put(Double.class, this.IDENTITY_CLONER);
        this.cloners.put(Character.class, this.IDENTITY_CLONER);
        this.cloners.put(Byte.class, this.IDENTITY_CLONER);
        this.cloners.put(Short.class, this.IDENTITY_CLONER);
        this.cloners.put(Void.class, this.IDENTITY_CLONER);
        this.cloners.put(BigDecimal.class, this.IDENTITY_CLONER);
        this.cloners.put(BigInteger.class, this.IDENTITY_CLONER);
        this.cloners.put(URI.class, this.IDENTITY_CLONER);
        this.cloners.put(URL.class, this.IDENTITY_CLONER);
        this.cloners.put(UUID.class, this.IDENTITY_CLONER);
        this.cloners.put(Pattern.class, this.IDENTITY_CLONER);
        this.cloners.put(Clock.class, this.IDENTITY_CLONER);
        this.cloners.put(Duration.class, this.IDENTITY_CLONER);
        this.cloners.put(Instant.class, this.IDENTITY_CLONER);
        this.cloners.put(LocalDate.class, this.IDENTITY_CLONER);
        this.cloners.put(LocalDateTime.class, this.IDENTITY_CLONER);
        this.cloners.put(LocalTime.class, this.IDENTITY_CLONER);
        this.cloners.put(MonthDay.class, this.IDENTITY_CLONER);
        this.cloners.put(OffsetDateTime.class, this.IDENTITY_CLONER);
        this.cloners.put(OffsetTime.class, this.IDENTITY_CLONER);
        this.cloners.put(Period.class, this.IDENTITY_CLONER);
        this.cloners.put(Year.class, this.IDENTITY_CLONER);
        this.cloners.put(YearMonth.class, this.IDENTITY_CLONER);
        this.cloners.put(ZonedDateTime.class, this.IDENTITY_CLONER);
        this.cloners.put(Collections.EMPTY_LIST.getClass(), this.IDENTITY_CLONER);
        this.cloners.put(Collections.EMPTY_MAP.getClass(), this.IDENTITY_CLONER);
        this.cloners.put(Collections.EMPTY_SET.getClass(), this.IDENTITY_CLONER);
        this.cloners.put(ChildList.class, new ChildListCloner(this));
    }

    private static final class NullCloner
    extends AbstractCloner<Object> {
        private NullCloner() {
        }

        @Override
        public Object copy(Object src, Object dest, boolean shallowCopy) {
            return null;
        }
    }

    private static final class IdentityCloner
    extends AbstractCloner<Object> {
        private IdentityCloner() {
        }

        @Override
        public Object copy(Object src, Object dest, boolean shallowCopy) {
            return src;
        }
    }
}

