/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.util.xml;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.EmptyStackException;
import java.util.Iterator;

public class ArrayBuffer<T>
implements Iterable<T> {
    static final int DEFAULT_BUFFER_SIZE = 512;
    private static final Object[] EMPTY = new Object[0];
    private final Class<T> type;
    private final int containerSize;
    private Container<T> current;
    private transient int modCount;

    ArrayBuffer(Class<T> type, int containerSize) {
        if (containerSize <= 0) {
            throw new IllegalArgumentException("Container size must be greater than zero.");
        }
        this.type = type;
        this.containerSize = containerSize;
        this.current = new Container<T>(type, containerSize);
    }

    void push(T item) {
        ++this.modCount;
        if (this.current.index == this.current.items.length) {
            this.current = new Container<T>(this.type, this.containerSize, this.current);
        }
        this.current.items[this.current.index++] = item;
    }

    T peek() {
        Container<T> container = this.current.index == 0 ? this.current.previous : this.current;
        return container != null ? (T)container.items[container.index - 1] : null;
    }

    T pop() {
        ++this.modCount;
        if (this.current.index == 0) {
            if (this.current.previous == null) {
                throw new EmptyStackException();
            }
            this.current = this.current.previous;
            this.current.next = null;
        }
        Object item = this.current.items[--this.current.index];
        this.current.items[this.current.index] = null;
        return item;
    }

    public void trimToSize() {
        ++this.modCount;
        if (this.current.index < this.current.items.length) {
            this.current.items = this.current.index == 0 ? EMPTY : Arrays.copyOf(this.current.items, this.current.index);
        }
    }

    void clear() {
        ++this.modCount;
        this.current = new Container<T>(this.type, this.containerSize);
    }

    boolean isEmpty() {
        return this.current.index == 0 && this.current.previous == null;
    }

    ArrayBufferIterator<T> iterator(boolean release) {
        return new ArrayBufferIterator(this, release);
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator(false);
    }

    static class ArrayBufferIterator<T>
    implements Iterator<T> {
        private final ArrayBuffer<T> buffer;
        private final boolean release;
        private final int modCount;
        private Container<T> current;
        private int index;

        ArrayBufferIterator(ArrayBuffer<T> buffer, boolean release) {
            this.buffer = buffer;
            this.release = release;
            this.modCount = buffer.modCount;
            this.current = buffer.current;
            while (this.current.previous != null) {
                this.current = this.current.previous;
            }
            if (release) {
                buffer.current = new Container(buffer.type, buffer.containerSize);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.index < this.current.index) {
                return true;
            }
            if (this.index == this.current.items.length) {
                return this.current.next != null && this.current.next.index > 0;
            }
            return false;
        }

        T peek() {
            if (this.modCount != this.buffer.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.index < this.current.index) {
                return this.current.items[this.index];
            }
            if (this.index == this.current.items.length && this.current.next != null && this.current.next.index > 0) {
                return this.current.next.items[0];
            }
            return null;
        }

        @Override
        public T next() {
            T item = this.peek();
            if (this.index == this.current.items.length) {
                this.current = this.current.next;
                this.index = 0;
                if (this.release) {
                    this.current.previous = null;
                }
            }
            if (this.release) {
                this.current.items[this.index] = null;
            }
            ++this.index;
            return item;
        }
    }

    private static class Container<T> {
        private T[] items;
        private int index;
        private Container<T> next;
        private Container<T> previous;

        Container(Class<T> type, int containerSize) {
            this.items = (Object[])Array.newInstance(type, containerSize);
        }

        Container(Class<T> type, int containerSize, Container<T> previous) {
            this(type, containerSize);
            this.previous = previous;
            previous.next = this;
        }
    }
}

