/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.util.xml;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xmlobjects.stream.XMLOutput;

public class SAXWriter
extends XMLOutput<SAXWriter> {
    private final String LINE_SEPARATOR = System.getProperty("line.separator");
    private Writer writer;
    private String encoding;
    private CharsetEncoder encoder;
    private boolean escapeCharacters = true;
    private boolean writeEncoding = false;
    private int depth = 0;
    private XMLEvents lastEvent;

    public SAXWriter(StreamResult streamResult) throws IOException {
        this.setOutput(streamResult);
    }

    public SAXWriter(StreamResult streamResult, String encoding) throws IOException {
        this.setOutput(streamResult, encoding);
    }

    public SAXWriter(OutputStream outputStream) throws IOException {
        this(outputStream, null);
    }

    public SAXWriter(OutputStream outputStream, String encoding) throws IOException {
        this.setOutput(outputStream, encoding);
    }

    public SAXWriter(Writer writer) {
        this.setOutput(writer);
    }

    private void setOutput(StreamResult streamResult) throws IOException {
        this.setOutput(streamResult, null);
    }

    private void setOutput(OutputStream outputStream) throws IOException {
        this.setOutput(outputStream, null);
    }

    private void setOutput(StreamResult streamResult, String encoding) throws IOException {
        if (streamResult.getOutputStream() != null) {
            this.setOutput(streamResult.getOutputStream(), encoding);
        } else if (streamResult.getWriter() != null) {
            this.setOutput(streamResult.getWriter());
        } else if (streamResult.getSystemId() != null) {
            this.setOutput(new FileOutputStream(streamResult.getSystemId()), encoding);
        }
    }

    private void setOutput(Writer writer) {
        if (writer instanceof OutputStreamWriter) {
            this.writer = new BufferedWriter(writer);
            String encoding = ((OutputStreamWriter)writer).getEncoding();
            if (encoding != null) {
                this.setEncoding(encoding);
            }
        } else {
            this.writer = writer;
        }
    }

    private void setOutput(OutputStream outputStream, String encoding) throws IOException {
        if (encoding == null) {
            encoding = System.getProperty("file.encoding", "UTF-8");
        }
        this.writer = new BufferedWriter(new OutputStreamWriter(outputStream, encoding));
        this.setEncoding(encoding);
    }

    @Override
    public void flush() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public boolean isEscapeCharacters() {
        return this.escapeCharacters;
    }

    public SAXWriter escapeCharacters(boolean escapeCharacters) {
        this.escapeCharacters = escapeCharacters;
        return this;
    }

    private void setEncoding(String name) {
        Charset charset = Charset.forName(name);
        this.encoding = charset.name();
        this.writeEncoding = true;
        if (!this.encoding.equalsIgnoreCase("UTF-8")) {
            this.encoder = charset.newEncoder();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            if (length > 0) {
                if (this.lastEvent == XMLEvents.START_ELEMENT) {
                    this.writer.write(62);
                }
                this.writeTextContent(ch, start, length, this.escapeCharacters);
                this.lastEvent = XMLEvents.CHARACTERS;
            }
        }
        catch (IOException e) {
            throw new SAXException("Caused by:", e);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            --this.depth;
            if (this.lastEvent == XMLEvents.START_ELEMENT) {
                this.writer.write("/>");
            } else {
                if (this.lastEvent == XMLEvents.END_ELEMENT) {
                    this.writeIndent();
                }
                this.writer.write("</");
                if (!localName.isEmpty()) {
                    this.writeQName(this.prefixMapping.getPrefix(namespaceURI), localName);
                } else {
                    this.writer.write(qName);
                }
                this.writer.write(62);
            }
            this.lastEvent = XMLEvents.END_ELEMENT;
            this.prefixMapping.popContext();
        }
        catch (IOException e) {
            throw new SAXException("Caused by:", e);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            if (this.lastEvent != XMLEvents.END_ELEMENT) {
                if (length > 0 && this.lastEvent == XMLEvents.START_ELEMENT) {
                    this.writer.write(62);
                }
                this.writeTextContent(ch, start, length, this.escapeCharacters);
                this.lastEvent = XMLEvents.CHARACTERS;
            }
        }
        catch (IOException e) {
            throw new SAXException("Caused by:", e);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        try {
            if (this.lastEvent == XMLEvents.START_ELEMENT) {
                this.writer.write(62);
                this.writeIndent();
            }
            if (target == null || data == null) {
                throw new SAXException("PI target cannot be null.");
            }
            this.writer.write("<?");
            this.writer.write(target);
            this.writer.write(32);
            this.writer.write(data);
            this.writer.write("?>");
            this.writeIndent();
            this.lastEvent = XMLEvents.PROCESSING_INSTRUCTION;
        }
        catch (IOException e) {
            throw new SAXException("Caused by:", e);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            if (this.depth == 0 && this.lastEvent != XMLEvents.START_DOCUMENT) {
                if (this.writeXMLDeclaration) {
                    if (this.encoding == null && this.writer instanceof OutputStreamWriter) {
                        this.encoding = ((OutputStreamWriter)this.writer).getEncoding();
                        if (this.encoding != null) {
                            this.encoding = Charset.forName(this.encoding).name();
                        }
                    }
                    this.writer.write("<?xml");
                    this.writer.write(" version=\"1.0\"");
                    if (this.writeEncoding && this.encoding != null) {
                        this.writer.write(" encoding=");
                        this.writer.write(34);
                        this.writer.write(this.encoding);
                        this.writer.write(34);
                    }
                    this.writer.write(" standalone=\"yes\"");
                    this.writer.write("?>");
                    this.writeIndent();
                }
                if (this.headerComment != null) {
                    this.writeHeader(this.headerComment);
                }
            }
            this.lastEvent = XMLEvents.START_DOCUMENT;
        }
        catch (IOException e) {
            throw new SAXException("Caused by:", e);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            this.prefixMapping.pushContext();
            if (this.depth > 0) {
                if (this.lastEvent == XMLEvents.START_ELEMENT) {
                    this.writer.write(62);
                }
                this.writeIndent();
            }
            this.writer.write(60);
            if (!localName.isEmpty()) {
                String prefix = this.prefixMapping.getPrefix(namespaceURI);
                if (prefix == null) {
                    prefix = this.prefixMapping.createPrefixFromQName(qName, namespaceURI);
                    this.prefixMapping.declarePrefix(prefix, namespaceURI);
                }
                this.writeQName(prefix, localName);
            } else {
                this.writer.write(qName);
            }
            this.writeAttributes(atts);
            this.writeNamespaces(this.prefixMapping.getCurrentContext());
            if (this.depth == 0) {
                this.writeSchemaLocations();
            }
            this.lastEvent = XMLEvents.START_ELEMENT;
            this.prefixMapping.requireNextContext();
            ++this.depth;
        }
        catch (IOException e) {
            throw new SAXException("Caused by:", e);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String namespaceURI) throws SAXException {
        String previous = this.prefixMapping.getPrefix(namespaceURI);
        if (previous == null || !namespaceURI.equals(this.prefixMapping.getNamespaceURI(previous))) {
            this.prefixMapping.pushContext();
            this.prefixMapping.declarePrefix(prefix, namespaceURI);
        }
    }

    private void writeAttributes(Attributes atts) throws SAXException {
        if (atts.getLength() > 0) {
            try {
                HashMap<String, String> prefixes = null;
                for (int i = 0; i < atts.getLength(); ++i) {
                    String localName = atts.getLocalName(i);
                    String namespaceURI = atts.getURI(i);
                    String prefix = null;
                    if (namespaceURI != null && !namespaceURI.isEmpty()) {
                        if (namespaceURI.equals("http://www.w3.org/2000/xmlns/")) continue;
                        prefix = this.prefixMapping.getPrefix(namespaceURI);
                        if (prefix == null) {
                            prefix = this.prefixMapping.createPrefixFromQName(atts.getQName(i), namespaceURI);
                            this.prefixMapping.declarePrefix(prefix, namespaceURI);
                        } else if (prefix.equals("")) {
                            if (prefixes == null) {
                                prefixes = new HashMap<String, String>();
                            }
                            String name = atts.getQName(i);
                            prefix = prefixes.computeIfAbsent(namespaceURI, v -> this.prefixMapping.createPrefixFromQName(name, namespaceURI));
                        }
                    }
                    this.writer.write(32);
                    this.writeQName(prefix, localName);
                    this.writer.write("=\"");
                    this.writeAttributeContent(atts.getValue(i));
                    this.writer.write(34);
                }
                if (prefixes != null) {
                    this.writeNamespaces(prefixes);
                }
            }
            catch (IOException e) {
                throw new SAXException("Caused by:", e);
            }
        }
    }

    private void writeQName(String prefix, String localName) throws SAXException {
        try {
            if (prefix != null && !prefix.equals("")) {
                this.writer.write(prefix);
                this.writer.write(58);
            }
            this.writer.write(localName);
        }
        catch (IOException e) {
            throw new SAXException("Caused by:", e);
        }
    }

    private void writeNamespaces(Map<String, String> prefixes) throws SAXException {
        try {
            for (Map.Entry<String, String> entry : prefixes.entrySet()) {
                String namespaceURI = entry.getKey();
                String prefix = entry.getValue();
                this.writer.write(32);
                this.writer.write("xmlns");
                if (!prefix.isEmpty()) {
                    this.writer.write(58);
                    this.writer.write(prefix);
                }
                this.writer.write("=\"");
                this.writeAttributeContent(namespaceURI);
                this.writer.write(34);
            }
        }
        catch (IOException e) {
            throw new SAXException("Caused by:", e);
        }
    }

    private void writeSchemaLocations() throws SAXException {
        if (!this.schemaLocations.isEmpty()) {
            try {
                String prefix = this.prefixMapping.getPrefix("http://www.w3.org/2001/XMLSchema-instance");
                this.writer.write(32);
                this.writeQName(prefix, "schemaLocation");
                this.writer.write("=\"");
                Iterator iter = this.schemaLocations.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    this.writeAttributeContent((String)entry.getKey());
                    this.writer.write(32);
                    this.writeAttributeContent((String)entry.getValue());
                    if (!iter.hasNext()) continue;
                    this.writer.write(32);
                }
                this.writer.write(34);
            }
            catch (IOException e) {
                throw new SAXException("Caused by:", e);
            }
        }
    }

    private void writeHeader(String ... data) throws SAXException {
        try {
            if (this.lastEvent == XMLEvents.START_ELEMENT) {
                this.writer.write(62);
                this.writeIndent();
            }
            if (data == null) {
                throw new SAXException("Comment target cannot be null.");
            }
            for (String line : data) {
                if (line == null) continue;
                this.writer.write("<!--");
                this.writer.write(32);
                this.writer.write(line);
                this.writer.write(32);
                this.writer.write("-->");
                this.writeIndent();
            }
        }
        catch (IOException e) {
            throw new SAXException("Caused by:", e);
        }
    }

    private void writeIndent() throws SAXException {
        if (this.indent == null) {
            return;
        }
        if (this.lastEvent == XMLEvents.CHARACTERS) {
            return;
        }
        try {
            this.writer.write(this.LINE_SEPARATOR);
            for (int i = 0; i < this.depth; ++i) {
                this.writer.write(this.indent);
            }
        }
        catch (IOException e) {
            throw new SAXException("Caused by:", e);
        }
    }

    private void writeTextContent(char[] content, int start, int length, boolean escapeCharacters) throws IOException {
        int pos = start;
        int end = start + length;
        block4: for (int i = start; i < end; ++i) {
            char ch = content[i];
            if (this.encoder != null && !this.encoder.canEncode(ch)) {
                this.writer.write(content, pos, i - pos);
                this.writer.write("&#x");
                this.writer.write(Integer.toHexString(ch));
                this.writer.write(59);
                pos = i + 1;
                continue;
            }
            if (!escapeCharacters) continue;
            switch (ch) {
                case '<': {
                    this.writer.write(content, pos, i - pos);
                    this.writer.write("&lt;");
                    pos = i + 1;
                    continue block4;
                }
                case '&': {
                    this.writer.write(content, pos, i - pos);
                    this.writer.write("&amp;");
                    pos = i + 1;
                }
            }
        }
        this.writer.write(content, pos, end - pos);
    }

    private void writeAttributeContent(String content) throws IOException {
        int pos = 0;
        int end = content.length();
        block5: for (int i = 0; i < end; ++i) {
            char ch = content.charAt(i);
            if (this.encoder != null && !this.encoder.canEncode(ch)) {
                this.writer.write(content, pos, i - pos);
                this.writer.write("&#x");
                this.writer.write(Integer.toHexString(ch));
                this.writer.write(59);
                pos = i + 1;
                continue;
            }
            switch (ch) {
                case '<': {
                    this.writer.write(content, pos, i - pos);
                    this.writer.write("&lt;");
                    pos = i + 1;
                    continue block5;
                }
                case '&': {
                    this.writer.write(content, pos, i - pos);
                    this.writer.write("&amp;");
                    pos = i + 1;
                    continue block5;
                }
                case '\"': {
                    this.writer.write(content, pos, i - pos);
                    this.writer.write("&quot;");
                    pos = i + 1;
                }
            }
        }
        this.writer.write(content, pos, end - pos);
    }

    private static enum XMLEvents {
        START_DOCUMENT,
        START_ELEMENT,
        END_ELEMENT,
        CHARACTERS,
        PROCESSING_INSTRUCTION;

    }
}

