/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.util.xml;

import javax.xml.stream.XMLStreamReader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class StAXStream2SAX {
    private final ContentHandler handler;

    public StAXStream2SAX(ContentHandler handler) {
        this.handler = handler;
    }

    public ContentHandler getContentHandler() {
        return this.handler;
    }

    public void bridgeEvent(XMLStreamReader reader) throws SAXException {
        switch (reader.getEventType()) {
            case 1: {
                this.handleStartElement(reader);
                break;
            }
            case 2: {
                this.handleEndElement(reader);
                break;
            }
            case 4: 
            case 12: {
                this.handleCharacters(reader);
            }
        }
    }

    private void handleCharacters(XMLStreamReader reader) throws SAXException {
        this.handler.characters(reader.getTextCharacters(), reader.getTextStart(), reader.getTextLength());
    }

    private void handleEndElement(XMLStreamReader reader) throws SAXException {
        this.handler.endElement(this.getNamespaceURI(reader.getNamespaceURI()), reader.getLocalName(), this.getQName(reader.getPrefix(), reader.getLocalName()));
        for (int i = 0; i < reader.getNamespaceCount(); ++i) {
            this.handler.endPrefixMapping(reader.getNamespacePrefix(i));
        }
    }

    private void handleStartElement(XMLStreamReader reader) throws SAXException {
        for (int i = 0; i < reader.getNamespaceCount(); ++i) {
            this.handler.startPrefixMapping(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
        }
        this.handler.startElement(this.getNamespaceURI(reader.getNamespaceURI()), reader.getLocalName(), this.getQName(reader.getPrefix(), reader.getLocalName()), this.getAttributes(reader));
    }

    private Attributes getAttributes(XMLStreamReader reader) {
        AttributesImpl attributes = new AttributesImpl();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            attributes.addAttribute(this.getNamespaceURI(reader.getAttributeNamespace(i)), reader.getAttributeLocalName(i), this.getQName(reader.getAttributePrefix(i), reader.getAttributeLocalName(i)), reader.getAttributeType(i), reader.getAttributeValue(i));
        }
        return attributes;
    }

    private String getNamespaceURI(String namespaceURI) {
        return namespaceURI != null ? namespaceURI : "";
    }

    private String getQName(String prefix, String localName) {
        return prefix != null && !prefix.isEmpty() ? prefix + ":" + localName : localName;
    }
}

