/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.xml;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public class Namespaces {
    private static final Namespaces EMPTY = new Namespaces(Collections.singleton(""));
    private final Set<String> namespaces;

    private Namespaces(Set<String> namespaces) {
        this.namespaces = Objects.requireNonNull(namespaces, "Namespace URIs must not be null.");
    }

    public static Namespaces newInstance() {
        return new Namespaces(new HashSet<String>());
    }

    public static Namespaces of(Collection<String> namespaceURIs) {
        return new Namespaces(new HashSet<String>(namespaceURIs));
    }

    public static Namespaces of(String ... namespaceURIs) {
        return Namespaces.of(Arrays.asList(namespaceURIs));
    }

    public static Namespaces empty() {
        return EMPTY;
    }

    public Set<String> get() {
        return this.namespaces;
    }

    public Namespaces add(String namespaceURI) {
        this.namespaces.add(namespaceURI);
        return this;
    }

    public Namespaces addNullNamespace() {
        this.namespaces.add("");
        return this;
    }

    public boolean contains(String namespaceURI) {
        return this.namespaces.contains(namespaceURI);
    }

    public boolean containsAll(Collection<String> namespaceURIs) {
        return this.namespaces.containsAll(namespaceURIs);
    }

    public boolean containsAll(String ... namespaceURIs) {
        return this.containsAll(Arrays.asList(namespaceURIs));
    }

    public Namespaces remove(String namespaceURI) {
        this.namespaces.remove(namespaceURI);
        return this;
    }

    public Namespaces removeIf(Predicate<? super String> filter) {
        this.namespaces.removeIf(filter);
        return this;
    }

    public Namespaces removeAll(Collection<String> namespaceURIs) {
        this.namespaces.removeAll(namespaceURIs);
        return this;
    }

    public Namespaces removeAll(String ... namespaceURIs) {
        return this.removeAll(Arrays.asList(namespaceURIs));
    }

    public Namespaces copy() {
        return new Namespaces(new HashSet<String>(this.namespaces));
    }
}

