/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.util.xml;

import java.net.URI;
import java.util.Objects;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xmlobjects.schema.SchemaHandler;
import org.xmlobjects.schema.SchemaHandlerException;
import org.xmlobjects.xml.Namespaces;

public class DepthXMLStreamReader
implements XMLStreamReader {
    private final XMLStreamReader reader;
    private final URI baseURI;
    private final Namespaces namespaces;
    private SchemaHandler schemaHandler;
    private int depth;
    private int state;

    public DepthXMLStreamReader(XMLStreamReader reader, URI baseURI) {
        this.reader = Objects.requireNonNull(reader, "XML stream reader must not be null.");
        this.baseURI = Objects.requireNonNull(baseURI, "The base URI must not be null.");
        this.namespaces = Namespaces.newInstance();
    }

    public DepthXMLStreamReader(XMLStreamReader reader) {
        this(reader, URI.create(""));
    }

    public XMLStreamReader getReader() {
        return this.reader;
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public Namespaces getNamespaces() {
        return this.namespaces;
    }

    public SchemaHandler getSchemaHandler() {
        return this.schemaHandler;
    }

    public void setSchemaHandler(SchemaHandler schemaHandler) {
        this.schemaHandler = schemaHandler;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getState() {
        return this.state;
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.reader.getProperty(name);
    }

    @Override
    public int next() throws XMLStreamException {
        int event = this.reader.next();
        ++this.state;
        if (event == 1) {
            int i;
            for (i = 0; i < this.reader.getNamespaceCount(); ++i) {
                this.namespaces.add(this.reader.getNamespaceURI(i));
            }
            if (this.schemaHandler != null) {
                block11: for (i = 0; i < this.reader.getAttributeCount(); ++i) {
                    if (!"http://www.w3.org/2001/XMLSchema-instance".equals(this.reader.getAttributeNamespace(i))) continue;
                    try {
                        switch (this.reader.getAttributeLocalName(i)) {
                            case "schemaLocation": {
                                String[] schemaLocations = this.reader.getAttributeValue(i).split("\\s+");
                                if (schemaLocations.length % 2 != 0) break;
                                for (int j = 0; j < schemaLocations.length; j += 2) {
                                    URI schemaLocation = this.baseURI.resolve(schemaLocations[j + 1].replaceAll("\\\\", "/"));
                                    this.schemaHandler.parseSchema(schemaLocations[j], schemaLocation.toString());
                                }
                                continue block11;
                            }
                            case "noNamespaceSchemaLocation": {
                                this.schemaHandler.parseSchema("", this.reader.getAttributeValue(i));
                            }
                        }
                        continue;
                    }
                    catch (SchemaHandlerException e) {
                        throw new XMLStreamException("Caused by: ", e);
                    }
                }
            }
            ++this.depth;
        } else if (event == 2) {
            --this.depth;
        }
        return event;
    }

    @Override
    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        this.reader.require(type, namespaceURI, localName);
    }

    @Override
    public String getElementText() throws XMLStreamException {
        String text = this.reader.getElementText();
        while (this.reader.getEventType() != 2) {
            this.reader.next();
        }
        --this.depth;
        return text;
    }

    @Override
    public int nextTag() throws XMLStreamException {
        int event = this.next();
        while (event == 4 && this.isWhiteSpace() || event == 12 && this.isWhiteSpace() || event == 6 || event == 3 || event == 5) {
            event = this.next();
        }
        if (event != 1 && event != 2) {
            throw new XMLStreamException("Expected start or end tag.", this.getLocation());
        }
        return event;
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        return this.reader.hasNext();
    }

    @Override
    public void close() throws XMLStreamException {
        this.reader.close();
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.reader.getNamespaceURI(prefix);
    }

    @Override
    public boolean isStartElement() {
        return this.reader.isStartElement();
    }

    @Override
    public boolean isEndElement() {
        return this.reader.isEndElement();
    }

    @Override
    public boolean isCharacters() {
        return this.reader.isCharacters();
    }

    @Override
    public boolean isWhiteSpace() {
        return this.reader.isWhiteSpace();
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        return this.reader.getAttributeValue(namespaceURI, localName);
    }

    @Override
    public int getAttributeCount() {
        return this.reader.getAttributeCount();
    }

    @Override
    public QName getAttributeName(int index) {
        return this.reader.getAttributeName(index);
    }

    @Override
    public String getAttributeNamespace(int index) {
        return this.reader.getAttributeNamespace(index);
    }

    @Override
    public String getAttributeLocalName(int index) {
        return this.reader.getAttributeLocalName(index);
    }

    @Override
    public String getAttributePrefix(int index) {
        return this.reader.getAttributePrefix(index);
    }

    @Override
    public String getAttributeType(int index) {
        return this.reader.getAttributeType(index);
    }

    @Override
    public String getAttributeValue(int index) {
        return this.reader.getAttributeValue(index);
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        return this.reader.isAttributeSpecified(index);
    }

    @Override
    public int getNamespaceCount() {
        return this.reader.getNamespaceCount();
    }

    @Override
    public String getNamespacePrefix(int index) {
        return this.reader.getNamespacePrefix(index);
    }

    @Override
    public String getNamespaceURI(int index) {
        return this.reader.getNamespaceURI(index);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.reader.getNamespaceContext();
    }

    @Override
    public int getEventType() {
        return this.reader.getEventType();
    }

    @Override
    public String getText() {
        return this.reader.getText();
    }

    @Override
    public char[] getTextCharacters() {
        return this.reader.getTextCharacters();
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        return this.reader.getTextCharacters(sourceStart, target, targetStart, length);
    }

    @Override
    public int getTextStart() {
        return this.reader.getTextStart();
    }

    @Override
    public int getTextLength() {
        return this.reader.getTextLength();
    }

    @Override
    public String getEncoding() {
        return this.reader.getEncoding();
    }

    @Override
    public boolean hasText() {
        return this.reader.hasText();
    }

    @Override
    public Location getLocation() {
        return this.reader.getLocation();
    }

    @Override
    public QName getName() {
        return this.reader.getName();
    }

    @Override
    public String getLocalName() {
        return this.reader.getLocalName();
    }

    @Override
    public boolean hasName() {
        return this.reader.hasName();
    }

    @Override
    public String getNamespaceURI() {
        return this.reader.getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return this.reader.getPrefix();
    }

    @Override
    public String getVersion() {
        return this.reader.getVersion();
    }

    @Override
    public boolean isStandalone() {
        return this.reader.isStandalone();
    }

    @Override
    public boolean standaloneSet() {
        return this.reader.standaloneSet();
    }

    @Override
    public String getCharacterEncodingScheme() {
        return this.reader.getCharacterEncodingScheme();
    }

    @Override
    public String getPITarget() {
        return this.reader.getPITarget();
    }

    @Override
    public String getPIData() {
        return this.reader.getPIData();
    }
}

