/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.util.xml;

import javax.xml.stream.XMLStreamReader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import org.xmlobjects.util.xml.ArrayBuffer;
import org.xmlobjects.util.xml.SAXStreamReader;

public class SAXBuffer
extends DefaultHandler {
    public static final int DEFAULT_BUFFER_SIZE = 512;
    static final byte UNDEFINED = 0;
    static final byte START_DOCUMENT = 1;
    static final byte END_DOCUMENT = 2;
    static final byte START_ELEMENT = 3;
    static final byte END_ELEMENT = 4;
    static final byte CHARACTERS = 5;
    static final byte NAMESPACE_PREFIX_MAPPING = 6;
    static final byte ATTRIBUTE = 7;
    private final String END_PREFIX_MAPPING = "END_PREFIX_MAPPING";
    private final ArrayBuffer<Byte> events;
    private final ArrayBuffer<String> strings;
    private final ArrayBuffer<char[]> characters;
    private byte lastElement = 0;
    private boolean useAsFragment;
    private boolean assumeMixedContent = true;

    public SAXBuffer(int bufferSize) {
        this.events = new ArrayBuffer<Byte>(Byte.class, bufferSize);
        this.strings = new ArrayBuffer<String>(String.class, bufferSize);
        this.characters = new ArrayBuffer<char[]>(char[].class, bufferSize);
    }

    public SAXBuffer() {
        this(512);
    }

    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    public boolean isUseAsFragment() {
        return this.useAsFragment;
    }

    public SAXBuffer useAsFragment(boolean useAsFragment) {
        this.useAsFragment = useAsFragment;
        return this;
    }

    public boolean isAssumeMixedContent() {
        return this.assumeMixedContent;
    }

    public SAXBuffer assumeMixedContent(boolean assumeMixedContent) {
        this.assumeMixedContent = assumeMixedContent;
        return this;
    }

    public void removeTrailingCharacters() {
        while (!this.events.isEmpty() && this.events.peek() == 5) {
            this.events.pop();
            this.characters.pop();
        }
    }

    public void trimToSize() {
        this.events.trimToSize();
        this.strings.trimToSize();
        this.characters.trimToSize();
    }

    public void reset() {
        this.events.clear();
        this.strings.clear();
        this.characters.clear();
        this.lastElement = 0;
    }

    public void addStartDocument() {
        if (!this.useAsFragment) {
            this.events.push((byte)1);
        }
    }

    public void addEndDocument() {
        if (!this.useAsFragment) {
            this.events.push((byte)2);
        }
    }

    public void addNamespacePrefixMapping(String prefix, String uri) {
        this.events.push((byte)6);
        this.strings.push(prefix);
        this.strings.push(uri);
    }

    public void addStartElement(String uri, String localName, String qName) {
        if (!this.assumeMixedContent && this.lastElement == 3) {
            this.removeTrailingCharacters();
        }
        this.events.push((byte)3);
        this.strings.push(uri);
        this.strings.push(localName);
        this.strings.push(qName.length() != localName.length() ? qName : "");
        this.lastElement = (byte)3;
    }

    public void addAttribute(String uri, String localName, String qName, String type, String value) {
        if (this.lastElement == 3) {
            this.events.push((byte)7);
            this.strings.push(uri);
            this.strings.push(localName);
            this.strings.push(qName.length() != localName.length() ? qName : "");
            this.strings.push(type);
            this.strings.push(value);
        }
    }

    public void addEndElement() {
        this.events.push((byte)4);
        this.lastElement = (byte)4;
    }

    public void addCharacters(char[] chars) {
        if (this.assumeMixedContent || this.lastElement == 3) {
            this.events.push((byte)5);
            this.characters.push(chars);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.addStartDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.addEndDocument();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.addNamespacePrefixMapping(prefix, uri);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.addStartElement(uri, localName, qName);
        for (int i = 0; i < attributes.getLength(); ++i) {
            this.addAttribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getType(i), attributes.getValue(i));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.addEndElement();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        char[] chars = new char[length];
        System.arraycopy(ch, start, chars, 0, length);
        this.addCharacters(chars);
    }

    public XMLStreamReader toXMLStreamReader(boolean release) {
        SAXStreamReader reader = new SAXStreamReader(this.events.iterator(release), this.strings.iterator(release), this.characters.iterator(release));
        if (release) {
            this.lastElement = 0;
        }
        return reader;
    }

    public void send(ContentHandler handler, boolean release) throws SAXException {
        ArrayBuffer.ArrayBufferIterator<Byte> events = this.events.iterator(release);
        ArrayBuffer.ArrayBufferIterator<String> strings = this.strings.iterator(release);
        ArrayBuffer.ArrayBufferIterator<char[]> characters = this.characters.iterator(release);
        AttributesImpl attributes = new AttributesImpl();
        ArrayBuffer<String> util = new ArrayBuffer<String>(String.class, 512);
        if (release) {
            this.lastElement = 0;
        }
        while (events.hasNext()) {
            switch (events.next()) {
                case 3: {
                    this.sendStartElement(handler, events, strings, util, attributes);
                    break;
                }
                case 4: {
                    this.sendEndElement(handler, util);
                    break;
                }
                case 5: {
                    char[] ch = characters.next();
                    handler.characters(ch, 0, ch.length);
                    break;
                }
                case 6: {
                    this.sendStartPrefixMapping(handler, strings, util);
                    break;
                }
                case 1: {
                    handler.startDocument();
                    break;
                }
                case 2: {
                    handler.endDocument();
                }
            }
        }
    }

    private void sendStartElement(ContentHandler handler, ArrayBuffer.ArrayBufferIterator<Byte> events, ArrayBuffer.ArrayBufferIterator<String> strings, ArrayBuffer<String> util, AttributesImpl attributes) throws SAXException {
        String uri = strings.next();
        String localName = strings.next();
        String qName = strings.next();
        if (qName.isEmpty()) {
            qName = localName;
        }
        while (events.hasNext() && events.peek() == 7) {
            events.next();
            String attributeURI = strings.next();
            String attributeLocalName = strings.next();
            String attributeQName = strings.next();
            String attributeType = strings.next();
            String attributeValue = strings.next();
            attributes.addAttribute(attributeURI != null ? attributeURI : "", attributeLocalName, !attributeQName.isEmpty() ? attributeQName : attributeLocalName, attributeType, attributeValue);
        }
        handler.startElement(uri, localName, qName, attributes);
        util.push(uri);
        util.push(localName);
        util.push(qName);
        attributes.clear();
    }

    private void sendEndElement(ContentHandler handler, ArrayBuffer<String> util) throws SAXException {
        String qName = util.pop();
        String localName = util.pop();
        String uri = util.pop();
        handler.endElement(uri, localName, qName);
        while ("END_PREFIX_MAPPING".equals(util.peek())) {
            util.pop();
            String prefix = util.pop();
            handler.endPrefixMapping(prefix);
        }
    }

    private void sendStartPrefixMapping(ContentHandler handler, ArrayBuffer.ArrayBufferIterator<String> strings, ArrayBuffer<String> util) throws SAXException {
        String prefix = strings.next();
        String uri = strings.next();
        if (prefix == null) {
            prefix = "";
        }
        handler.startPrefixMapping(prefix, uri);
        util.push(prefix);
        util.push("END_PREFIX_MAPPING");
    }
}

