/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.xmlobjects.xml.TextContent;

public class Attributes {
    private final Map<String, Map<String, TextContent>> attributes = new HashMap<String, Map<String, TextContent>>();

    public void add(String namespaceURI, String localName, TextContent value) {
        this.attributes.computeIfAbsent(namespaceURI, v -> new HashMap()).put(localName, value);
    }

    public void add(String namespaceURI, String localName, String value) {
        this.add(namespaceURI, localName, TextContent.of(value));
    }

    public void add(String localName, TextContent value) {
        this.add("", localName, value);
    }

    public void add(String localName, String value) {
        this.add(localName, TextContent.of(value));
    }

    public void add(QName name, TextContent value) {
        this.add(name.getNamespaceURI(), name.getLocalPart(), value);
    }

    public void add(QName name, String value) {
        this.add(name, TextContent.of(value));
    }

    public void addAll(String namespaceURI, Map<String, TextContent> attributes) {
        this.attributes.computeIfAbsent(namespaceURI, v -> new HashMap()).putAll(attributes);
    }

    public boolean contains(String localName) {
        return this.contains("", localName);
    }

    public boolean contains(QName name) {
        return this.contains(name.getNamespaceURI(), name.getLocalPart());
    }

    public boolean contains(String namespaceURI, String localName) {
        return this.get(namespaceURI).containsKey(localName);
    }

    public Map<String, Map<String, TextContent>> get() {
        return this.attributes;
    }

    public Map<String, TextContent> get(String namespaceURI) {
        return this.attributes.getOrDefault(namespaceURI, Collections.emptyMap());
    }

    public TextContent getValue(String localName) {
        return this.getValue("", localName);
    }

    public TextContent getValue(String namespaceURI, String localName) {
        return this.get(namespaceURI).getOrDefault(localName, TextContent.absent());
    }

    public TextContent getValue(QName name) {
        return this.getValue(name.getNamespaceURI(), name.getLocalPart());
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public Attributes copy() {
        Attributes copy = new Attributes();
        copy.attributes.putAll(this.attributes);
        return copy;
    }
}

