/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.xml;

import java.util.Objects;
import org.xmlobjects.xml.Element;
import org.xmlobjects.xml.TextContent;

public class ElementContent {
    private static final ElementContent EMPTY = new ElementContent(null, null);
    private final TextContent textContent;
    private final Element element;

    private ElementContent(TextContent textContent, Element element) {
        this.textContent = textContent;
        this.element = element;
    }

    public static ElementContent of(TextContent textContent) {
        return new ElementContent(Objects.requireNonNull(textContent, "Text content must not be null."), null);
    }

    public static ElementContent of(Element element) {
        return new ElementContent(null, Objects.requireNonNull(element, "XML element must not be null."));
    }

    public static ElementContent empty() {
        return EMPTY;
    }

    public boolean isSetTextContent() {
        return this.textContent != null;
    }

    public TextContent getTextContent() {
        return this.textContent;
    }

    public boolean isSetElement() {
        return this.element != null;
    }

    public Element getElement() {
        return this.element;
    }
}

