/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.xml;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.xmlobjects.xml.CalendarField;
import org.xmlobjects.xml.TextHelper;

public class TextContent {
    private static final TextContent ABSENT = new TextContent("");
    private static boolean WITH_TIME_OFFSET = true;
    private static boolean WITH_DATE_OFFSET = false;
    private String content;
    private String trimmedContent;
    private String[] tokenizedContent;
    private Object value;

    private TextContent(String content) {
        this.content = Objects.requireNonNull(content, "Content must not be null.");
    }

    public static TextContent absent() {
        return ABSENT;
    }

    public static TextContent of(String content) {
        return TextContent.ofObject(content);
    }

    public static TextContent ofList(List<String> content) {
        return TextContent.ofObjectList(content);
    }

    public static TextContent ofBoolean(Boolean content) {
        return TextContent.ofObject(content);
    }

    public static TextContent ofBooleanList(List<Boolean> content) {
        return TextContent.ofObjectList(content);
    }

    public static TextContent ofDouble(Double content) {
        return TextContent.ofObject(content);
    }

    public static TextContent ofDoubleList(List<Double> content) {
        return TextContent.ofObjectList(content);
    }

    public static TextContent ofInteger(Integer content) {
        return TextContent.ofObject(content);
    }

    public static TextContent ofIntegerList(List<Integer> content) {
        return TextContent.ofObjectList(content);
    }

    public static TextContent ofDuration(Duration content) {
        return TextContent.ofObject(content);
    }

    public static TextContent ofDurationList(List<Duration> content) {
        return TextContent.ofObjectList(content);
    }

    public static TextContent ofDateTime(OffsetDateTime content, boolean withOffset) {
        return TextContent.ofOffsetDateTime(content, CalendarField.DATE_TIME_FIELDS, withOffset);
    }

    public static TextContent ofDateTime(OffsetDateTime content) {
        return TextContent.ofOffsetDateTime(content, CalendarField.DATE_TIME_FIELDS, WITH_TIME_OFFSET);
    }

    public static TextContent ofDateTimeList(List<OffsetDateTime> content, boolean withOffset) {
        return TextContent.ofOffsetDateTimeList(content, CalendarField.DATE_TIME_FIELDS, withOffset);
    }

    public static TextContent ofDateTimeList(List<OffsetDateTime> content) {
        return TextContent.ofOffsetDateTimeList(content, CalendarField.DATE_TIME_FIELDS, WITH_TIME_OFFSET);
    }

    public static TextContent ofTime(OffsetDateTime content, boolean withOffset) {
        return TextContent.ofOffsetDateTime(content, CalendarField.TIME_FIELDS, withOffset);
    }

    public static TextContent ofTime(OffsetDateTime content) {
        return TextContent.ofOffsetDateTime(content, CalendarField.TIME_FIELDS, WITH_TIME_OFFSET);
    }

    public static TextContent ofTimeList(List<OffsetDateTime> content, boolean withOffset) {
        return TextContent.ofOffsetDateTimeList(content, CalendarField.TIME_FIELDS, withOffset);
    }

    public static TextContent ofTimeList(List<OffsetDateTime> content) {
        return TextContent.ofOffsetDateTimeList(content, CalendarField.TIME_FIELDS, WITH_TIME_OFFSET);
    }

    public static TextContent ofDate(OffsetDateTime content, boolean withOffset) {
        return TextContent.ofOffsetDateTime(content, CalendarField.DATE_FIELDS, withOffset);
    }

    public static TextContent ofDate(OffsetDateTime content) {
        return TextContent.ofOffsetDateTime(content, CalendarField.DATE_FIELDS, WITH_DATE_OFFSET);
    }

    public static TextContent ofDateList(List<OffsetDateTime> content, boolean withOffset) {
        return TextContent.ofOffsetDateTimeList(content, CalendarField.DATE_FIELDS, withOffset);
    }

    public static TextContent ofDateList(List<OffsetDateTime> content) {
        return TextContent.ofOffsetDateTimeList(content, CalendarField.DATE_FIELDS, WITH_DATE_OFFSET);
    }

    public static TextContent ofGYearMonth(OffsetDateTime content, boolean withOffset) {
        return TextContent.ofOffsetDateTime(content, CalendarField.GYEAR_MONTH_FIELDS, withOffset);
    }

    public static TextContent ofGYearMonth(OffsetDateTime content) {
        return TextContent.ofOffsetDateTime(content, CalendarField.GYEAR_MONTH_FIELDS, WITH_DATE_OFFSET);
    }

    public static TextContent ofGYearMonthList(List<OffsetDateTime> content, boolean withOffset) {
        return TextContent.ofOffsetDateTimeList(content, CalendarField.GYEAR_MONTH_FIELDS, withOffset);
    }

    public static TextContent ofGYearMonthList(List<OffsetDateTime> content) {
        return TextContent.ofOffsetDateTimeList(content, CalendarField.GYEAR_MONTH_FIELDS, WITH_DATE_OFFSET);
    }

    public static TextContent ofGMonthDay(OffsetDateTime content, boolean withOffset) {
        return TextContent.ofOffsetDateTime(content, CalendarField.GMONTH_DAY_FIELDS, withOffset);
    }

    public static TextContent ofGMonthDay(OffsetDateTime content) {
        return TextContent.ofOffsetDateTime(content, CalendarField.GMONTH_DAY_FIELDS, WITH_DATE_OFFSET);
    }

    public static TextContent ofGMonthDayList(List<OffsetDateTime> content, boolean withOffset) {
        return TextContent.ofOffsetDateTimeList(content, CalendarField.GMONTH_DAY_FIELDS, withOffset);
    }

    public static TextContent ofGMonthDayList(List<OffsetDateTime> content) {
        return TextContent.ofOffsetDateTimeList(content, CalendarField.GMONTH_DAY_FIELDS, WITH_DATE_OFFSET);
    }

    public static TextContent ofGDay(OffsetDateTime content, boolean withOffset) {
        return TextContent.ofOffsetDateTime(content, CalendarField.GDAY_FIELDS, withOffset);
    }

    public static TextContent ofGDay(OffsetDateTime content) {
        return TextContent.ofOffsetDateTime(content, CalendarField.GDAY_FIELDS, WITH_DATE_OFFSET);
    }

    public static TextContent ofGDayList(List<OffsetDateTime> content, boolean withOffset) {
        return TextContent.ofOffsetDateTimeList(content, CalendarField.GDAY_FIELDS, withOffset);
    }

    public static TextContent ofGDayList(List<OffsetDateTime> content) {
        return TextContent.ofOffsetDateTimeList(content, CalendarField.GDAY_FIELDS, WITH_DATE_OFFSET);
    }

    public static TextContent ofGMonth(OffsetDateTime content, boolean withOffset) {
        return TextContent.ofOffsetDateTime(content, CalendarField.GMONTH_FIELDS, withOffset);
    }

    public static TextContent ofGMonth(OffsetDateTime content) {
        return TextContent.ofOffsetDateTime(content, CalendarField.GMONTH_FIELDS, WITH_DATE_OFFSET);
    }

    public static TextContent ofGMonthList(List<OffsetDateTime> content, boolean withOffset) {
        return TextContent.ofOffsetDateTimeList(content, CalendarField.GMONTH_FIELDS, withOffset);
    }

    public static TextContent ofGMonthList(List<OffsetDateTime> content) {
        return TextContent.ofOffsetDateTimeList(content, CalendarField.GMONTH_FIELDS, WITH_DATE_OFFSET);
    }

    public static TextContent ofGYear(OffsetDateTime content, boolean withOffset) {
        return TextContent.ofOffsetDateTime(content, CalendarField.GYEAR_FIELDS, withOffset);
    }

    public static TextContent ofGYear(OffsetDateTime content) {
        return TextContent.ofOffsetDateTime(content, CalendarField.GYEAR_FIELDS, WITH_DATE_OFFSET);
    }

    public static TextContent ofGYearList(List<OffsetDateTime> content, boolean withOffset) {
        return TextContent.ofOffsetDateTimeList(content, CalendarField.GYEAR_FIELDS, withOffset);
    }

    public static TextContent ofGYearList(List<OffsetDateTime> content) {
        return TextContent.ofOffsetDateTimeList(content, CalendarField.GYEAR_FIELDS, WITH_DATE_OFFSET);
    }

    public boolean isAbsent() {
        return this == ABSENT;
    }

    public boolean isEmpty() {
        return this != ABSENT && this.content.isEmpty();
    }

    public TextContent trim() {
        if (this.isPresent()) {
            this.content = this.trimContent();
        }
        return this;
    }

    public TextContent normalize() {
        if (this.isPresent()) {
            this.content = TextHelper.normalize(this.content);
        }
        return this;
    }

    public TextContent collapse() {
        if (this.isPresent()) {
            this.content = this.trimmedContent = TextHelper.collapse(this.content);
        }
        return this;
    }

    public String get() {
        return this.isPresent() ? this.content : null;
    }

    public String getOrElse(String defaultValue) {
        return this.getOrElse(this.get(), defaultValue);
    }

    public String getOrElseGet(Supplier<String> defaultValue) {
        return this.getOrElseGet(this.get(), defaultValue);
    }

    public boolean isPresent() {
        return this != ABSENT;
    }

    public void ifPresent(Consumer<String> action) {
        if (this.isPresent()) {
            action.accept(this.content);
        }
    }

    public List<String> getAsList() {
        List<String> list = this.getAsList(String.class);
        if (list != null) {
            return list;
        }
        if (this.tokenizeContent() == 0) {
            return null;
        }
        list = new ArrayList<String>(this.tokenizedContent.length);
        Collections.addAll(list, this.tokenizedContent);
        return this.setValue(list);
    }

    public List<String> getAsListOrElse(List<String> defaultValue) {
        return this.getOrElse(this.getAsList(), defaultValue);
    }

    public List<String> getAsListOrElseGet(Supplier<List<String>> defaultValue) {
        return this.getOrElseGet(this.getAsList(), defaultValue);
    }

    public boolean isList() {
        return this.getAsList() != null;
    }

    public void ifList(Consumer<List<String>> action) {
        List<String> value = this.getAsList();
        if (value != null) {
            action.accept(value);
        }
    }

    public Boolean getAsBoolean() {
        return this.parseValue(TextHelper::toBoolean, Boolean.class);
    }

    public Boolean getAsBooleanOrElse(Boolean defaultValue) {
        return this.getOrElse(this.getAsBoolean(), defaultValue);
    }

    public Boolean getAsBooleanOrElseGet(Supplier<Boolean> defaultValue) {
        return this.getOrElseGet(this.getAsBoolean(), defaultValue);
    }

    public boolean isBoolean() {
        return this.getAsBoolean() != null;
    }

    public void ifBoolean(Consumer<Boolean> action) {
        Boolean value = this.getAsBoolean();
        if (value != null) {
            action.accept(value);
        }
    }

    public List<Boolean> getAsBooleanList() {
        return this.parseValueList(TextHelper::toBoolean, Boolean.class);
    }

    public List<Boolean> getAsBooleanListOrElse(List<Boolean> defaultValue) {
        return this.getOrElse(this.getAsBooleanList(), defaultValue);
    }

    public List<Boolean> getAsBooleanListOrElseGet(Supplier<List<Boolean>> defaultValue) {
        return this.getOrElseGet(this.getAsBooleanList(), defaultValue);
    }

    public boolean isBooleanList() {
        return this.getAsBooleanList() != null;
    }

    public void ifBooleanList(Consumer<List<Boolean>> action) {
        List<Boolean> value = this.getAsBooleanList();
        if (value != null) {
            action.accept(value);
        }
    }

    public Double getAsDouble() {
        return this.parseValue(Double::parseDouble, Double.class);
    }

    public Double getAsDoubleOrElse(Double defaultValue) {
        return this.getOrElse(this.getAsDouble(), defaultValue);
    }

    public Double getAsDoubleOrElseGet(Supplier<Double> defaultValue) {
        return this.getOrElseGet(this.getAsDouble(), defaultValue);
    }

    public boolean isDouble() {
        return this.getAsDouble() != null;
    }

    public void ifDouble(Consumer<Double> action) {
        Double value = this.getAsDouble();
        if (value != null) {
            action.accept(value);
        }
    }

    public List<Double> getAsDoubleList() {
        return this.parseValueList(Double::parseDouble, Double.class);
    }

    public List<Double> getAsDoubleListOrElse(List<Double> defaultValue) {
        return this.getOrElse(this.getAsDoubleList(), defaultValue);
    }

    public List<Double> getAsDoubleListOrElseGet(Supplier<List<Double>> defaultValue) {
        return this.getOrElseGet(this.getAsDoubleList(), defaultValue);
    }

    public boolean isDoubleList() {
        return this.getAsDoubleList() != null;
    }

    public void ifDoubleList(Consumer<List<Double>> action) {
        List<Double> value = this.getAsDoubleList();
        if (value != null) {
            action.accept(value);
        }
    }

    public Integer getAsInteger() {
        return this.parseValue(Integer::parseInt, Integer.class);
    }

    public Integer getAsIntegerOrElse(Integer defaultValue) {
        return this.getOrElse(this.getAsInteger(), defaultValue);
    }

    public Integer getAsIntegerOrElseGet(Supplier<Integer> defaultValue) {
        return this.getOrElseGet(this.getAsInteger(), defaultValue);
    }

    public boolean isInteger() {
        return this.getAsInteger() != null;
    }

    public void ifInteger(Consumer<Integer> action) {
        Integer value = this.getAsInteger();
        if (value != null) {
            action.accept(value);
        }
    }

    public List<Integer> getAsIntegerList() {
        return this.parseValueList(Integer::parseInt, Integer.class);
    }

    public List<Integer> getAsIntegerListOrElse(List<Integer> defaultValue) {
        return this.getOrElse(this.getAsIntegerList(), defaultValue);
    }

    public List<Integer> getAsIntegerListOrElseGet(Supplier<List<Integer>> defaultValue) {
        return this.getOrElseGet(this.getAsIntegerList(), defaultValue);
    }

    public boolean isIntegerList() {
        return this.getAsIntegerList() != null;
    }

    public void ifIntegerList(Consumer<List<Integer>> action) {
        List<Integer> value = this.getAsIntegerList();
        if (value != null) {
            action.accept(value);
        }
    }

    public Duration getAsDuration() {
        return this.parseValue(TextHelper::toDuration, Duration.class);
    }

    public Duration getAsDurationOrElse(Duration defaultValue) {
        return this.getOrElse(this.getAsDuration(), defaultValue);
    }

    public Duration getAsDurationOrElseGet(Supplier<Duration> defaultValue) {
        return this.getOrElseGet(this.getAsDuration(), defaultValue);
    }

    public boolean isDuration() {
        return this.getAsDuration() != null;
    }

    public void ifDuration(Consumer<Duration> action) {
        Duration value = this.getAsDuration();
        if (value != null) {
            action.accept(value);
        }
    }

    public List<Duration> getAsDurationList() {
        return this.parseValueList(TextHelper::toDuration, Duration.class);
    }

    public List<Duration> getAsDurationListOrElse(List<Duration> defaultValue) {
        return this.getOrElse(this.getAsDurationList(), defaultValue);
    }

    public List<Duration> getAsDurationListOrElseGet(Supplier<List<Duration>> defaultValue) {
        return this.getOrElseGet(this.getAsDurationList(), defaultValue);
    }

    public boolean isDurationList() {
        return this.getAsDurationList() != null;
    }

    public void ifDurationList(Consumer<List<Duration>> action) {
        List<Duration> value = this.getAsDurationList();
        if (value != null) {
            action.accept(value);
        }
    }

    public OffsetDateTime getAsDateTime() {
        return TextHelper.toOffsetDateTime(this.getAsCalendar("dateTime"));
    }

    public OffsetDateTime getAsDateTimeOrElse(OffsetDateTime defaultValue) {
        return this.getOrElse(this.getAsDateTime(), defaultValue);
    }

    public OffsetDateTime getAsDateTimeOrElseGet(Supplier<OffsetDateTime> defaultValue) {
        return this.getOrElseGet(this.getAsDateTime(), defaultValue);
    }

    public boolean isDateTime() {
        return this.getAsCalendar("dateTime") != null;
    }

    public void ifDateTime(Consumer<OffsetDateTime> action) {
        OffsetDateTime value = this.getAsDateTime();
        if (value != null) {
            action.accept(value);
        }
    }

    public List<OffsetDateTime> getAsDateTimeList() {
        return TextHelper.toOffsetDateTimeList(this.getAsCalendarList("dateTime"));
    }

    public List<OffsetDateTime> getAsDateTimeListOrElse(List<OffsetDateTime> defaultValue) {
        return this.getOrElse(this.getAsDateTimeList(), defaultValue);
    }

    public List<OffsetDateTime> getAsDateTimeListOrElseGet(Supplier<List<OffsetDateTime>> defaultValue) {
        return this.getOrElseGet(this.getAsDateTimeList(), defaultValue);
    }

    public boolean isDateTimeList() {
        return this.getAsCalendarList("dateTime") != null;
    }

    public void ifDateTimeList(Consumer<List<OffsetDateTime>> action) {
        List<OffsetDateTime> value = this.getAsDateTimeList();
        if (value != null) {
            action.accept(value);
        }
    }

    public OffsetDateTime getAsTime() {
        return TextHelper.toOffsetDateTime(this.getAsCalendar("time"));
    }

    public OffsetDateTime getAsTimeOrElse(OffsetDateTime defaultValue) {
        return this.getOrElse(this.getAsTime(), defaultValue);
    }

    public OffsetDateTime getAsTimeOrElseGet(Supplier<OffsetDateTime> defaultValue) {
        return this.getOrElseGet(this.getAsTime(), defaultValue);
    }

    public boolean isTime() {
        return this.getAsCalendar("time") != null;
    }

    public void ifTime(Consumer<OffsetDateTime> action) {
        OffsetDateTime value = this.getAsTime();
        if (value != null) {
            action.accept(value);
        }
    }

    public List<OffsetDateTime> getAsTimeList() {
        return TextHelper.toOffsetDateTimeList(this.getAsCalendarList("time"));
    }

    public List<OffsetDateTime> getAsTimeListOrElse(List<OffsetDateTime> defaultValue) {
        return this.getOrElse(this.getAsTimeList(), defaultValue);
    }

    public List<OffsetDateTime> getAsTimeListOrElseGet(Supplier<List<OffsetDateTime>> defaultValue) {
        return this.getOrElseGet(this.getAsTimeList(), defaultValue);
    }

    public boolean isTimeList() {
        return this.getAsCalendarList("time") != null;
    }

    public void ifTimeList(Consumer<List<OffsetDateTime>> action) {
        List<OffsetDateTime> value = this.getAsTimeList();
        if (value != null) {
            action.accept(value);
        }
    }

    public OffsetDateTime getAsDate() {
        return TextHelper.toOffsetDateTime(this.getAsCalendar("date"));
    }

    public OffsetDateTime getAsDateOrElse(OffsetDateTime defaultValue) {
        return this.getOrElse(this.getAsDate(), defaultValue);
    }

    public OffsetDateTime getAsDateOrElseGet(Supplier<OffsetDateTime> defaultValue) {
        return this.getOrElseGet(this.getAsDate(), defaultValue);
    }

    public boolean isDate() {
        return this.getAsCalendar("date") != null;
    }

    public void ifDate(Consumer<OffsetDateTime> action) {
        OffsetDateTime value = this.getAsDate();
        if (value != null) {
            action.accept(value);
        }
    }

    public List<OffsetDateTime> getAsDateList() {
        return TextHelper.toOffsetDateTimeList(this.getAsCalendarList("date"));
    }

    public List<OffsetDateTime> getAsDateListOrElse(List<OffsetDateTime> defaultValue) {
        return this.getOrElse(this.getAsDateList(), defaultValue);
    }

    public List<OffsetDateTime> getAsDateListOrElseGet(Supplier<List<OffsetDateTime>> defaultValue) {
        return this.getOrElseGet(this.getAsDateList(), defaultValue);
    }

    public boolean isDateList() {
        return this.getAsCalendarList("date") != null;
    }

    public void ifDateList(Consumer<List<OffsetDateTime>> action) {
        List<OffsetDateTime> value = this.getAsDateList();
        if (value != null) {
            action.accept(value);
        }
    }

    public OffsetDateTime getAsGYearMonth() {
        return TextHelper.toOffsetDateTime(this.getAsCalendar("gYearMonth"));
    }

    public OffsetDateTime getAsGYearMonthOrElse(OffsetDateTime defaultValue) {
        return this.getOrElse(this.getAsGYearMonth(), defaultValue);
    }

    public OffsetDateTime getAsGYearMonthOrElseGet(Supplier<OffsetDateTime> defaultValue) {
        return this.getOrElseGet(this.getAsGYearMonth(), defaultValue);
    }

    public boolean isGYearMonth() {
        return this.getAsCalendar("gYearMonth") != null;
    }

    public void ifGYearMonth(Consumer<OffsetDateTime> action) {
        OffsetDateTime value = this.getAsGYearMonth();
        if (value != null) {
            action.accept(value);
        }
    }

    public List<OffsetDateTime> getAsGYearMonthList() {
        return TextHelper.toOffsetDateTimeList(this.getAsCalendarList("gYearMonth"));
    }

    public List<OffsetDateTime> getAsGYearMonthListOrElse(List<OffsetDateTime> defaultValue) {
        return this.getOrElse(this.getAsGYearMonthList(), defaultValue);
    }

    public List<OffsetDateTime> getAsGYearMonthListOrElseGet(Supplier<List<OffsetDateTime>> defaultValue) {
        return this.getOrElseGet(this.getAsGYearMonthList(), defaultValue);
    }

    public boolean isGYearMonthList() {
        return this.getAsCalendarList("gYearMonth") != null;
    }

    public void ifGYearMonthList(Consumer<List<OffsetDateTime>> action) {
        List<OffsetDateTime> value = this.getAsGYearMonthList();
        if (value != null) {
            action.accept(value);
        }
    }

    public OffsetDateTime getAsGMonthDay() {
        return TextHelper.toOffsetDateTime(this.getAsCalendar("gMonthDay"));
    }

    public OffsetDateTime getAsGMonthDayOrElse(OffsetDateTime defaultValue) {
        return this.getOrElse(this.getAsGMonthDay(), defaultValue);
    }

    public OffsetDateTime getAsGMonthDayOrElseGet(Supplier<OffsetDateTime> defaultValue) {
        return this.getOrElseGet(this.getAsGMonthDay(), defaultValue);
    }

    public boolean isGMonthDay() {
        return this.getAsCalendar("gMonthDay") != null;
    }

    public void ifGMonthDay(Consumer<OffsetDateTime> action) {
        OffsetDateTime value = this.getAsGMonthDay();
        if (value != null) {
            action.accept(value);
        }
    }

    public List<OffsetDateTime> getAsGMonthDayList() {
        return TextHelper.toOffsetDateTimeList(this.getAsCalendarList("gMonthDay"));
    }

    public List<OffsetDateTime> getAsGMonthDayListOrElse(List<OffsetDateTime> defaultValue) {
        return this.getOrElse(this.getAsGMonthDayList(), defaultValue);
    }

    public List<OffsetDateTime> getAsGMonthDayListOrElseGet(Supplier<List<OffsetDateTime>> defaultValue) {
        return this.getOrElseGet(this.getAsGMonthDayList(), defaultValue);
    }

    public boolean isGMonthDayList() {
        return this.getAsCalendarList("gMonthDay") != null;
    }

    public void ifGMonthDayList(Consumer<List<OffsetDateTime>> action) {
        List<OffsetDateTime> value = this.getAsGMonthDayList();
        if (value != null) {
            action.accept(value);
        }
    }

    public OffsetDateTime getAsGDay() {
        return TextHelper.toOffsetDateTime(this.getAsCalendar("gDay"));
    }

    public OffsetDateTime getAsGDayOrElse(OffsetDateTime defaultValue) {
        return this.getOrElse(this.getAsGDay(), defaultValue);
    }

    public OffsetDateTime getAsGDayOrElseGet(Supplier<OffsetDateTime> defaultValue) {
        return this.getOrElseGet(this.getAsGDay(), defaultValue);
    }

    public boolean isGDay() {
        return this.getAsCalendar("gDay") != null;
    }

    public void ifGDay(Consumer<OffsetDateTime> action) {
        OffsetDateTime value = this.getAsGDay();
        if (value != null) {
            action.accept(value);
        }
    }

    public List<OffsetDateTime> getAsGDayList() {
        return TextHelper.toOffsetDateTimeList(this.getAsCalendarList("gDay"));
    }

    public List<OffsetDateTime> getAsGDayListOrElse(List<OffsetDateTime> defaultValue) {
        return this.getOrElse(this.getAsGDayList(), defaultValue);
    }

    public List<OffsetDateTime> getAsGDayListOrElseGet(Supplier<List<OffsetDateTime>> defaultValue) {
        return this.getOrElseGet(this.getAsGDayList(), defaultValue);
    }

    public boolean isGDayList() {
        return this.getAsCalendarList("gDay") != null;
    }

    public void ifGDayList(Consumer<List<OffsetDateTime>> action) {
        List<OffsetDateTime> value = this.getAsGDayList();
        if (value != null) {
            action.accept(value);
        }
    }

    public OffsetDateTime getAsGMonth() {
        return TextHelper.toOffsetDateTime(this.getAsCalendar("gMonth"));
    }

    public OffsetDateTime getAsGMonthOrElse(OffsetDateTime defaultValue) {
        return this.getOrElse(this.getAsGMonth(), defaultValue);
    }

    public OffsetDateTime getAsGMonthOrElseGet(Supplier<OffsetDateTime> defaultValue) {
        return this.getOrElseGet(this.getAsGMonth(), defaultValue);
    }

    public boolean isGMonth() {
        return this.getAsCalendar("gMonth") != null;
    }

    public void ifGMonth(Consumer<OffsetDateTime> action) {
        OffsetDateTime value = this.getAsGMonth();
        if (value != null) {
            action.accept(value);
        }
    }

    public List<OffsetDateTime> getAsGMonthList() {
        return TextHelper.toOffsetDateTimeList(this.getAsCalendarList("gMonth"));
    }

    public List<OffsetDateTime> getAsGMonthListOrElse(List<OffsetDateTime> defaultValue) {
        return this.getOrElse(this.getAsGMonthList(), defaultValue);
    }

    public List<OffsetDateTime> getAsGMonthListOrElseGet(Supplier<List<OffsetDateTime>> defaultValue) {
        return this.getOrElseGet(this.getAsGMonthList(), defaultValue);
    }

    public boolean isGMonthList() {
        return this.getAsCalendarList("gMonth") != null;
    }

    public void ifGMonthList(Consumer<List<OffsetDateTime>> action) {
        List<OffsetDateTime> value = this.getAsGMonthList();
        if (value != null) {
            action.accept(value);
        }
    }

    public OffsetDateTime getAsGYear() {
        return TextHelper.toOffsetDateTime(this.getAsCalendar("gYear"));
    }

    public OffsetDateTime getAsGYearOrElse(OffsetDateTime defaultValue) {
        return this.getOrElse(this.getAsGYear(), defaultValue);
    }

    public OffsetDateTime getAsGYearOrElseGet(Supplier<OffsetDateTime> defaultValue) {
        return this.getOrElseGet(this.getAsGYear(), defaultValue);
    }

    public boolean isGYear() {
        return this.getAsCalendar("gYear") != null;
    }

    public void ifGYear(Consumer<OffsetDateTime> action) {
        OffsetDateTime value = this.getAsGYear();
        if (value != null) {
            action.accept(value);
        }
    }

    public List<OffsetDateTime> getAsGYearList() {
        return TextHelper.toOffsetDateTimeList(this.getAsCalendarList("gYear"));
    }

    public List<OffsetDateTime> getAsGYearListOrElse(List<OffsetDateTime> defaultValue) {
        return this.getOrElse(this.getAsGYearList(), defaultValue);
    }

    public List<OffsetDateTime> getAsGYearListOrElseGet(Supplier<List<OffsetDateTime>> defaultValue) {
        return this.getOrElseGet(this.getAsGYearList(), defaultValue);
    }

    public boolean isGYearList() {
        return this.getAsCalendarList("gYear") != null;
    }

    public void ifGYearList(Consumer<List<OffsetDateTime>> action) {
        List<OffsetDateTime> value = this.getAsGYearList();
        if (value != null) {
            action.accept(value);
        }
    }

    private XMLGregorianCalendar getAsCalendar(String localName) {
        XMLGregorianCalendar calendar;
        Object object = this.value;
        if (object instanceof XMLGregorianCalendar && (calendar = (XMLGregorianCalendar)object).getXMLSchemaType().getLocalPart().equals(localName)) {
            return calendar;
        }
        if (this.trimContent().isEmpty()) {
            return null;
        }
        calendar = TextHelper.toCalendar(this.trimmedContent, localName);
        return calendar != null ? this.setValue(calendar) : null;
    }

    private List<XMLGregorianCalendar> getAsCalendarList(String localName) {
        List<XMLGregorianCalendar> list = this.getAsList(XMLGregorianCalendar.class);
        if (list != null && list.get(0).getXMLSchemaType().getLocalPart().equals(localName)) {
            return list;
        }
        if (this.tokenizeContent() == 0) {
            return null;
        }
        list = new ArrayList<XMLGregorianCalendar>(this.tokenizedContent.length);
        for (String token : this.tokenizedContent) {
            XMLGregorianCalendar parsed = TextHelper.toCalendar(token, localName);
            if (parsed == null) {
                return null;
            }
            list.add(parsed);
        }
        return this.setValue(list);
    }

    private <T> T setValue(T value) {
        this.value = value;
        return value;
    }

    private <T> T parseValue(Function<String, T> parser, Class<T> type) {
        Object v = this.value;
        if (type.isInstance(v)) {
            return type.cast(v);
        }
        if (this.trimContent().isEmpty()) {
            return null;
        }
        try {
            T parsed = parser.apply(this.trimmedContent);
            return parsed != null ? (T)this.setValue(parsed) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private <T> List<T> parseValueList(Function<String, T> parser, Class<T> type) {
        List<T> list = this.getAsList(type);
        if (list != null) {
            return list;
        }
        if (this.tokenizeContent() == 0) {
            return null;
        }
        list = new ArrayList<T>(this.tokenizedContent.length);
        for (String token : this.tokenizedContent) {
            try {
                T parsed = parser.apply(token);
                if (parsed == null) {
                    return null;
                }
                list.add(parsed);
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.setValue(list);
    }

    private <T> T getOrElse(T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }

    private <T> T getOrElseGet(T value, Supplier<T> defaultValue) {
        return value != null ? value : defaultValue.get();
    }

    private <T> List<T> getAsList(Class<T> type) {
        List list;
        Object object = this.value;
        return object instanceof List && !(list = (List)object).isEmpty() && type.isInstance(list.get(0)) ? list : null;
    }

    private static TextContent ofObject(Object value) {
        return value != null ? new TextContent(value.toString()) : ABSENT;
    }

    private static TextContent ofObjectList(List<?> values) {
        return values != null && !values.isEmpty() ? new TextContent(TextHelper.toContent(values)) : ABSENT;
    }

    private static TextContent ofOffsetDateTime(OffsetDateTime dateTime, EnumSet<CalendarField> fields, boolean withOffset) {
        XMLGregorianCalendar calendar = TextHelper.toCalendar(dateTime, fields, withOffset);
        return calendar != null ? new TextContent(calendar.toXMLFormat()) : ABSENT;
    }

    private static TextContent ofOffsetDateTimeList(List<OffsetDateTime> dateTimes, EnumSet<CalendarField> fields, boolean withOffset) {
        return dateTimes != null && !dateTimes.isEmpty() ? new TextContent(TextHelper.toContent(dateTimes, fields, withOffset)) : ABSENT;
    }

    public static void setZoneOffsetProvider(Function<LocalDateTime, ZoneOffset> zoneOffsetProvider) {
        TextHelper.setZoneOffsetProvider(zoneOffsetProvider);
    }

    public static void serializeTimeWithOffset(boolean useTimeOffset) {
        WITH_TIME_OFFSET = useTimeOffset;
    }

    public static void serializeDateWithOffset(boolean useDateOffset) {
        WITH_DATE_OFFSET = useDateOffset;
    }

    private String trimContent() {
        if (this.trimmedContent == null) {
            this.trimmedContent = this.isPresent() ? this.content.trim() : "";
        }
        return this.trimmedContent;
    }

    private int tokenizeContent() {
        if (this.tokenizedContent == null) {
            this.tokenizedContent = this.isPresent() ? TextHelper.tokenize(this.content) : new String[]{};
        }
        return this.tokenizedContent.length;
    }

    public String toString() {
        return this.content;
    }
}

