/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.xml;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.xmlobjects.xml.CalendarField;

public class TextHelper {
    private static final DatatypeFactory XML_TYPE_FACTORY;
    private static Function<LocalDateTime, ZoneOffset> ZONE_OFFSET_PROVIDER;

    private TextHelper() {
    }

    static void setZoneOffsetProvider(Function<LocalDateTime, ZoneOffset> zoneOffsetProvider) {
        if (zoneOffsetProvider != null) {
            ZONE_OFFSET_PROVIDER = zoneOffsetProvider;
        }
    }

    static Boolean toBoolean(String value) {
        return switch (value) {
            case "true", "1" -> Boolean.TRUE;
            case "false", "0" -> Boolean.FALSE;
            default -> null;
        };
    }

    static Duration toDuration(String value) {
        return XML_TYPE_FACTORY.newDuration(value);
    }

    static XMLGregorianCalendar toCalendar(String value, String localName) {
        try {
            XMLGregorianCalendar calendar = XML_TYPE_FACTORY.newXMLGregorianCalendar(value);
            if (calendar.getXMLSchemaType().getLocalPart().equals(localName)) {
                return calendar;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    static XMLGregorianCalendar toCalendar(OffsetDateTime dateTime, EnumSet<CalendarField> fields, boolean withOffset) {
        XMLGregorianCalendar calendar = null;
        if (dateTime != null) {
            calendar = XML_TYPE_FACTORY.newXMLGregorianCalendar(fields.contains((Object)CalendarField.YEAR) ? dateTime.getYear() : Integer.MIN_VALUE, fields.contains((Object)CalendarField.MONTH) ? dateTime.getMonthValue() : Integer.MIN_VALUE, fields.contains((Object)CalendarField.DAY) ? dateTime.getDayOfMonth() : Integer.MIN_VALUE, fields.contains((Object)CalendarField.HOUR) ? dateTime.getHour() : Integer.MIN_VALUE, fields.contains((Object)CalendarField.MINUTE) ? dateTime.getMinute() : Integer.MIN_VALUE, fields.contains((Object)CalendarField.SECOND) ? dateTime.getSecond() : Integer.MIN_VALUE, Integer.MIN_VALUE, withOffset && fields.contains((Object)CalendarField.TIMEZONE) ? dateTime.getOffset().getTotalSeconds() / 60 : Integer.MIN_VALUE);
            if (fields.contains((Object)CalendarField.NANO) && dateTime.getNano() != 0) {
                calendar.setFractionalSecond(BigDecimal.valueOf(dateTime.getNano(), 9).stripTrailingZeros());
            }
        }
        return calendar;
    }

    static OffsetDateTime toOffsetDateTime(XMLGregorianCalendar calendar) {
        if (calendar != null) {
            int day = calendar.getDay();
            int month = calendar.getMonth();
            int year = calendar.getYear();
            int hour = calendar.getHour();
            int minute = calendar.getMinute();
            int second = calendar.getSecond();
            int offset = calendar.getTimezone();
            BigDecimal fractional = calendar.getFractionalSecond();
            int nano = fractional != null ? (int)(fractional.doubleValue() * 1.0E9) : Integer.MIN_VALUE;
            LocalDateTime dateTime = LocalDateTime.of(year != Integer.MIN_VALUE ? year : 0, month != Integer.MIN_VALUE ? month : 1, day != Integer.MIN_VALUE ? day : 1, hour != Integer.MIN_VALUE ? hour : 0, minute != Integer.MIN_VALUE ? minute : 0, second != Integer.MIN_VALUE ? second : 0, nano != Integer.MIN_VALUE ? nano : 0);
            return OffsetDateTime.of(dateTime, offset != Integer.MIN_VALUE ? ZoneOffset.ofTotalSeconds(offset * 60) : ZONE_OFFSET_PROVIDER.apply(dateTime));
        }
        return null;
    }

    static List<OffsetDateTime> toOffsetDateTimeList(List<XMLGregorianCalendar> calendars) {
        if (calendars != null) {
            ArrayList<OffsetDateTime> dateTimes = new ArrayList<OffsetDateTime>(calendars.size());
            for (XMLGregorianCalendar calendar : calendars) {
                dateTimes.add(TextHelper.toOffsetDateTime(calendar));
            }
            return dateTimes;
        }
        return null;
    }

    static String toContent(List<?> values) {
        StringBuilder builder = new StringBuilder();
        for (Object value : values) {
            if (value == null) continue;
            if (!builder.isEmpty()) {
                builder.append(' ');
            }
            builder.append(value);
        }
        return builder.toString();
    }

    static String toContent(List<OffsetDateTime> dateTimes, EnumSet<CalendarField> fields, boolean withOffset) {
        StringBuilder builder = new StringBuilder();
        for (OffsetDateTime dateTime : dateTimes) {
            XMLGregorianCalendar calendar = TextHelper.toCalendar(dateTime, fields, withOffset);
            if (calendar == null) continue;
            if (!builder.isEmpty()) {
                builder.append(' ');
            }
            builder.append(calendar.toXMLFormat());
        }
        return builder.toString();
    }

    static String normalize(String value) {
        int length = value.length();
        if (length != 0) {
            char[] chars = value.toCharArray();
            for (int i = 0; i < length; ++i) {
                if (!Character.isWhitespace(chars[i])) continue;
                chars[i] = 32;
            }
            value = new String(chars);
        }
        return value;
    }

    static String collapse(String value) {
        int length = value.length();
        if (length != 0) {
            int i;
            for (i = 0; i < length && Character.isWhitespace(value.charAt(i)); ++i) {
            }
            if (i != length) {
                StringBuilder collapsed = new StringBuilder(length - i);
                char ch = value.charAt(i);
                collapsed.append(ch);
                boolean isWhiteSpace = false;
                ++i;
                while (i < length) {
                    ch = value.charAt(i);
                    if (Character.isWhitespace(ch)) {
                        isWhiteSpace = true;
                    } else {
                        if (isWhiteSpace) {
                            collapsed.append(' ');
                            isWhiteSpace = false;
                        }
                        collapsed.append(ch);
                    }
                    ++i;
                }
                value = collapsed.toString();
            } else {
                value = "";
            }
        }
        return value;
    }

    static String[] tokenize(String value) {
        int next;
        int length = value.length();
        String[] tokens = new String[length / 2 + 1];
        int noOfTokens = 0;
        int current = -1;
        do {
            if ((next = TextHelper.nextWhiteSpace(value, current + 1, length)) != current + 1) {
                tokens[noOfTokens++] = value.substring(current + 1, next);
            }
            current = next;
        } while (next != length);
        String[] tokenizedContent = new String[noOfTokens];
        System.arraycopy(tokens, 0, tokenizedContent, 0, noOfTokens);
        return tokenizedContent;
    }

    static int nextWhiteSpace(String value, int pos, int length) {
        while (pos < length && !Character.isWhitespace(value.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    static {
        ZONE_OFFSET_PROVIDER = dateTime -> ZoneOffset.systemDefault().getRules().getOffset((LocalDateTime)dateTime);
        try {
            XML_TYPE_FACTORY = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException("Failed to initialize datatype factory.", e);
        }
    }
}

