/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerControl;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.OverridenPropertyAnnotations;
import pl.fhframework.annotations.OverridenPropertyAnnotationsList;
import pl.fhframework.annotations.TemplateControl;
import pl.fhframework.annotations.XMLMetadataSubelementParent;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.IRowNumberOffsetSupplier;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.core.FhFormException;
import pl.fhframework.core.forms.IHasBoundableLabel;
import pl.fhframework.core.forms.IterationContext;
import pl.fhframework.core.forms.iterators.IMultipleIteratorComponentFactory;
import pl.fhframework.core.forms.iterators.IMultipleIteratorRepeatable;
import pl.fhframework.core.forms.iterators.IRepeatableIteratorInfo;
import pl.fhframework.core.util.StringUtils;
import pl.fhframework.forms.ICompilerAwareComponent;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.forms.ColumnPaged;
import pl.fhframework.model.forms.CompactLayout;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.GroupingComponent;
import pl.fhframework.model.forms.IGroupingComponent;
import pl.fhframework.model.forms.OutputLabel;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.TableCell;
import pl.fhframework.model.forms.TablePaged;
import pl.fhframework.model.forms.designer.BindingExpressionDesignerPreviewProvider;
import pl.fhframework.model.forms.table.AdHocTableColumnComponentFactory;
import pl.fhframework.model.forms.table.LowLevelRowMetadata;
import pl.fhframework.model.forms.table.RowIteratorMetadata;

@TemplateControl(tagName="fh-table-column")
@DesignerControl(defaultWidth=-1)
@Control(parents={Table.class, Column.class}, invalidParents={TablePaged.class, ColumnPaged.class})
@OverridenPropertyAnnotationsList(value={@OverridenPropertyAnnotations(designerXmlProperty={@DesignerXMLProperty(readOnlyInDesigner=false, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE, priority=100)}, property="width"), @OverridenPropertyAnnotations(designerXmlProperty={@DesignerXMLProperty(skip=true)}, property="height")})
@DocumentedComponent(value="It is used to construct columns of Table components.", documentationExample=true, icon="fa fa-columns")
public class Column
extends GroupingComponent<FormElement>
implements CompactLayout,
IMultipleIteratorRepeatable<Table>,
ICompilerAwareComponent,
IHasBoundableLabel {
    public static final String ATTR_LABEL = "label";
    public static final String ATTR_VALUE = "value";
    public static final String AUTOMATIC_LABEL_ID_SUFFIX = "_value_based_label";
    @JsonIgnore
    @XMLMetadataSubelementParent
    private Table table;
    private String label;
    @JsonIgnore
    @XMLProperty(value="label")
    @DesignerXMLProperty(commonUse=true, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT, priority=30, allowedTypes={String.class}, previewValueProvider=BindingExpressionDesignerPreviewProvider.class)
    @DocumentedComponentAttribute(boundable=true, value="Component label. Supports FHML - FH Markup Language.")
    private ModelBinding labelModelBinding;
    @JsonIgnore
    @XMLProperty
    @DocumentedComponentAttribute(value="Id of formatter which will format object to String. It must be consistend with value of pl.fhframework.formatter.FhFormatter annotation.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC, priority=90)
    private String formatter;
    @JsonIgnore
    @XMLProperty(value="value", skipCompiler=true)
    @DesignerXMLProperty(commonUse=true, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT, priority=20, previewValueProvider=BindingExpressionDesignerPreviewProvider.class)
    @DocumentedComponentAttribute(value="Represents text value for created component.")
    private ModelBinding value;
    private Integer rowspan;
    @JsonIgnore
    private Integer level;
    private boolean subColumnsExists;
    @XMLProperty
    private String iterationRef;
    @JsonIgnore
    private List<IRepeatableIteratorInfo> iteratorInfos;
    @JsonIgnore
    private TableCell prototype;
    @JsonIgnore
    private IMultipleIteratorComponentFactory<Table> interatorComponentFactory;
    private boolean sortable = false;
    @JsonIgnore
    @DocumentedComponentAttribute(value="Property name passed in the Pageable object to be interpreted in a data source (eg. DAO)")
    @XMLProperty
    @DesignerXMLProperty(commonUse=true)
    public String sortBy;
    @JsonIgnore
    private OutputLabel implicitOutputLabel;

    public Column(Form form) {
        super(form);
        this.prototype = new TableCell(form);
        this.prototype.setArtificial(true);
        this.prototype.setGroupingParentComponent((IGroupingComponent)this);
        this.interatorComponentFactory = new AdHocTableColumnComponentFactory(this);
    }

    public void init() {
        BindingResult bindingResult;
        if (this.isInitDone()) {
            return;
        }
        if (this.getWidth() != null && this.getWidth().endsWith("%")) {
            this.setWidth(this.getWidth().substring(0, this.getWidth().length() - 1));
        }
        this.subColumnsExists = false;
        if (this.getSubcomponents().stream().anyMatch(c -> c instanceof Column)) {
            this.subColumnsExists = true;
        }
        super.init();
        if (this.getGroupingParentComponent() instanceof Column) {
            this.setLevel(((Column)this.getGroupingParentComponent()).getLevel() + 1);
        } else {
            this.setLevel(1);
        }
        this.refreshImplicitOutputLabel();
        if (this.labelModelBinding != null && (bindingResult = this.labelModelBinding.getBindingResult()) != null) {
            this.label = (String)bindingResult.getValue();
        }
        this.prototype.init();
        this.prototype.doActionForEverySubcomponent(c -> c.init());
        this.sortable = !StringUtils.isNullOrEmpty((String)this.sortBy) && !this.isSubColumnsExists();
    }

    public void beforeCompilation() {
        this.refreshImplicitOutputLabel();
    }

    private void refreshImplicitOutputLabel() {
        if (this.implicitOutputLabel != null) {
            this.getPrototype().removeSubcomponent((Component)this.implicitOutputLabel);
        }
        if (this.value != null) {
            this.implicitOutputLabel = new OutputLabel(this.getForm());
            this.implicitOutputLabel.setValueBinding(this.value.clone((Component)this.implicitOutputLabel));
            if (this.getId() != null) {
                this.implicitOutputLabel.setId(this.getId() + AUTOMATIC_LABEL_ID_SUFFIX);
            }
            this.implicitOutputLabel.setArtificial(true);
            this.implicitOutputLabel.setWidth("md-12");
            this.getPrototype().getSubcomponents().add(this.implicitOutputLabel);
            this.implicitOutputLabel.setGroupingParentComponent((IGroupingComponent)this.getPrototype());
            this.implicitOutputLabel.setFormatter(this.formatter);
        }
    }

    public void addSubcomponent(FormElement formElement) {
        if (formElement instanceof Column) {
            if (!this.getPrototype().getSubcomponents().isEmpty() || this.getValue() != null) {
                throw new FhFormException("Column cannot have both form elements (or value) and subcolumns");
            }
            super.addSubcomponent((Component)formElement);
        } else {
            if (!this.getSubcolumns().isEmpty()) {
                throw new FhFormException("Column cannot have both form elements and subcolumns");
            }
            this.getPrototype().getSubcomponents().add(formElement);
        }
    }

    public ElementChanges updateView() {
        boolean sortable;
        String newLabelValue;
        BindingResult bindingResult;
        ElementChanges elementChanges = super.updateView();
        BindingResult bindingResult2 = bindingResult = this.labelModelBinding != null ? this.labelModelBinding.getBindingResult() : null;
        if (bindingResult != null && !this.areValuesTheSame(newLabelValue = this.convertBindingValueToString(bindingResult), this.label)) {
            this.refreshView();
            this.label = newLabelValue;
            elementChanges.addChange(ATTR_LABEL, (Object)this.label);
        }
        boolean bl = sortable = this.sortBy != null && !this.sortBy.isEmpty();
        if (!this.areValuesTheSame(this.sortable, sortable)) {
            this.refreshView();
            this.sortable = sortable;
            elementChanges.addChange("sortable", (Object)this.sortable);
        }
        return elementChanges;
    }

    public List<IRepeatableIteratorInfo> getIteratorInfos() {
        if (this.iteratorInfos == null || this.getForm().getViewMode() != Form.ViewMode.NORMAL) {
            ArrayList<IRepeatableIteratorInfo> iterators = new ArrayList<IRepeatableIteratorInfo>();
            for (IRepeatableIteratorInfo iRepeatableIteratorInfo : this.getTable().getAllIterators()) {
                iterators.add(iRepeatableIteratorInfo);
                if (this.iterationRef != null && !iRepeatableIteratorInfo.getName().equals(this.iterationRef)) continue;
                break;
            }
            this.iteratorInfos = iterators;
        }
        return this.iteratorInfos;
    }

    public List<Component> getRepeatedComponents() {
        return this.getPrototype().getSubcomponents();
    }

    public boolean isComponentFactorySupported() {
        return this.getSubcolumns().isEmpty();
    }

    public Table getGroupingComponentForNewComponents() {
        return this.getTable();
    }

    public Component getIteratorDefiningComponent() {
        return this.getTable();
    }

    @JsonIgnore
    public List<Column> getSubcolumns() {
        return this.getSubcomponents().stream().filter(subComponent -> subComponent instanceof Column).map(comp -> (Column)((Object)comp)).collect(Collectors.toList());
    }

    public Table getTable() {
        if (this.table == null) {
            this.table = ((Column)this.getGroupingParentComponent()).getTable();
        }
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
        this.iteratorInfos = null;
    }

    private TableCell createCell(LowLevelRowMetadata lowLevelRowMetadata) {
        TableCell tableCell = this.createEmptyCell();
        RowIteratorMetadata mainTableIteratorMetadata = lowLevelRowMetadata.getIteratorData().get(this.getTable().getIterator());
        tableCell.setRowIndex(mainTableIteratorMetadata.getIndex());
        int mainTableIteratorIndex = mainTableIteratorMetadata.getIndex();
        List cellComponents = this.interatorComponentFactory.createComponentsForIterators((IGroupingComponent)this.getTable(), (IRowNumberOffsetSupplier)this.getTable(), lowLevelRowMetadata.getIteratorsIndices());
        for (FormElement cellComponent : cellComponents) {
            this.getForm().addToElementIdToFormElement(cellComponent);
            this.getTable().getBindedSubcomponents().add(new IterationContext(Integer.valueOf(mainTableIteratorIndex), (Component)cellComponent));
            tableCell.getSubcomponents().add(cellComponent);
            cellComponent.setGroupingParentComponent((IGroupingComponent)tableCell);
        }
        return tableCell;
    }

    public List<FormElement> createTableCells(LowLevelRowMetadata lowLevelRowMetadata) {
        return this.createTableCells(this, lowLevelRowMetadata);
    }

    private List<FormElement> createTableCells(Column columnOrSubcolumn, LowLevelRowMetadata lowLevelRowMetadata) {
        ArrayList<FormElement> tableCells;
        block3: {
            List<Column> subColumns;
            block1: {
                block4: {
                    Form.ViewMode viewMode;
                    block2: {
                        tableCells = new ArrayList<FormElement>();
                        subColumns = columnOrSubcolumn.getSubcolumns();
                        viewMode = this.table.getForm().getViewMode();
                        if (subColumns.size() != 0) break block1;
                        if (viewMode != Form.ViewMode.NORMAL) break block2;
                        this.createTableCell(columnOrSubcolumn, lowLevelRowMetadata, this.getTable().getColumns()).ifPresent(tableCells::add);
                        break block3;
                    }
                    if (viewMode == Form.ViewMode.PREVIEW) break block4;
                    if (viewMode != Form.ViewMode.DESIGN) break block3;
                }
                this.createTableCellForDesigner(columnOrSubcolumn, lowLevelRowMetadata, this.getTable().getColumns()).ifPresent(tableCells::add);
                break block3;
            }
            for (Column subColumnElement : subColumns) {
                tableCells.addAll(this.createTableCells(subColumnElement, lowLevelRowMetadata));
            }
        }
        return tableCells;
    }

    private Optional<FormElement> createTableCell(Column column, LowLevelRowMetadata lowLevelRowMetadata, List<Column> columns) {
        column.setRowspan(this.getMaxColumnDepthForLevel(column.getLevel(), columns));
        RowIteratorMetadata rowIteratorMetadata = this.getRowIteratorMetadata(lowLevelRowMetadata, column.getIterationRef());
        TableCell tableCell = null;
        if (rowIteratorMetadata != null) {
            if (rowIteratorMetadata.isFirstOccurrence()) {
                tableCell = column.createCell(lowLevelRowMetadata);
                tableCell.setRowspan(rowIteratorMetadata.getRowSpan().get());
            }
        } else {
            tableCell = this.createEmptyCell();
            OutputLabel emptyLabel = this.createEmptyOutputLabel();
            emptyLabel.setGroupingParentComponent((IGroupingComponent)tableCell);
            tableCell.addSubcomponent((Component)emptyLabel);
        }
        if (tableCell != null) {
            tableCell.init();
            tableCell.setProcessComponentStateChange(false);
            tableCell.setGroupingParentComponent((IGroupingComponent)column);
        }
        return Optional.ofNullable(tableCell);
    }

    private Optional<FormElement> createTableCellForDesigner(Column column, LowLevelRowMetadata lowLevelRowMetadata, List<Column> columns) {
        TableCell tableCell = this.createEmptyCell();
        tableCell.setRowspan(1);
        tableCell.setProcessComponentStateChange(false);
        tableCell.setGroupingParentComponent((IGroupingComponent)this);
        tableCell.init();
        for (FormElement prototypeCellComponent : this.prototype.getSubcomponents()) {
            this.getForm().addToElementIdToFormElement(prototypeCellComponent);
            this.getTable().getBindedSubcomponents().add(new IterationContext(Integer.valueOf(0), (Component)prototypeCellComponent));
            prototypeCellComponent.setGroupingParentComponent((IGroupingComponent)tableCell);
            tableCell.getSubcomponents().add(prototypeCellComponent);
        }
        return Optional.of(tableCell);
    }

    private OutputLabel createEmptyOutputLabel() {
        OutputLabel emptyLabel = new OutputLabel(this.getForm());
        return emptyLabel;
    }

    private RowIteratorMetadata getRowIteratorMetadata(LowLevelRowMetadata lowLevelRowMetadata, String columnIterationRef) {
        if (columnIterationRef == null) {
            columnIterationRef = this.getTable().getIterator();
        }
        return lowLevelRowMetadata.getIteratorData().get(columnIterationRef);
    }

    private void collectSubColumns(int level, List<Column> columns, List<Column> collectedColumns) {
        columns.stream().filter(component -> component instanceof Column).forEach(column -> {
            if (column.getLevel() == level) {
                collectedColumns.add((Column)((Object)column));
            } else if (column.getLevel() < level) {
                this.collectSubColumns(level, column.getSubcomponents().stream().filter(subComponent -> subComponent instanceof Column).map(comp -> (Column)((Object)((Object)comp))).collect(Collectors.toList()), collectedColumns);
            }
        });
    }

    protected int getMaxColumnDepthForLevel(int level, List<Column> components) {
        int initialDepth = 0;
        int maxDepth = 1;
        LinkedList<Column> columns = new LinkedList<Column>();
        this.collectSubColumns(level, components, columns);
        for (Column column : columns) {
            maxDepth = Integer.max(maxDepth, this.getMaxColumnDepth(column, initialDepth));
        }
        return maxDepth;
    }

    private int getMaxColumnDepth(Column column, int initialDepth) {
        List<Column> subcolumns = column.getSubcolumns();
        ++initialDepth;
        if (subcolumns.size() == 0) {
            return initialDepth;
        }
        int maxDepth = initialDepth;
        for (Column subColumnElement : subcolumns) {
            maxDepth = Integer.max(this.getMaxColumnDepth(subColumnElement, initialDepth), maxDepth);
        }
        return maxDepth;
    }

    private TableCell createEmptyCell() {
        TableCell tableCell = new TableCell(this.getForm());
        tableCell.setHorizontalAlign(this.getHorizontalAlign());
        tableCell.setVerticalAlign(this.getVerticalAlign());
        return tableCell;
    }

    public String getLabel() {
        return this.label;
    }

    public ModelBinding getLabelModelBinding() {
        return this.labelModelBinding;
    }

    @JsonIgnore
    public void setLabelModelBinding(ModelBinding labelModelBinding) {
        this.labelModelBinding = labelModelBinding;
    }

    public String getFormatter() {
        return this.formatter;
    }

    @JsonIgnore
    public void setFormatter(String formatter) {
        this.formatter = formatter;
    }

    public ModelBinding getValue() {
        return this.value;
    }

    @JsonIgnore
    public void setValue(ModelBinding value) {
        this.value = value;
    }

    public Integer getRowspan() {
        return this.rowspan;
    }

    public void setRowspan(Integer rowspan) {
        this.rowspan = rowspan;
    }

    public Integer getLevel() {
        return this.level;
    }

    @JsonIgnore
    public void setLevel(Integer level) {
        this.level = level;
    }

    public boolean isSubColumnsExists() {
        return this.subColumnsExists;
    }

    public void setSubColumnsExists(boolean subColumnsExists) {
        this.subColumnsExists = subColumnsExists;
    }

    public String getIterationRef() {
        return this.iterationRef;
    }

    public void setIterationRef(String iterationRef) {
        this.iterationRef = iterationRef;
    }

    public TableCell getPrototype() {
        return this.prototype;
    }

    @JsonIgnore
    public void setPrototype(TableCell prototype) {
        this.prototype = prototype;
    }

    @JsonIgnore
    public void setInteratorComponentFactory(IMultipleIteratorComponentFactory<Table> interatorComponentFactory) {
        this.interatorComponentFactory = interatorComponentFactory;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    @JsonIgnore
    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }
}

