/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.springframework.beans.factory.annotation.Autowired;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.TemplateControl;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.binding.StaticBinding;
import pl.fhframework.core.forms.IHasBoundableLabel;
import pl.fhframework.core.i18n.MessageService;
import pl.fhframework.helper.AutowireHelper;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.Boundable;
import pl.fhframework.model.forms.Button;
import pl.fhframework.model.forms.CompactLayout;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.GroupingComponent;
import pl.fhframework.model.forms.IChangeableByClient;
import pl.fhframework.model.forms.IGroupingComponent;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.Styleable;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.designer.BindingExpressionDesignerPreviewProvider;
import pl.fhframework.model.forms.designer.IDesignerEventListener;
import pl.fhframework.model.forms.utils.WCAGService;

@TemplateControl(tagName="fh-font-size-buttons")
@Control(parents={PanelGroup.class, Tab.class, Row.class, Form.class, Repeater.class, Group.class}, invalidParents={Table.class}, canBeDesigned=true)
@DocumentedComponent(category=DocumentedComponent.Category.BUTTONS_AND_OTHER, documentationExample=true, value="PanelGroup component responsible for the grouping of buttons.", icon="fa fa-square")
public class FontSizeButtons
extends GroupingComponent<Component>
implements Boundable,
IChangeableByClient,
CompactLayout,
IDesignerEventListener,
IHasBoundableLabel {
    private static final String ATTR_ACTIVE_BUTTON = "activeButton";
    private static final String ATTR_CSS_CLASS2 = "cssClass2";
    private static final String ATTR_CSS_CLASS4 = "cssClass4";
    public static final String LABEL_ATTR = "label";
    private String label;
    @JsonIgnore
    @XMLProperty(value="label")
    @DesignerXMLProperty(commonUse=true, previewValueProvider=BindingExpressionDesignerPreviewProvider.class, priority=100, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT)
    @DocumentedComponentAttribute(boundable=true, value="Represents label for created component. Supports FHML - FH Markup Language.")
    private ModelBinding<String> labelModelBinding;
    @JsonIgnore
    @XMLProperty(value="activeButton")
    @DesignerXMLProperty(allowedTypes={Integer.class})
    @DocumentedComponentAttribute(boundable=true, value="Index of active Button. Default value of active button is 0 - high contrast is not activated.")
    private ModelBinding activeButtonBinding;
    @Autowired
    @JsonIgnore
    WCAGService WCAGService;
    @Autowired
    @JsonIgnore
    MessageService messageService;
    private int activeButton = 0;
    private String cssClass2 = "";
    private String cssClass4 = "";
    private boolean buttonAdded = false;

    public FontSizeButtons(Form form) {
        super(form);
        AutowireHelper.autowire((Object)((Object)this), (Object[])new Object[]{this.WCAGService});
        AutowireHelper.autowire((Object)((Object)this), (Object[])new Object[]{this.messageService});
        if (this.WCAGService != null) {
            Boolean isFontSize2 = this.WCAGService.isFontSize2();
            Boolean isFontSize4 = this.WCAGService.isFontSize4();
            this.activeButton = isFontSize2 != false ? 1 : (isFontSize4 != false ? 2 : 0);
        }
    }

    public void updateModel(ValueChange valueChange) {
        String newValue = valueChange.getMainValue();
        int newActiveButton = Integer.parseInt(newValue);
        Boolean isHighContrast = this.WCAGService.isHighContrast();
        if (newActiveButton != this.activeButton) {
            this.activeButton = newActiveButton;
            this.updateBindingForValue(newActiveButton, this.activeButtonBinding, this.activeButton);
            if (newActiveButton == 1) {
                this.WCAGService.setFontSize2();
            } else if (newActiveButton == 2) {
                this.WCAGService.setFontSize4();
            } else {
                this.WCAGService.setNormalFontSize();
            }
        }
        if (this.WCAGService != null) {
            Boolean isFontSize2 = this.WCAGService.isFontSize2();
            Boolean isFontSize4 = this.WCAGService.isFontSize4();
            this.activeButton = isFontSize2 != false ? 1 : (isFontSize4 != false ? 2 : 0);
        }
    }

    protected ElementChanges updateView() {
        if (this.getSubcomponents().size() == 0 && !this.buttonAdded && this.isInitDone()) {
            this.addSubcomponent((Component)this.createNormalButton());
            this.addSubcomponent((Component)this.createFontSize2Button());
            this.addSubcomponent((Component)this.createFontSize4Button());
            this.buttonAdded = true;
        }
        ElementChanges elementChanges = super.updateView();
        this.resolveBindingForLabel(elementChanges);
        Boolean isFontSize2 = this.WCAGService.isFontSize2();
        Boolean isFontSize4 = this.WCAGService.isFontSize4();
        if (isFontSize2.booleanValue()) {
            elementChanges.addChange(ATTR_ACTIVE_BUTTON, (Object)1);
        } else if (isFontSize4.booleanValue()) {
            elementChanges.addChange(ATTR_ACTIVE_BUTTON, (Object)2);
        } else {
            elementChanges.addChange(ATTR_ACTIVE_BUTTON, (Object)0);
        }
        if (!this.cssClass2.equals(this.WCAGService.getCssClassForSize2())) {
            this.cssClass2 = this.WCAGService.getCssClassForSize2();
            elementChanges.addChange(ATTR_CSS_CLASS2, (Object)this.cssClass2);
        }
        if (!this.cssClass4.equals(this.WCAGService.getCssClassForSize4())) {
            this.cssClass4 = this.WCAGService.getCssClassForSize4();
            elementChanges.addChange(ATTR_CSS_CLASS4, (Object)this.cssClass4);
        }
        return elementChanges;
    }

    private void resolveBindingForLabel(ElementChanges elementChanges) {
        if (this.labelModelBinding != null) {
            this.label = this.labelModelBinding.resolveValueAndAddChanges((FormElement)this, elementChanges, this.label, LABEL_ATTR);
        }
    }

    private Button createNormalButton() {
        String msg = this.messageService.getAllBundles().getMessage("pl.fhframework.model.forms.fontSizeButtons.normal");
        String msgAria = this.messageService.getAllBundles().getMessage("pl.fhframework.model.forms.fontSizeButtons.normal.ariaLabel");
        Button button = new Button(this.getForm());
        button.setLabelModelBinding((ModelBinding)new StaticBinding((Object)msg));
        button.setAriaLabelBinding((ModelBinding)new StaticBinding((Object)msgAria));
        button.setStyleModelBinding((ModelBinding)new StaticBinding((Object)Styleable.Style.DEFAULT.toValue()));
        button.setStyleClasses("border, mr-2, fh-font-size-btn-normal");
        button.setGroupingParentComponent((IGroupingComponent)this);
        button.init();
        return button;
    }

    private Button createFontSize2Button() {
        String msg = this.messageService.getAllBundles().getMessage("pl.fhframework.model.forms.fontSizeButtons.size2");
        String msgAria = this.messageService.getAllBundles().getMessage("pl.fhframework.model.forms.fontSizeButtons.size2.ariaLabel");
        Button button = new Button(this.getForm());
        button.setLabelModelBinding((ModelBinding)new StaticBinding((Object)msg));
        button.setAriaLabelBinding((ModelBinding)new StaticBinding((Object)msgAria));
        button.setStyleModelBinding((ModelBinding)new StaticBinding((Object)Styleable.Style.DEFAULT.toValue()));
        button.setStyleClasses("border, mr-2, fh-font-size-btn-2");
        button.setGroupingParentComponent((IGroupingComponent)this);
        button.init();
        return button;
    }

    private Button createFontSize4Button() {
        String msg = this.messageService.getAllBundles().getMessage("pl.fhframework.model.forms.fontSizeButtons.size4");
        String msgAria = this.messageService.getAllBundles().getMessage("pl.fhframework.model.forms.fontSizeButtons.size4.ariaLabel");
        Button button = new Button(this.getForm());
        button.setLabelModelBinding((ModelBinding)new StaticBinding((Object)msg));
        button.setAriaLabelBinding((ModelBinding)new StaticBinding((Object)msgAria));
        button.setStyleModelBinding((ModelBinding)new StaticBinding((Object)Styleable.Style.DEFAULT.toValue()));
        button.setStyleClasses("border, mr-2, fh-font-size-btn-4");
        button.setGroupingParentComponent((IGroupingComponent)this);
        button.init();
        return button;
    }

    public String getLabel() {
        return this.label;
    }

    public ModelBinding<String> getLabelModelBinding() {
        return this.labelModelBinding;
    }

    @JsonIgnore
    public void setLabelModelBinding(ModelBinding<String> labelModelBinding) {
        this.labelModelBinding = labelModelBinding;
    }

    public ModelBinding getActiveButtonBinding() {
        return this.activeButtonBinding;
    }

    @JsonIgnore
    public void setActiveButtonBinding(ModelBinding activeButtonBinding) {
        this.activeButtonBinding = activeButtonBinding;
    }

    public int getActiveButton() {
        return this.activeButton;
    }

    public String getCssClass2() {
        return this.cssClass2;
    }

    public String getCssClass4() {
        return this.cssClass4;
    }
}

