/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.TemplateControl;
import pl.fhframework.annotations.TwoWayBinding;
import pl.fhframework.annotations.XMLMetadataSubelement;
import pl.fhframework.annotations.XMLMetadataSubelements;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ActionBinding;
import pl.fhframework.binding.AdHocActionBinding;
import pl.fhframework.binding.AdHocIndexedModelBinding;
import pl.fhframework.binding.AdHocModelBinding;
import pl.fhframework.binding.CallbackActionBinding;
import pl.fhframework.binding.CompiledBinding;
import pl.fhframework.binding.IActionCallback;
import pl.fhframework.binding.IActionCallbackContext;
import pl.fhframework.binding.IRowNumberOffsetSupplier;
import pl.fhframework.binding.IndexedModelBinding;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.binding.StaticBinding;
import pl.fhframework.core.FhBindingException;
import pl.fhframework.core.FhException;
import pl.fhframework.core.forms.IHasBoundableLabel;
import pl.fhframework.core.logging.FhLogger;
import pl.fhframework.core.util.CollectionsUtils;
import pl.fhframework.events.IEventSource;
import pl.fhframework.events.IEventSourceContainer;
import pl.fhframework.helper.AutowireHelper;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.InMessageEventData;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.Boundable;
import pl.fhframework.model.forms.Button;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.CompactLayout;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Footer;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.GroupingComponent;
import pl.fhframework.model.forms.IChangeableByClient;
import pl.fhframework.model.forms.IEditableGroupingComponent;
import pl.fhframework.model.forms.IGroupingComponent;
import pl.fhframework.model.forms.ITabular;
import pl.fhframework.model.forms.Iterator;
import pl.fhframework.model.forms.OutputLabel;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.SpacerService;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.TableCell;
import pl.fhframework.model.forms.TableRow;
import pl.fhframework.model.forms.attribute.HorizontalAlign;
import pl.fhframework.model.forms.attribute.RowHeight;
import pl.fhframework.model.forms.attribute.TableGrid;
import pl.fhframework.model.forms.attribute.TableStripes;
import pl.fhframework.model.forms.csv.CsvService;
import pl.fhframework.model.forms.designer.BindingExpressionDesignerPreviewProvider;
import pl.fhframework.model.forms.designer.IDesignerEventListener;
import pl.fhframework.model.forms.table.LowLevelRowMetadata;
import pl.fhframework.model.forms.table.RowIteratorMetadata;

@TemplateControl(tagName="fh-table")
@Control(parents={Tab.class, GroupingComponent.class, Row.class, Form.class, Repeater.class}, invalidParents={Table.class}, canBeDesigned=true)
@DocumentedComponent(category=DocumentedComponent.Category.TABLE_AND_TREE, documentationExample=true, value="Table that allows to arrange data like text, images, links, other tables, etc. into rows and columns of cells.", icon="fa fa-table")
public class Table
extends Repeater
implements ITabular,
IChangeableByClient,
IEventSourceContainer,
IRowNumberOffsetSupplier,
Boundable,
CompactLayout,
IDesignerEventListener,
IHasBoundableLabel {
    protected static final String LABEL_ATTR = "label";
    protected static final String MULTISELECT_ATTR = "multiselect";
    protected static final String SELECTIONCHECKBOXES_ATTR = "selectionCheckboxes";
    private static final String SORT_BY_ATTRIBUTE = "sortBy";
    private static final String DIRECTION_ATTRIBUTE = "direction";
    @Autowired
    @JsonIgnore
    private CsvService csvService;
    protected boolean multiselect = false;
    @JsonIgnore
    @XMLProperty(value="multiselect")
    @DocumentedComponentAttribute(boundable=true, defaultValue="false", value="Determines if multiselect is enabled in table. If multiselect is set to true, selectedElement has to be set to Collection.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC, priority=10)
    private ModelBinding multiselectBinding;
    @XMLProperty
    @DocumentedComponentAttribute(defaultValue="false", value="Determines if horizontal scrolling is enabled in table.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE, priority=68)
    private boolean horizontalScrolling;
    private boolean selectionCheckboxes = false;
    @JsonIgnore
    @XMLProperty(value="selectionCheckboxes")
    @DocumentedComponentAttribute(boundable=true, value="Allows row selection using checkbox. Works only if multiselect is also enabled.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC, priority=5)
    private ModelBinding selectionCheckboxesBinding;
    @XMLProperty(defaultValue="true")
    @DocumentedComponentAttribute(defaultValue="true", value="Turns on/off table header checkbox to select/unselect all rows. Works only with 'selectionCheckboxes' option trun on.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC, priority=10)
    private boolean selectAllChceckbox = true;
    @JsonIgnore
    protected BiFunction<Object, Object, Boolean> compareFunction;
    @JsonIgnore
    @XMLProperty
    @DocumentedComponentAttribute(boundable=true, value="Additional function to compare with selected object when checking table selections.")
    @DesignerXMLProperty(allowedTypes={BiPredicate.class})
    private ModelBinding compareFunctionBinding;
    @XMLProperty
    @DocumentedComponentAttribute(value="Enables row selection feature.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC, priority=15)
    private boolean selectable;
    @XMLProperty
    @DocumentedComponentAttribute(value="Enables fixed headers when scrolling. Works only if table height is set.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC, priority=15)
    private boolean fixedHeader;
    @XMLProperty
    @DocumentedComponentAttribute(defaultValue="false", value="Enables export table data to CSV file feature.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC, priority=15)
    private boolean csvExport;
    @JsonIgnore
    @TwoWayBinding
    @XMLProperty(value="selected")
    @DocumentedComponentAttribute(boundable=true, value="Selected table row")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT, priority=11, bindingOnly=true)
    private ModelBinding selectedElementBinding;
    protected List<TableRow> tableRows = new ArrayList<TableRow>();
    @XMLMetadataSubelement
    protected Footer footer;
    @JsonIgnore
    protected List<LowLevelRowMetadata> tableRowMetadata = new ArrayList<LowLevelRowMetadata>();
    @JsonIgnore
    protected boolean tableRowMetadataChanged = false;
    protected int displayedRowsCount;
    @XMLProperty(defaultValue="-")
    @DocumentedComponentAttribute(value="If the table row is clicked that method will be executed")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    private ActionBinding onRowClick;
    @XMLProperty(defaultValue="-")
    @DocumentedComponentAttribute(value="If the table row is clicked twice that method will be executed")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    private ActionBinding onRowDoubleClick;
    protected int[] selectedRowsNumbers = new int[]{-1};
    @JsonIgnore
    protected Collection mainCollection;
    @JsonIgnore
    @XMLMetadataSubelements
    private List<Iterator> iterators = new LinkedList<Iterator>();
    @JsonIgnore
    private List<Iterator> allIterators;
    private Map<Integer, Integer> rowIndexMappings = null;
    @JsonIgnore
    private boolean rowIndexMappingsChanged = false;
    @XMLProperty
    @DocumentedComponentAttribute(defaultValue="false", value="Enables IE inline elements focus fix. Attribute is ignored in non-IE browsers. If this attribute is set to true, spanning columns doesn't work.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC, priority=79)
    protected boolean ieFocusFixEnabled;
    @XMLProperty
    @DocumentedComponentAttribute(value="Id of another which scroll should be synchronized with this table. This option works only if horizontalScrolling is enabled.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC, priority=79)
    protected String synchronizeScrolling;
    @XMLProperty
    @DocumentedComponentAttribute(value="Minimum of displayed rows.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE, priority=73)
    private Integer minRows;
    @XMLProperty
    @DocumentedComponentAttribute(defaultValue="normal", value="Sets row height on tables")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE, priority=72)
    private RowHeight rowHeight;
    @XMLProperty
    @DocumentedComponentAttribute(defaultValue="hide", value="Displays or hides grid on tables")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE, priority=71)
    private TableGrid tableGrid;
    @XMLProperty
    @DocumentedComponentAttribute(defaultValue="hide", value="Displays or hides gray stripes on table rows")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE, priority=70)
    private TableStripes tableStripes;
    @XMLMetadataSubelements
    private List<Column> columns = new ArrayList<Column>();
    protected static final String SELECTION_CHECKBOXES = "selectionCheckboxes";
    @JsonIgnore
    @XMLProperty
    @DesignerXMLProperty(allowedTypes={Map.class}, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE, priority=69)
    @DocumentedComponentAttribute(value="Map of colored rows in pattern like <BusinessObject, Color>", boundable=true)
    private ModelBinding<Map> rowStylesMap;
    private Map<Integer, String> rowStylesMapping = new HashMap<Integer, String>();
    @JsonIgnore
    private boolean rowStylesChanged = true;
    private String label = "";
    @JsonIgnore
    @XMLProperty(value="label")
    @DesignerXMLProperty(commonUse=true, previewValueProvider=BindingExpressionDesignerPreviewProvider.class, priority=100, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT)
    @DocumentedComponentAttribute(boundable=true, value="Represents label for created component. Supports FHML - Fh Markup Language.")
    private ModelBinding labelModelBinding;
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @XMLProperty
    @DocumentedComponentAttribute(value="Property name by default passed in the Pageable object to be interpreted in a data source (eg. DAO)")
    protected String defaultSortBy;
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @XMLProperty(defaultValue="true")
    @DocumentedComponentAttribute(value="If defaultSortBy is set this property decides if default order is ascending ", defaultValue="true")
    protected boolean defaultSortByAsc = true;
    private static final String ON_ROW_CLICK = "onRowClick";
    private static final String ON_ROW_DOUBLE_CLICK = "onRowDoubleClick";
    private static final String DISPLAYED_ROWS_COUNT = "displayedRowsCount";
    private static final String TABLE_ROWS = "tableRows";
    protected static final String SELECTED_ROW_NUMBER = "selectedRowNumber";
    private static final String SELECTED = "selected";
    protected static final String MULTISELECT = "multiselect";
    private static final String ROW_INDEX_MAPPINGS = "rowIndexMappings";
    private static final String MIN_ROWS = "minRows";
    private static final String ROW_STYLES_MAP = "rowStylesMap";
    private static final String ROW_STYLES_MAPPING = "rowStylesMapping";
    private String sortBy;
    private Sort.Direction direction;

    public Table(Form form) {
        super(form);
    }

    @Override
    public void init() {
        super.init();
        this.setProcessComponentStateChange(false);
        AutowireHelper.autowire((Object)((Object)this), (Object[])new Object[]{this.csvService});
        if (this.csvExport && !this.getForm().isDesignMode()) {
            if (this.footer == null) {
                this.footer = new Footer(this.getForm());
                this.footer.setInvisible(false);
                this.footer.setGroupingParentComponent((IGroupingComponent)this);
            }
            Button csvButton = new Button(this.getForm());
            csvButton.setWidth("md-1");
            csvButton.setLabelModelBinding((ModelBinding)new StaticBinding((Object)"[icon='fas fa-download'] CSV"));
            csvButton.setStyleModelBinding((ModelBinding)new StaticBinding((Object)"link"));
            csvButton.setHorizontalAlign(HorizontalAlign.RIGHT);
            csvButton.setInvisible(false);
            csvButton.setOnClick(() -> this.csvService.exportTableToCsv(this));
            csvButton.setGroupingParentComponent((IGroupingComponent)this.footer);
            this.footer.addSubcomponent((Component)csvButton);
        }
        this.setCompareFunction();
    }

    public int getRowNumberOffset() {
        return 0;
    }

    public void doActionForEverySubcomponent(Consumer<Component> action) {
        for (Column column : this.getColumns()) {
            action.accept((Component)column);
            column.doActionForEverySubcomponent(action);
        }
        for (TableRow row : this.tableRows) {
            for (FormElement cell : row.getTableCells()) {
                action.accept((Component)cell);
                if (!(cell instanceof IGroupingComponent)) continue;
                ((IGroupingComponent)cell).doActionForEverySubcomponent(action);
            }
        }
        if (this.footer != null) {
            this.footer.doActionForEverySubcomponent(action);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processComponents() {
        Form.ViewMode viewMode = this.getForm().getViewMode();
        if (viewMode == Form.ViewMode.NORMAL) {
            ArrayList<LowLevelRowMetadata> newTableRowMetadata = new ArrayList<LowLevelRowMetadata>();
            if (this.getCollection() != null) {
                Object value;
                BindingResult bindingResult;
                this.createIteratorStructureRows(newTableRowMetadata, this.getAllIterators().subList(1, this.getAllIterators().size()), new LinkedHashMap<String, RowIteratorMetadata>(), new int[0], this.getAllIterators().get(0));
                if (!(this.selectedElementBinding == null || this.isMultiselect() || this.selectedElementBinding instanceof CompiledBinding && ((CompiledBinding)this.selectedElementBinding).getTargetType() == List.class || (bindingResult = this.selectedElementBinding.getBindingResult()) == null || (value = bindingResult.getValue()) == null || this.getBindedObjectsList().contains(value))) {
                    this.updateBindingForValue(null, this.selectedElementBinding, this.selectedElementBinding.getBindingExpression());
                }
            }
            Map<?, String> rowStylesValues = this.extractRowStylesMapping(this.rowStylesMap);
            this.rowStylesMapping = new HashMap<Integer, String>();
            for (LowLevelRowMetadata lowLevelRowMetadata : newTableRowMetadata) {
                int mainIteratorIdx = lowLevelRowMetadata.getIteratorData().get(this.getIterator()).getIndex();
                if (rowStylesValues != null) {
                    String rowStyle = rowStylesValues.get(lowLevelRowMetadata.getIteratorData().get(this.getIterator()).getBusinessObject());
                    this.rowStylesMapping.put(mainIteratorIdx, rowStyle);
                }
                this.rowStylesChanged = true;
            }
            if (this.tableRowMetadata.equals(newTableRowMetadata)) {
                for (Column column : this.getColumns()) {
                    this.calculateRowspan(column);
                }
                return;
            }
            this.setProcessComponentStateChange(false);
            this.getBindedSubcomponents().clear();
            ArrayList<TableRow> newTableRows = new ArrayList<TableRow>();
            if (this.getCollection() != null) {
                for (LowLevelRowMetadata rowMetadata : newTableRowMetadata) {
                    newTableRows.add(new TableRow(this, rowMetadata));
                }
            }
            if (this.getAllIterators().size() > 1) {
                this.rowIndexMappings = new HashMap<Integer, Integer>();
                boolean bl = false;
                for (LowLevelRowMetadata rowMetadata : newTableRowMetadata) {
                    void var5_14;
                    int mainIteratorIdx = rowMetadata.getIteratorData().get(this.getIterator()).getIndex();
                    this.rowIndexMappings.put((int)(++var5_14), mainIteratorIdx);
                }
                this.rowIndexMappingsChanged = true;
            }
            this.tableRows = newTableRows;
            this.tableRowMetadata = newTableRowMetadata;
            this.tableRowMetadataChanged = true;
        } else if (viewMode != Form.ViewMode.NORMAL) {
            for (Column column : this.getColumns()) {
                this.calculateRowspan(column);
            }
            this.setProcessComponentStateChange(false);
            this.getBindedSubcomponents().clear();
            ArrayList<TableRow> newTableRows = new ArrayList<TableRow>();
            newTableRows.add(new TableRow(this, null));
            if (this.columns.stream().noneMatch(c -> c.getLabelModelBinding() != null)) {
                OutputLabel emptyLabel = new OutputLabel(this.getForm());
                emptyLabel.setBody("&nbsp;");
                emptyLabel.setId("EmptyLabel1");
                TableRow newTableRow = (TableRow)newTableRows.get(0);
                newTableRow.getTableCells().set(0, emptyLabel);
            }
            this.tableRows = newTableRows;
            this.tableRowMetadataChanged = true;
        }
    }

    private void calculateRowspan(Column column) {
        List subColumns = column.getSubcomponents().stream().filter(subComponent -> subComponent instanceof Column).collect(Collectors.toList());
        if (subColumns.size() == 0) {
            column.setRowspan(column.getMaxColumnDepthForLevel(column.getLevel(), this.getColumns()));
        } else {
            ArrayList sub = new ArrayList(subColumns);
            for (Column subColumn : sub) {
                this.calculateRowspan(subColumn);
            }
        }
    }

    protected Map<?, String> extractRowStylesMapping(ModelBinding<Map> rowStylesMap) {
        if (rowStylesMap != null) {
            Object bindingResultObj;
            BindingResult bindingResult = rowStylesMap.getBindingResult();
            Object object = bindingResultObj = bindingResult != null ? bindingResult.getValue() : null;
            if (bindingResultObj != null) {
                if (bindingResultObj instanceof Map) {
                    return (Map)bindingResultObj;
                }
                throw new FhException("Not instance of Map: " + rowStylesMap);
            }
            return null;
        }
        return null;
    }

    protected Collection extractCollection(IndexedModelBinding collectionBinding, int[] parentIteratorIndices, boolean isMainLevel) {
        Object bindingResultObj = collectionBinding.getValue(parentIteratorIndices);
        if (bindingResultObj != null) {
            if (bindingResultObj instanceof Collection) {
                Collection collectionObj = (Collection)bindingResultObj;
                if (isMainLevel) {
                    this.mainCollection = collectionObj;
                }
                return collectionObj;
            }
            throw new FhBindingException("Not instance of Collection: " + collectionBinding.getBindingExpression());
        }
        return null;
    }

    protected void createIteratorStructureRows(List<LowLevelRowMetadata> alreadyAddedRows, List<Iterator> childenIterators, Map<String, RowIteratorMetadata> parentContext, int[] parentIndices, Iterator myIterator) {
        boolean isMainLevel = parentContext.isEmpty();
        Collection myCollection = this.extractCollection(myIterator.getCollection(), parentIndices, isMainLevel);
        if (myCollection == null || myCollection.isEmpty()) {
            if (FhLogger.isTraceEnabled(Table.class)) {
                FhLogger.trace(((Object)((Object)this)).getClass(), logger -> logger.log("nodata for iterator: {}", new Object[]{myIterator.getId()}));
            }
            if (!isMainLevel) {
                this.addLowLevelRow(alreadyAddedRows, parentContext, null, null);
            }
            return;
        }
        int rowIndex = 0;
        int[] myIndices = Arrays.copyOf(parentIndices, parentIndices.length + 1);
        for (Object myBusinessObject : myCollection) {
            myIndices[myIndices.length - 1] = rowIndex;
            if (rowIndex > 0) {
                for (RowIteratorMetadata parentIteratorData : parentContext.values()) {
                    parentIteratorData.setFirstOccurrence(false);
                }
            }
            RowIteratorMetadata myMetadata = new RowIteratorMetadata();
            myMetadata.setIndex(rowIndex);
            myMetadata.setFirstOccurrence(true);
            myMetadata.setBusinessObject(myBusinessObject);
            myMetadata.setRowSpan(new AtomicInteger());
            int rowsBeforeAddingChildren = alreadyAddedRows.size();
            if (childenIterators.isEmpty()) {
                this.addLowLevelRow(alreadyAddedRows, parentContext, myIterator.getId(), myMetadata);
            } else {
                parentContext.put(myIterator.getId(), myMetadata);
                Iterator childIterator = childenIterators.get(0);
                this.createIteratorStructureRows(alreadyAddedRows, childenIterators.subList(1, childenIterators.size()), parentContext, myIndices, childIterator);
                parentContext.remove(myIterator.getId());
            }
            myMetadata.getRowSpan().set(alreadyAddedRows.size() - rowsBeforeAddingChildren);
            ++rowIndex;
        }
    }

    protected void addLowLevelRow(List<LowLevelRowMetadata> alreadyAddedRows, Map<String, RowIteratorMetadata> context, String iterator, RowIteratorMetadata iteratorMetadata) {
        LowLevelRowMetadata row = new LowLevelRowMetadata();
        context.forEach((iter, data) -> {
            RowIteratorMetadata dataCopy = data.getCopy();
            row.getIteratorData().put((String)iter, dataCopy);
        });
        if (iterator != null) {
            row.getIteratorData().put(iterator, iteratorMetadata);
        }
        row.setIteratorsIndices(CollectionsUtils.toArray(row.getIteratorData().values().stream().map(data -> data.getIndex()).collect(Collectors.toList())));
        alreadyAddedRows.add(row);
    }

    @Override
    public void refreshView(Set<ElementChanges> changeSet) {
        ElementChanges elementChanges = this.updateView();
        IGroupingComponent parent = this.getGroupingParentComponent();
        boolean stopProcessingUpdateView = this.isStopProcessingUpdateView();
        if (this.multiselectBinding != null) {
            this.multiselect = this.multiselectBinding.resolveValueAndAddChanges((FormElement)this, elementChanges, this.multiselect, "multiselect");
        }
        if (this.selectionCheckboxesBinding != null) {
            this.selectionCheckboxes = this.selectionCheckboxesBinding.resolveValueAndAddChanges((FormElement)this, elementChanges, this.selectionCheckboxes, "selectionCheckboxes");
        }
        while (parent != null) {
            stopProcessingUpdateView |= ((FormElement)parent).isStopProcessingUpdateView();
            parent = ((FormElement)parent).getGroupingParentComponent();
        }
        if (!stopProcessingUpdateView && elementChanges.containsAnyChanges()) {
            changeSet.add(elementChanges);
        }
    }

    @Override
    public ElementChanges updateView() {
        ElementChanges elementChange = super.updateView();
        if (this.tableRows != null) {
            if (this.tableRowMetadataChanged) {
                this.displayedRowsCount = this.tableRows.size();
                elementChange.addChange(DISPLAYED_ROWS_COUNT, (Object)this.displayedRowsCount);
                elementChange.addChange(TABLE_ROWS, this.tableRows);
                this.tableRowMetadataChanged = false;
            }
            if (this.rowIndexMappingsChanged) {
                elementChange.addChange(ROW_INDEX_MAPPINGS, this.rowIndexMappings);
                this.rowIndexMappingsChanged = false;
            }
            if (this.rowStylesChanged) {
                elementChange.addChange(ROW_STYLES_MAPPING, this.rowStylesMapping);
                this.rowStylesChanged = false;
            }
            this.selectedRowsNumbers = this.getSelectedRowNumberBasedOnBinding(this.mainCollection, this.multiselect);
            elementChange.addChange(SELECTED_ROW_NUMBER, (Object)this.selectedRowsNumbers);
            this.refreshView();
        }
        this.processLabelBinding(elementChange);
        IntStream.range(0, this.columns.size()).forEach(i -> {
            String columnStyles = this.columns.get(i).getStyleClasses();
            if (columnStyles != null) {
                for (TableRow row : this.tableRows) {
                    row.getTableCells().get(i).setStyleClasses(columnStyles);
                }
            }
        });
        return elementChange;
    }

    public ActionBinding getRowBinding(ActionBinding binding, Component clonedComponent, Map<String, String> iteratorReplacements) {
        if (binding == null) {
            return binding;
        }
        return new AdHocActionBinding(this.getRowBinding(binding.getActionBindingExpression(), iteratorReplacements, false), this.getForm(), clonedComponent);
    }

    public ModelBinding getRowBinding(ModelBinding binding, Component clonedComponent, Map<String, String> iteratorReplacements) {
        if (binding == null || binding instanceof StaticBinding) {
            return binding;
        }
        return new AdHocModelBinding(this.getForm(), clonedComponent, this.getRowBinding(binding.getBindingExpression(), iteratorReplacements, true));
    }

    String getRowBinding(String binding, Map<String, String> iteratorReplacements) {
        return this.getRowBinding(binding, iteratorReplacements, true);
    }

    String getRowBinding(String binding, Map<String, String> iteratorReplacements, boolean useCurlyBrackets) {
        return AdHocIndexedModelBinding.replaceIteratorsInBinding((String)binding, iteratorReplacements, (boolean)useCurlyBrackets);
    }

    String replaceBinding(String binding, String key, String replacement) {
        return binding.replace(key, replacement);
    }

    protected int[] getSelectedRowNumberBasedOnBinding(Collection collection, boolean multiselect) {
        Object[] tempCollection;
        BindingResult bindingResult;
        Object newSelectedValue = null;
        if (this.selectedElementBinding != null && (bindingResult = this.selectedElementBinding.getBindingResult()) != null) {
            newSelectedValue = bindingResult.getValue();
        }
        if (newSelectedValue == null || collection == null) {
            return new int[]{-1};
        }
        if (multiselect || this.selectedElementBinding instanceof CompiledBinding && ((CompiledBinding)this.selectedElementBinding).getTargetType() == List.class) {
            if (newSelectedValue instanceof Collection) {
                tempCollection = collection.toArray();
                LinkedList newSelectedElementsList = new LinkedList((Collection)newSelectedValue);
                int[] newSelectedRows = new int[newSelectedElementsList.size()];
                block0: for (int i = 0; i < ((Collection)newSelectedValue).size(); ++i) {
                    int index = -1;
                    newSelectedRows[i] = -1;
                    Object obj = newSelectedElementsList.get(i);
                    for (int c = 0; c < collection.size(); ++c) {
                        if (!this.compareFunction.apply(tempCollection[c], obj).booleanValue()) continue;
                        newSelectedRows[i] = c;
                        continue block0;
                    }
                }
                return newSelectedRows;
            }
            return new int[]{-1};
        }
        tempCollection = collection.toArray();
        int[] newSelectedRows = new int[]{-1};
        Object obj = newSelectedValue;
        for (int c = 0; c < collection.size(); ++c) {
            if (!this.compareFunction.apply(tempCollection[c], obj).booleanValue()) continue;
            newSelectedRows[0] = c;
            break;
        }
        return newSelectedRows;
    }

    public void updateModel(ValueChange valueChange) {
        String newTextValue;
        if (this.selectedElementBinding != null && valueChange.hasMainValueChanged() && (newTextValue = valueChange.getMainValue()) != null) {
            Object newSelectedElement;
            newTextValue = newTextValue.substring(1, newTextValue.length() - 1);
            this.selectedRowsNumbers = Arrays.stream(newTextValue.split(",")).map(String::trim).mapToInt(Integer::parseInt).toArray();
            if (this.multiselect || this.selectedElementBinding instanceof CompiledBinding && ((CompiledBinding)this.selectedElementBinding).getTargetType() == List.class) {
                newSelectedElement = this.getSelectedElementsBasedOnRowsNumbers(this.getBindedObjectsList(), this.selectedRowsNumbers);
            } else {
                this.selectedRowsNumbers[0] = Integer.parseInt(newTextValue);
                newSelectedElement = this.selectedRowsNumbers[0] > -1 && this.getBindedObjectsList().size() > this.selectedRowsNumbers[0] ? CollectionsUtils.get(this.getBindedObjectsList(), (int)this.selectedRowsNumbers[0]) : null;
            }
            this.updateBindingForValue(newSelectedElement, this.selectedElementBinding, this.selectedElementBinding.getBindingExpression(), Optional.empty());
        }
        if (valueChange.hasAttributeChanged(SORT_BY_ATTRIBUTE) || valueChange.hasAttributeChanged(DIRECTION_ATTRIBUTE)) {
            this.sortBy = valueChange.getStringAttribute(SORT_BY_ATTRIBUTE);
            String directionString = valueChange.getStringAttribute(DIRECTION_ATTRIBUTE);
            Column column = this.getSortingColumn(this.sortBy, this.getColumns());
            this.direction = directionString != null ? Sort.Direction.valueOf((String)directionString) : null;
            this.sortByFieldName(this.mainCollection, column.sortBy, this.direction, column);
            this.processComponents();
        }
    }

    protected List<Object> getSelectedElementsBasedOnRowsNumbers(Collection<Object> bindedObjectsList, int[] selectedRowsNumbers) {
        LinkedList<Object> elements = new LinkedList<Object>();
        Arrays.stream(selectedRowsNumbers).filter(i -> i > -1 && bindedObjectsList.size() > i).forEach(i -> elements.add(CollectionsUtils.get((Collection)bindedObjectsList, (int)i)));
        return elements;
    }

    protected Collection<Object> getBindedObjectsList() {
        if (this.getCollection() == null) {
            throw new FhBindingException("Table '" + this.getId() + "' has not binding for 'collection'!");
        }
        Form form = this.getForm();
        Object list = this.getCollection().getBindingResult().getValue();
        if (list != null) {
            if (list instanceof Collection) {
                return (Collection)list;
            }
            throw new FhBindingException("Binded for table '" + this.getId() + "' class object '" + list.getClass().getSimpleName() + "' is not a Collection!");
        }
        return Collections.emptyList();
    }

    public Optional<ActionBinding> getEventHandler(InMessageEventData eventData) {
        if (eventData.getEventType().equals(ON_ROW_CLICK)) {
            return Optional.ofNullable(this.onRowClick);
        }
        if (eventData.getEventType().equals(ON_ROW_DOUBLE_CLICK)) {
            return Optional.ofNullable(this.onRowDoubleClick);
        }
        return super.getEventHandler(eventData);
    }

    public IEventSource getEventSource(String elementId) {
        int startingPointOfElement = elementId.indexOf("[");
        int lastPointOfElement = elementId.indexOf("]", startingPointOfElement);
        String indexOfElementAsString = elementId.substring(startingPointOfElement + 1, lastPointOfElement);
        int indexOfElement = Integer.parseInt(indexOfElementAsString);
        return this.getTableRows().get(indexOfElement).getEventSource(elementId);
    }

    @Override
    @JsonIgnore
    public List<Component> getSubcomponents() {
        return super.getSubcomponents();
    }

    public List<Iterator> getAllIterators() {
        if (this.allIterators == null || this.getForm().isDesignMode()) {
            this.allIterators = new ArrayList<Iterator>();
            if (this.getIterator() != null) {
                this.allIterators.add(new Iterator(this.getForm(), this.getIterator(), this.getCollection()));
            }
            this.allIterators.addAll(this.iterators);
        }
        return this.allIterators;
    }

    public boolean isComponentFactorySupported() {
        return false;
    }

    public void doActionForEverySubcomponentInlcudingRepeated(Consumer<Component> action) {
        super.doActionForEverySubcomponentInlcudingRepeated(action);
        for (Column column : this.getColumns()) {
            action.accept((Component)column);
            column.doActionForEverySubcomponentInlcudingRepeated(action);
            column.doActionForEveryRepeatedSubcomponent(action);
        }
    }

    public IGroupingComponent getGroupingComponent(Component formElement) {
        if (this.getColumns().contains(formElement)) {
            return this;
        }
        for (Column column : this.getColumns()) {
            IGroupingComponent groupingColumn = column.getGroupingComponent(formElement);
            if (groupingColumn != null) {
                return groupingColumn;
            }
            if (column.getPrototype().getSubcomponents().size() <= 0) continue;
            List<FormElement> subcomponents = column.getPrototype().getSubcomponents();
            for (FormElement cell : subcomponents) {
                if (!cell.equals(formElement)) continue;
                return (IGroupingComponent)cell;
            }
        }
        return super.getGroupingComponent(formElement);
    }

    @Override
    public void removeSubcomponent(Component removedFormElement) {
        if (this.getColumns().contains(removedFormElement)) {
            this.getColumns().remove((Object)((Column)removedFormElement));
        } else {
            super.removeSubcomponent(removedFormElement);
        }
    }

    public void onDesignerAddDefaultSubcomponent(SpacerService spacerService) {
        Column column = this.createExampleColumn(this.getColumns().size() + 1);
        if (!this.getColumns().isEmpty()) {
            column.setWidth(this.getColumns().get(this.getColumns().size() - 1).getWidth());
        }
        this.getColumns().add(column);
    }

    public void onDesignerBeforeAdding(IGroupingComponent<?> parent, SpacerService spacerService) {
        this.setMinRows(1);
        this.getColumns().add(this.createExampleColumn(1));
        this.getColumns().add(this.createExampleColumn(2));
        this.getColumns().add(this.createExampleColumn(3));
    }

    public void setOnRowClick(ActionBinding onRowClick) {
        this.onRowClick = onRowClick;
    }

    public IActionCallbackContext setOnRowClick(IActionCallback onRowClick) {
        return CallbackActionBinding.createAndSet((IActionCallback)onRowClick, this::setOnRowClick);
    }

    public void setOnRowDoubleClick(ActionBinding onRowDoubleClick) {
        this.onRowDoubleClick = onRowDoubleClick;
    }

    public IActionCallbackContext setOnRowDoubleClick(IActionCallback onRowDoubleClick) {
        return CallbackActionBinding.createAndSet((IActionCallback)onRowDoubleClick, this::setOnRowDoubleClick);
    }

    public void move(Component columnComponent, int vector) {
        this.maybeMoveColumn(this.getColumns(), columnComponent, vector);
    }

    public boolean isSelectionCheckboxes() {
        return this.multiselect && this.selectionCheckboxes;
    }

    private void maybeMoveColumn(List<Column> subcolumns, Component columnComponent, int vector) {
        IEditableGroupingComponent.move(subcolumns, (Object)((Object)((Column)columnComponent)), (int)vector);
        for (Column column : subcolumns) {
            this.maybeMoveColumn(column.getSubcolumns(), columnComponent, vector);
        }
    }

    protected boolean processLabelBinding(ElementChanges elementChanges) {
        String newLabelValue;
        BindingResult labelBidingResult = this.labelModelBinding != null ? this.labelModelBinding.getBindingResult() : null;
        String string = newLabelValue = labelBidingResult == null ? null : this.convertBindingValueToString(labelBidingResult);
        if (!this.areValuesTheSame(newLabelValue, this.label)) {
            this.label = newLabelValue;
            elementChanges.addChange(LABEL_ATTR, (Object)this.label);
            return true;
        }
        return false;
    }

    protected Column createExampleColumn(int nameSuffix) {
        Column column = new Column(this.getForm());
        column.setLabelModelBinding((ModelBinding)new StaticBinding((Object)("Column " + nameSuffix)));
        column.setTable(this);
        column.setGroupingParentComponent((IGroupingComponent)this);
        column.init();
        return column;
    }

    protected void setCompareFunction() {
        BindingResult filterBindingResult = this.getCompareFunctionBinding() != null ? this.getCompareFunctionBinding().getBindingResult() : null;
        this.compareFunction = filterBindingResult != null ? (BiFunction<Object, Object, Object>)filterBindingResult.getValue() : (value1, value2) -> Objects.equals(value1, value2);
    }

    public <T> void sortByFieldName(Collection<T> collection, String fieldName, Sort.Direction direction, Column column) {
        if (collection == null || collection.isEmpty() || fieldName == null || fieldName.isEmpty()) {
            return;
        }
        if (!(collection instanceof List)) {
            return;
        }
        List list = (List)collection;
        Object valCheck = null;
        HashMap staticMappingForSorting = new HashMap();
        try {
            valCheck = Table.getNestedFieldValue(list.indexOf(0), fieldName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (valCheck == null) {
            int index = this.columns.indexOf((Object)column);
            this.tableRows.forEach(tableRow -> {
                int rowIndex = this.tableRows.indexOf(tableRow);
                TableCell tableCell = (TableCell)tableRow.getTableCells().get(index);
                FormElement element = tableCell.getSubcomponents().get(0);
                String outputLabelValue = "";
                if (element instanceof OutputLabel) {
                    outputLabelValue = ((OutputLabel)element).getValue();
                }
                staticMappingForSorting.put(list.get(rowIndex), outputLabelValue);
            });
        }
        boolean ascending = direction.name().equalsIgnoreCase("ASC");
        Object finalValCheck = valCheck;
        Comparator comparator = (o1, o2) -> {
            try {
                Object val2;
                Object val1;
                if (finalValCheck != null) {
                    val1 = Table.getNestedFieldValue(o1, fieldName);
                    val2 = Table.getNestedFieldValue(o2, fieldName);
                } else {
                    val1 = staticMappingForSorting.get(o1);
                    val2 = staticMappingForSorting.get(o2);
                    if (fieldName == "stringasnumeric") {
                        String num = ((String)val1).replaceAll("\\D+", "");
                        val1 = num.isEmpty() ? 0L : Long.parseLong(num);
                        String num2 = ((String)val2).replaceAll("\\D+", "");
                        val2 = num2.isEmpty() ? 0L : Long.parseLong(num2);
                    }
                }
                if (val1 instanceof Integer && val2 instanceof Integer) {
                    return ascending ? Integer.compare((Integer)val1, (Integer)val2) : Integer.compare((Integer)val2, (Integer)val1);
                }
                if (val1 instanceof Double && val2 instanceof Double) {
                    return ascending ? Double.compare((Double)val1, (Double)val2) : Double.compare((Double)val2, (Double)val1);
                }
                if (val1 instanceof Long && val2 instanceof Long) {
                    return ascending ? Long.compare((Long)val1, (Long)val2) : Long.compare((Long)val2, (Long)val1);
                }
                if (val1 instanceof Float && val2 instanceof Float) {
                    return ascending ? Float.compare(((Float)val1).floatValue(), ((Float)val2).floatValue()) : Float.compare(((Float)val2).floatValue(), ((Float)val1).floatValue());
                }
                if (val1 instanceof Boolean && val2 instanceof Boolean) {
                    return ascending ? Boolean.compare((Boolean)val1, (Boolean)val2) : Boolean.compare((Boolean)val2, (Boolean)val1);
                }
                if (val1 instanceof Character && val2 instanceof Character) {
                    return ascending ? Character.compare(((Character)val1).charValue(), ((Character)val2).charValue()) : Character.compare(((Character)val2).charValue(), ((Character)val1).charValue());
                }
                if (val1 instanceof Short && val2 instanceof Short) {
                    return ascending ? Short.compare((Short)val1, (Short)val2) : Short.compare((Short)val2, (Short)val1);
                }
                if (val1 instanceof Byte && val2 instanceof Byte) {
                    return ascending ? Byte.compare((Byte)val1, (Byte)val2) : Byte.compare((Byte)val2, (Byte)val1);
                }
                if (val1 instanceof LocalDate && val2 instanceof LocalDate) {
                    return ascending ? ((LocalDate)val1).compareTo((LocalDate)val2) : ((LocalDate)val2).compareTo((LocalDate)val1);
                }
                if (val1 instanceof LocalDateTime && val2 instanceof LocalDateTime) {
                    return ascending ? ((LocalDateTime)val1).compareTo((LocalDateTime)val2) : ((LocalDateTime)val2).compareTo((LocalDateTime)val1);
                }
                if (val1 instanceof Comparable && val2 instanceof Comparable) {
                    return ascending ? ((Comparable)val1).compareTo(val2) : ((Comparable)val2).compareTo(val1);
                }
                return ascending ? val1.toString().compareTo(val2.toString()) : val2.toString().compareTo(val1.toString());
            }
            catch (Exception e) {
                throw new RuntimeException("B\u0142\u0105d przy sortowaniu po polu: " + fieldName, e);
            }
        };
        Collections.sort(list, comparator);
    }

    private static Object getNestedFieldValue(Object obj, String fieldPath) throws Exception {
        String[] fields = fieldPath.split("\\.");
        Object currentObj = obj;
        for (String fieldName : fields) {
            if (currentObj == null) {
                return null;
            }
            Field field = Table.getFieldRecursive(currentObj.getClass(), fieldName);
            field.setAccessible(true);
            currentObj = field.get(currentObj);
        }
        return currentObj;
    }

    private static Field getFieldRecursive(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        while (clazz != null) {
            try {
                return clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
        }
        throw new NoSuchFieldException("Nie znaleziono pola: " + fieldName);
    }

    protected Column getSortingColumn(String sortBy, List<? extends Component> components) {
        for (Component component : components) {
            Column nestedColumn;
            if (!(component instanceof Column)) continue;
            Column column = (Column)component;
            if (sortBy.equals(column.getId())) {
                return column;
            }
            if (column.getSubcomponents() == null || (nestedColumn = this.getSortingColumn(sortBy, column.getSubcomponents())) == null) continue;
            return nestedColumn;
        }
        return null;
    }

    public boolean isMultiselect() {
        return this.multiselect;
    }

    public ModelBinding getMultiselectBinding() {
        return this.multiselectBinding;
    }

    @JsonIgnore
    public void setMultiselectBinding(ModelBinding multiselectBinding) {
        this.multiselectBinding = multiselectBinding;
    }

    public boolean isHorizontalScrolling() {
        return this.horizontalScrolling;
    }

    public void setHorizontalScrolling(boolean horizontalScrolling) {
        this.horizontalScrolling = horizontalScrolling;
    }

    public ModelBinding getSelectionCheckboxesBinding() {
        return this.selectionCheckboxesBinding;
    }

    @JsonIgnore
    public void setSelectionCheckboxesBinding(ModelBinding selectionCheckboxesBinding) {
        this.selectionCheckboxesBinding = selectionCheckboxesBinding;
    }

    public boolean isSelectAllChceckbox() {
        return this.selectAllChceckbox;
    }

    public void setSelectAllChceckbox(boolean selectAllChceckbox) {
        this.selectAllChceckbox = selectAllChceckbox;
    }

    public ModelBinding getCompareFunctionBinding() {
        return this.compareFunctionBinding;
    }

    @JsonIgnore
    public void setCompareFunctionBinding(ModelBinding compareFunctionBinding) {
        this.compareFunctionBinding = compareFunctionBinding;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public boolean isFixedHeader() {
        return this.fixedHeader;
    }

    public void setFixedHeader(boolean fixedHeader) {
        this.fixedHeader = fixedHeader;
    }

    public boolean isCsvExport() {
        return this.csvExport;
    }

    public void setCsvExport(boolean csvExport) {
        this.csvExport = csvExport;
    }

    public ModelBinding getSelectedElementBinding() {
        return this.selectedElementBinding;
    }

    @JsonIgnore
    public void setSelectedElementBinding(ModelBinding selectedElementBinding) {
        this.selectedElementBinding = selectedElementBinding;
    }

    public List<TableRow> getTableRows() {
        return this.tableRows;
    }

    public Footer getFooter() {
        return this.footer;
    }

    public void setFooter(Footer footer) {
        this.footer = footer;
    }

    public int getDisplayedRowsCount() {
        return this.displayedRowsCount;
    }

    public void setDisplayedRowsCount(int displayedRowsCount) {
        this.displayedRowsCount = displayedRowsCount;
    }

    public ActionBinding getOnRowClick() {
        return this.onRowClick;
    }

    public ActionBinding getOnRowDoubleClick() {
        return this.onRowDoubleClick;
    }

    public int[] getSelectedRowsNumbers() {
        return this.selectedRowsNumbers;
    }

    public List<Iterator> getIterators() {
        return this.iterators;
    }

    @JsonIgnore
    public void setIterators(List<Iterator> iterators) {
        this.iterators = iterators;
    }

    public Map<Integer, Integer> getRowIndexMappings() {
        return this.rowIndexMappings;
    }

    public void setRowIndexMappings(Map<Integer, Integer> rowIndexMappings) {
        this.rowIndexMappings = rowIndexMappings;
    }

    public boolean isIeFocusFixEnabled() {
        return this.ieFocusFixEnabled;
    }

    public void setIeFocusFixEnabled(boolean ieFocusFixEnabled) {
        this.ieFocusFixEnabled = ieFocusFixEnabled;
    }

    public String getSynchronizeScrolling() {
        return this.synchronizeScrolling;
    }

    public void setSynchronizeScrolling(String synchronizeScrolling) {
        this.synchronizeScrolling = synchronizeScrolling;
    }

    public Integer getMinRows() {
        return this.minRows;
    }

    public void setMinRows(Integer minRows) {
        this.minRows = minRows;
    }

    public RowHeight getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(RowHeight rowHeight) {
        this.rowHeight = rowHeight;
    }

    public TableGrid getTableGrid() {
        return this.tableGrid;
    }

    public void setTableGrid(TableGrid tableGrid) {
        this.tableGrid = tableGrid;
    }

    public TableStripes getTableStripes() {
        return this.tableStripes;
    }

    public void setTableStripes(TableStripes tableStripes) {
        this.tableStripes = tableStripes;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public ModelBinding<Map> getRowStylesMap() {
        return this.rowStylesMap;
    }

    @JsonIgnore
    public void setRowStylesMap(ModelBinding<Map> rowStylesMap) {
        this.rowStylesMap = rowStylesMap;
    }

    public Map<Integer, String> getRowStylesMapping() {
        return this.rowStylesMapping;
    }

    public String getLabel() {
        return this.label;
    }

    public ModelBinding getLabelModelBinding() {
        return this.labelModelBinding;
    }

    @JsonIgnore
    public void setLabelModelBinding(ModelBinding labelModelBinding) {
        this.labelModelBinding = labelModelBinding;
    }

    public String getDefaultSortBy() {
        return this.defaultSortBy;
    }

    public void setDefaultSortBy(String defaultSortBy) {
        this.defaultSortBy = defaultSortBy;
    }

    public boolean isDefaultSortByAsc() {
        return this.defaultSortByAsc;
    }

    public void setDefaultSortByAsc(boolean defaultSortByAsc) {
        this.defaultSortByAsc = defaultSortByAsc;
    }
}

