/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms.attributes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import pl.fhframework.BindingResult;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.attributes.AbstractStringAttribute;
import pl.fhframework.model.forms.attributes.BoundableAttribute;

public abstract class BoundableStringAttribute
extends AbstractStringAttribute
implements BoundableAttribute {
    private String value;
    @JsonIgnore
    private ModelBinding modelBinding;

    public BoundableStringAttribute(Form form, Component component, ModelBinding<String> modelBinding) {
        super(form, component, modelBinding);
        this.value = modelBinding != null ? this.convertBindingToString(modelBinding.getBindingResult()) : this.getDefaultValue();
    }

    @Override
    @JsonIgnore
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    @JsonIgnore
    public abstract String getXmlValue();

    @Override
    public String getDefaultValue() {
        return null;
    }

    @Override
    public ElementChanges updateView(Component component, ElementChanges elementChanges) {
        String newValue;
        BindingResult bindingResult;
        if (this.modelBinding != null && (bindingResult = this.modelBinding.getBindingResult()) != null && !Objects.equals(newValue = component.convertBindingValueToString(bindingResult), this.value)) {
            this.value = newValue;
            elementChanges.addChange(this.getXmlValue(), (Object)this.value);
        }
        return elementChanges;
    }

    @Override
    public void updateModel(Component component, ValueChange valueChange) {
        String stringAttributeValue = valueChange.getStringAttribute(this.getXmlValue());
        if (stringAttributeValue != null && !Objects.equals(stringAttributeValue, this.value)) {
            this.value = stringAttributeValue;
            this.updateBindingForValue(stringAttributeValue, this.modelBinding, this.value);
        }
    }

    @Override
    public ModelBinding getModelBinding() {
        return this.modelBinding;
    }

    @Override
    @JsonIgnore
    public void setModelBinding(ModelBinding modelBinding) {
        this.modelBinding = modelBinding;
    }
}

