/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Optional;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ActionBinding;
import pl.fhframework.binding.CallbackActionBinding;
import pl.fhframework.binding.IActionCallback;
import pl.fhframework.binding.IActionCallbackContext;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.InMessageEventData;
import pl.fhframework.model.forms.Dropdown;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.Iconable;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.attribute.IconAlignment;

@Control(parents={Dropdown.class, Repeater.class}, canBeDesigned=true)
public class DropdownItem
extends FormElement
implements Iconable {
    private static final String ATTR_ON_CLICK = "onClick";
    public static final String ATTR_URL = "url";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_ICON = "icon";
    private String value = "Set value";
    private String url;
    @XMLProperty
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @DocumentedComponentAttribute(value="If the DropdownItem is clicked that method will be executed. Action is fired, while component is active.")
    private ActionBinding onClick;
    @JsonIgnore
    @XMLProperty(value="icon")
    @DocumentedComponentAttribute(boundable=true, value="Icon id. Please refer to http://fontawesome.io/icons/ for all available icons.")
    private ModelBinding iconBinding;
    private String icon;
    @XMLProperty(defaultValue="before")
    @DocumentedComponentAttribute(defaultValue="before", boundable=true, value="Icon alignment - possible values are before or after. Final alignment depends of component where this attribute is used.")
    private IconAlignment iconAlignment;
    @JsonIgnore
    @XMLProperty(required=true, value="value")
    @DocumentedComponentAttribute(boundable=true, value="Represents text value for created component.")
    private ModelBinding modelBindingForValue;
    @JsonIgnore
    @XMLProperty(value="url")
    @DocumentedComponentAttribute(boundable=true, value="Hyperlink to resource")
    private ModelBinding modelBindingForUrl;

    public DropdownItem(Form form) {
        super(form);
    }

    public void init() {
        BindingResult bindingResult;
        super.init();
        if (this.modelBindingForUrl != null && (bindingResult = this.modelBindingForUrl.getBindingResult()) != null) {
            this.url = this.convertBindingValueToString(bindingResult);
        }
        if (this.modelBindingForValue != null && (bindingResult = this.modelBindingForValue.getBindingResult()) != null) {
            this.value = this.convertBindingValueToString(bindingResult);
        }
    }

    private void processValue(ElementChanges elementChanges) {
        BindingResult bindingResult;
        if (this.modelBindingForValue != null && (bindingResult = this.modelBindingForValue.getBindingResult()) != null) {
            String newLabelValue = this.convertValueToString(bindingResult.getValue(), null);
            if (this.iconBinding != null) {
                this.icon = this.resolveIconBinding(this, elementChanges);
            }
            if (!this.areValuesTheSame(newLabelValue, this.value)) {
                this.refreshView();
                this.value = newLabelValue;
                elementChanges.addChange(ATTR_VALUE, (Object)this.value);
            }
        }
    }

    private void processURL(ElementChanges elementChanges) {
        String newUrl;
        BindingResult bindingResultForUrl;
        if (this.modelBindingForUrl != null && (bindingResultForUrl = this.modelBindingForUrl.getBindingResult()) != null && !this.areValuesTheSame(newUrl = this.convertValueToString(bindingResultForUrl.getValue(), null), this.url)) {
            this.refreshView();
            this.url = newUrl;
            elementChanges.addChange(ATTR_URL, (Object)this.url);
        }
    }

    public ElementChanges updateView() {
        ElementChanges elementChanges = super.updateView();
        this.processValue(elementChanges);
        this.processURL(elementChanges);
        return elementChanges;
    }

    public Optional<ActionBinding> getEventHandler(InMessageEventData eventData) {
        if (eventData.getEventType().equals(ATTR_ON_CLICK)) {
            return Optional.ofNullable(this.onClick);
        }
        return super.getEventHandler(eventData);
    }

    public ModelBinding getIconBinding() {
        return this.iconBinding;
    }

    public void setOnClick(ActionBinding onClick) {
        this.onClick = onClick;
    }

    public IActionCallbackContext setOnClick(IActionCallback onClick) {
        return CallbackActionBinding.createAndSet((IActionCallback)onClick, this::setOnClick);
    }

    public String getValue() {
        return this.value;
    }

    public String getUrl() {
        return this.url;
    }

    public ActionBinding getOnClick() {
        return this.onClick;
    }

    public void setIconBinding(ModelBinding iconBinding) {
        this.iconBinding = iconBinding;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public IconAlignment getIconAlignment() {
        return this.iconAlignment;
    }

    public void setIconAlignment(IconAlignment iconAlignment) {
        this.iconAlignment = iconAlignment;
    }

    public ModelBinding getModelBindingForValue() {
        return this.modelBindingForValue;
    }

    public void setModelBindingForValue(ModelBinding modelBindingForValue) {
        this.modelBindingForValue = modelBindingForValue;
    }

    public ModelBinding getModelBindingForUrl() {
        return this.modelBindingForUrl;
    }

    public void setModelBindingForUrl(ModelBinding modelBindingForUrl) {
        this.modelBindingForUrl = modelBindingForUrl;
    }
}

